/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.StylableDrawable;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class Label
extends StylableDrawable {
    private static final long serialVersionUID = 374045708533704103L;
    public static final Key ALIGNMENT_X = new Key("label.alignment.x");
    public static final Key ALIGNMENT_Y = new Key("label.alignment.y");
    public static final Key FONT = new Key("label.font");
    public static final Key ROTATION = new Key("label.rotation");
    public static final Key COLOR = new Key("label.color");
    public static final Key ALIGNMENT_TEXT = new Key("label.alignment.text");
    public static final Key WORD_WRAP = new Key("label.wordWrap");
    private String a;
    private transient Shape b;
    private transient Shape c;

    public Label() {
        this("");
    }

    public Label(String string) {
        this.a = string;
        this.setSettingDefault(ALIGNMENT_X, 0.5);
        this.setSettingDefault(ALIGNMENT_Y, 0.5);
        this.setSettingDefault(FONT, Font.decode(null));
        this.setSettingDefault(ROTATION, 0.0);
        this.setSettingDefault(COLOR, Color.BLACK);
        this.setSettingDefault(ALIGNMENT_TEXT, 0.5);
        this.setSettingDefault(WORD_WRAP, Boolean.FALSE);
    }

    public void draw(DrawingContext object) {
        boolean bl = (Boolean)this.getSetting(WORD_WRAP);
        Shape shape = this.getCachedOutline(bl);
        if (shape == null) {
            return;
        }
        Object object2 = shape.getBounds2D();
        double d = DataUtils.getValueOrDefault((Number)this.getSetting(ROTATION), 0.0);
        if (MathUtils.isCalculatable(d) && d != 0.0) {
            shape = AffineTransform.getRotateInstance(Math.toRadians(-d), ((RectangularShape)object2).getCenterX(), ((RectangularShape)object2).getCenterY()).createTransformedShape(shape);
            object2 = shape.getBounds2D();
        }
        Graphics2D graphics2D = ((DrawingContext)object).getGraphics();
        object = graphics2D.getTransform();
        double d2 = this.getX() - ((RectangularShape)object2).getX();
        double d3 = this.getY() - ((RectangularShape)object2).getY();
        double d4 = ((Number)this.getSetting(ALIGNMENT_X)).doubleValue();
        double d5 = ((Number)this.getSetting(ALIGNMENT_Y)).doubleValue();
        graphics2D.translate(d2 += d4 * (this.getWidth() - ((RectangularShape)object2).getWidth()), d3 += d5 * (this.getHeight() - ((RectangularShape)object2).getHeight()));
        object2 = (Paint)this.getSetting(COLOR);
        GraphicsUtils.fillPaintedShape(graphics2D, shape, (Paint)object2, null);
        graphics2D.setTransform((AffineTransform)object);
    }

    public Dimension2D getPreferredSize() {
        Dimension2D dimension2D = super.getPreferredSize();
        if (this.getCachedOutline(false) != null) {
            Shape shape = this.getTextRectangle();
            Rectangle2D rectangle2D = shape.getBounds2D();
            double d = DataUtils.getValueOrDefault((Number)this.getSetting(ROTATION), 0.0);
            if (MathUtils.isCalculatable(d) && d != 0.0) {
                shape = AffineTransform.getRotateInstance(Math.toRadians(-d), rectangle2D.getCenterX(), rectangle2D.getCenterY()).createTransformedShape(shape);
            }
            dimension2D.setSize(shape.getBounds2D().getWidth(), shape.getBounds2D().getHeight());
        }
        return dimension2D;
    }

    protected Shape getOutline(boolean bl) {
        double d;
        Font font = (Font)this.getSetting(FONT);
        float f = 0.0f;
        if (bl) {
            d = Math.toRadians(((Number)this.getSetting(ROTATION)).doubleValue());
            f = (float)(Math.abs(Math.cos(d)) * this.getWidth() + Math.abs(Math.sin(d)) * this.getHeight());
        }
        d = ((Number)this.getSetting(ALIGNMENT_TEXT)).doubleValue();
        return GraphicsUtils.getOutline(this.getText(), font, f, d);
    }

    protected Shape getCachedOutline(boolean bl) {
        if (!this.isValid() && this.getText() != null && !this.getText().isEmpty()) {
            this.b = this.getOutline(true);
            this.c = this.getOutline(false);
        }
        if (bl) {
            return this.b;
        }
        return this.c;
    }

    public Rectangle2D getTextRectangle() {
        return this.getCachedOutline(false).getBounds();
    }

    public String getText() {
        return this.a;
    }

    public void setText(String string) {
        this.a = string;
        this.invalidate();
    }

    protected void invalidate() {
        this.b = null;
        this.c = null;
    }

    protected boolean isValid() {
        if (((Boolean)this.getSetting(WORD_WRAP)).booleanValue()) {
            return this.b != null;
        }
        return this.c != null;
    }

    public void settingChanged(SettingChangeEvent serializable) {
        if (ROTATION.equals(serializable = serializable.getKey()) || FONT.equals(serializable) || ALIGNMENT_TEXT.equals(serializable) || WORD_WRAP.equals(serializable)) {
            this.invalidate();
        }
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        super.setBounds(d, d2, d3, d4);
        if (d3 != d5 || d4 != d6) {
            this.invalidate();
        }
    }
}

