/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawableContainer;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.EdgeLayout;
import de.erichseifert.gral.graphics.Layout;
import de.erichseifert.gral.graphics.OuterEdgeLayout;
import de.erichseifert.gral.plots.Label;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.PlotArea;
import de.erichseifert.gral.plots.StylableContainer;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.legends.Legend;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Location;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.Tuple;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlot
extends StylableContainer
implements DataListener,
Plot {
    private static final long serialVersionUID = -6609155385940228771L;
    private final List<DataSource> a;
    private final Set<DataSource> b;
    private final Map<String, Axis> c;
    private final Map<String, AxisRenderer> d;
    private final Map<String, Drawable> e;
    private final Map<Tuple, String> f;
    private final Map<String, Double> g;
    private final Map<String, Double> h;
    private final Label i = new Label();
    private PlotArea j;
    private final Container k;
    private Legend l;

    public AbstractPlot(DataSource ... dataSourceArray) {
        super(new EdgeLayout(20.0, 20.0));
        this.i.setSetting(Label.FONT, Font.decode(null).deriveFont(18.0f));
        this.k = new DrawableContainer(new OuterEdgeLayout(0.0));
        this.b = new HashSet<DataSource>();
        this.c = new HashMap<String, Axis>();
        this.d = new HashMap<String, AxisRenderer>();
        this.e = new HashMap<String, Drawable>();
        this.f = new HashMap<Tuple, String>();
        this.g = new HashMap<String, Double>();
        this.h = new HashMap<String, Double>();
        this.a = new LinkedList<DataSource>();
        for (DataSource dataSource : dataSourceArray) {
            this.add(dataSource);
        }
        this.setSettingDefault(TITLE, null);
        this.setSettingDefault(TITLE_FONT, Font.decode(null).deriveFont(18.0f));
        this.setSettingDefault(BACKGROUND, null);
        this.setSettingDefault(BORDER, null);
        this.setSettingDefault(COLOR, Color.BLACK);
        this.setSettingDefault(LEGEND, false);
        this.setSettingDefault(LEGEND_LOCATION, Location.CENTER);
        this.setSettingDefault(LEGEND_DISTANCE, 2.0);
        this.add(this.i, (Object)Location.NORTH);
    }

    @Override
    public void draw(DrawingContext drawingContext) {
        Graphics2D graphics2D = drawingContext.getGraphics();
        Object object = (Paint)this.getSetting(BACKGROUND);
        if (object != null) {
            GraphicsUtils.fillPaintedShape(graphics2D, this.getBounds(), (Paint)object, null);
        }
        if ((object = (Stroke)this.getSetting(BORDER)) != null) {
            Paint paint = (Paint)this.getSetting(COLOR);
            GraphicsUtils.drawPaintedShape(graphics2D, this.getBounds(), paint, null, (Stroke)object);
        }
        this.drawComponents(drawingContext);
    }

    protected void drawAxes(DrawingContext drawingContext) {
        for (Drawable drawable : this.e.values()) {
            if (drawable == null) continue;
            drawable.draw(drawingContext);
        }
    }

    protected void drawLegend(DrawingContext drawingContext) {
        Boolean bl = (Boolean)this.getSetting(LEGEND);
        if (bl == null || !bl.booleanValue() || this.getLegend() == null) {
            return;
        }
        this.getLegend().draw(drawingContext);
    }

    @Override
    public void layout() {
        super.layout();
        this.layoutAxes();
        this.layoutLegend();
    }

    protected void layoutAxes() {
    }

    protected void layoutLegend() {
        if (this.getPlotArea() == null) {
            return;
        }
        Container container = this.getLegendContainer();
        Rectangle2D rectangle2D = this.getPlotArea().getBounds();
        container.setBounds(rectangle2D);
    }

    @Override
    public Axis getAxis(String string) {
        return this.c.get(string);
    }

    @Override
    public void setAxis(String string, Axis axis) {
        if (axis == null) {
            this.removeAxis(string);
            return;
        }
        this.c.put(string, axis);
    }

    @Override
    public void removeAxis(String string) {
        this.c.remove(string);
        this.d.remove(string);
        this.e.remove(string);
    }

    @Override
    public Collection<String> getAxesNames() {
        return this.c.keySet();
    }

    protected void createDefaultAxes() {
    }

    protected void createDefaultAxisRenderers() {
    }

    protected void autoscaleAxes() {
        if (this.a.isEmpty()) {
            return;
        }
        for (String string : this.getAxesNames()) {
            this.autoscaleAxis(string);
        }
    }

    @Override
    public void autoscaleAxis(String string) {
        Axis axis = this.getAxis(string);
        if (axis == null || !axis.isAutoscaled()) {
            return;
        }
        double d = this.getAxisMin(string);
        double d2 = this.getAxisMax(string);
        double d3 = 0.0 * (d2 - d);
        axis.setRange(d - d3, d2 + d3);
    }

    @Override
    public AxisRenderer getAxisRenderer(String string) {
        return this.d.get(string);
    }

    @Override
    public void setAxisRenderer(String object, AxisRenderer object2) {
        Object object3 = null;
        if (object2 == null) {
            this.d.remove(object);
        } else {
            this.d.put((String)object, (AxisRenderer)object2);
            object3 = this.getAxis((String)object);
            object3 = object2.getRendererComponent((Axis)object3);
        }
        object2 = object;
        object = this;
        if (object3 == null) {
            ((AbstractPlot)object).e.remove(object2);
        } else {
            ((AbstractPlot)object).e.put((String)object2, (Drawable)object3);
        }
        this.layout();
    }

    protected Drawable getAxisComponent(String string) {
        return this.e.get(string);
    }

    @Override
    public PlotArea getPlotArea() {
        return this.j;
    }

    protected void setPlotArea(PlotArea plotArea) {
        if (this.j != null) {
            this.remove(this.j);
        }
        this.j = plotArea;
        if (this.j != null) {
            this.add(this.j, (Object)Location.CENTER);
        }
    }

    @Override
    public Label getTitle() {
        return this.i;
    }

    protected Container getLegendContainer() {
        return this.k;
    }

    @Override
    public Legend getLegend() {
        return this.l;
    }

    protected void setLegend(Legend legend) {
        if (this.l != null) {
            this.k.remove(this.l);
            this.l.clear();
        }
        this.l = legend;
        if (this.l != null) {
            Location location = (Location)((Object)this.getSetting(LEGEND_LOCATION));
            this.k.add(legend, (Object)location);
            for (DataSource dataSource : this.getVisibleData()) {
                legend.add(dataSource);
            }
        }
    }

    @Override
    public void settingChanged(SettingChangeEvent object) {
        if (TITLE.equals(object = ((SettingChangeEvent)object).getKey())) {
            object = (String)this.getSetting(TITLE);
            if (object == null) {
                object = "";
            }
            this.i.setText((String)object);
            return;
        }
        if (TITLE_FONT.equals(object)) {
            object = (Font)this.getSetting(TITLE_FONT);
            if (object == null) {
                object = Font.decode(null).deriveFont(18.0f);
            }
            this.i.setSetting(Label.FONT, object);
            return;
        }
        if (LEGEND_LOCATION.equals(object)) {
            object = (Location)((Object)this.getSetting(LEGEND_LOCATION));
            if (this.l != null) {
                this.k.remove(this.l);
                this.k.add(this.l, object);
            }
            return;
        }
        if (LEGEND_DISTANCE.equals(object)) {
            double d = DataUtils.getValueOrDefault((Number)this.getSetting(LEGEND_DISTANCE), Double.NaN);
            d = MathUtils.isCalculatable(d) ? (d *= 10.0) : 0.0;
            object = new OuterEdgeLayout(d);
            this.k.setLayout((Layout)object);
        }
    }

    @Override
    public void add(DataSource dataSource) {
        this.add(dataSource, true);
    }

    @Override
    public void add(DataSource dataSource, boolean bl) {
        this.add(this.a.size(), dataSource, bl);
    }

    @Override
    public void add(int n, DataSource dataSource, boolean bl) {
        this.a.add(n, dataSource);
        if (bl) {
            this.b.add(dataSource);
        }
        this.autoscaleAxes();
        if (this.getLegend() != null) {
            this.getLegend().add(dataSource);
        }
        dataSource.addDataListener(this);
        this.a();
    }

    @Override
    public boolean contains(DataSource dataSource) {
        return this.a.contains(dataSource);
    }

    @Override
    public DataSource get(int n) {
        return this.a.get(n);
    }

    @Override
    public boolean remove(DataSource dataSource) {
        dataSource.removeDataListener(this);
        this.b.remove(dataSource);
        if (this.getLegend() != null) {
            this.getLegend().remove(dataSource);
        }
        boolean bl = this.a.remove(dataSource);
        this.a();
        return bl;
    }

    @Override
    public void clear() {
        Iterator<DataSource> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeDataListener(this);
        }
        this.b.clear();
        if (this.getLegend() != null) {
            this.getLegend().clear();
        }
        this.a.clear();
        this.a();
    }

    @Override
    public String[] getMapping(DataSource dataSource) {
        String[] stringArray = new String[dataSource.getColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n = i;
            AbstractPlot abstractPlot = this;
            Object object = dataSource;
            if (!abstractPlot.contains((DataSource)object)) {
                string = null;
            } else {
                object = new Tuple(object, n);
                string = abstractPlot.f.get(object);
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    @Override
    public void setMapping(DataSource dataSource, String ... stringArray) {
        if (!this.contains(dataSource)) {
            throw new IllegalArgumentException("Data source does not exist in plot.");
        }
        if (stringArray.length > dataSource.getColumnCount()) {
            throw new IllegalArgumentException(MessageFormat.format("Data source only has {0,number,integer} column, {1,number,integer} values given.", dataSource.getColumnCount(), stringArray.length));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            Tuple tuple = new Tuple(dataSource, i);
            this.f.put(tuple, string);
        }
        this.a();
    }

    protected Double getAxisMin(String string) {
        Double d = this.g.get(string);
        if (d == null) {
            this.b();
            d = this.g.get(string);
        }
        if (d == null) {
            d = 0.0;
        }
        return d;
    }

    protected Double getAxisMax(String string) {
        Double d = this.h.get(string);
        if (d == null) {
            this.b();
            d = this.h.get(string);
        }
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public List<DataSource> getData() {
        return Collections.unmodifiableList(this.a);
    }

    @Override
    public List<DataSource> getVisibleData() {
        LinkedList<DataSource> linkedList = new LinkedList<DataSource>();
        for (DataSource dataSource : this.a) {
            if (!this.b.contains(dataSource)) continue;
            linkedList.add(dataSource);
        }
        return linkedList;
    }

    @Override
    public boolean isVisible(DataSource dataSource) {
        return this.b.contains(dataSource);
    }

    @Override
    public void setVisible(DataSource dataSource, boolean bl) {
        if (bl) {
            if (this.b.add(dataSource)) {
                this.a();
                return;
            }
        } else if (this.b.remove(dataSource)) {
            this.a();
        }
    }

    @Override
    public void dataAdded(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.dataChanged(dataSource, dataChangeEventArray);
    }

    @Override
    public void dataUpdated(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.dataChanged(dataSource, dataChangeEventArray);
    }

    @Override
    public void dataRemoved(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.dataChanged(dataSource, dataChangeEventArray);
    }

    protected void dataChanged(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.a();
        if (this.getLegend() != null) {
            this.getLegend().refresh();
        }
        this.autoscaleAxes();
        this.layout();
    }

    private void a() {
        this.g.clear();
        this.h.clear();
    }

    private void b() {
        AbstractPlot abstractPlot = this;
        synchronized (abstractPlot) {
            for (Map.Entry<Tuple, String> entry : this.f.entrySet()) {
                Serializable serializable = entry.getKey();
                Object object = (DataSource)((Tuple)serializable).get(0);
                if (object.getRowCount() == 0) continue;
                serializable = object.getColumn((Integer)((Tuple)serializable).get(1));
                entry = entry.getValue();
                object = this.g.get(entry);
                Double d = this.h.get(entry);
                if (object == null || d == null) {
                    object = ((Column)serializable).getStatistics("min");
                    d = ((Column)serializable).getStatistics("max");
                } else {
                    object = Math.min((Double)object, ((Column)serializable).getStatistics("min"));
                    d = Math.max(d, ((Column)serializable).getStatistics("max"));
                }
                this.g.put((String)((Object)entry), (Double)object);
                this.h.put((String)((Object)entry), d);
            }
            return;
        }
    }

    private void readObject(ObjectInputStream object) throws ClassNotFoundException, IOException {
        ((ObjectInputStream)object).defaultReadObject();
        object = this.getData().iterator();
        while (object.hasNext()) {
            ((DataSource)object.next()).addDataListener(this);
        }
    }
}

