/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.plots;

import de.erichseifert.gral.io.AbstractIOFactory;
import de.erichseifert.gral.io.plots.DrawableWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrawableWriterFactory
extends AbstractIOFactory<DrawableWriter> {
    private static DrawableWriterFactory a;

    private DrawableWriterFactory() throws IOException {
        super("drawablewriters.properties");
    }

    public static DrawableWriterFactory getInstance() {
        if (a == null) {
            try {
                a = new DrawableWriterFactory();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return a;
    }

    @Override
    public final DrawableWriter get(String string) {
        DrawableWriter drawableWriter = null;
        Class clazz = this.getTypeClass(string);
        try {
            if (clazz != null) {
                drawableWriter = (DrawableWriter)clazz.getDeclaredConstructor(String.class).newInstance(string);
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (drawableWriter == null) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported MIME type: {0}", string));
        }
        return drawableWriter;
    }
}

