/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.plots;

import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.IOCapabilitiesStorage;
import de.erichseifert.gral.io.plots.DrawableWriter;
import de.erichseifert.gral.util.Messages;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class BitmapWriter
extends IOCapabilitiesStorage
implements DrawableWriter {
    private final String a;
    private int b;

    protected BitmapWriter(String string) {
        boolean bl;
        this.a = string;
        boolean bl2 = "image/png".equals(string);
        boolean bl3 = !"image/vnd.wap.wbmp".equals(string);
        boolean bl4 = bl = !"image/vnd.wap.wbmp".equals(string);
        if (bl3) {
            if (bl2) {
                this.b = 2;
                return;
            }
            this.b = 1;
            return;
        }
        if (bl) {
            this.b = 10;
            return;
        }
        this.b = 12;
    }

    public void write(Drawable drawable, OutputStream outputStream, double d, double d2) throws IOException {
        this.write(drawable, outputStream, 0.0, 0.0, d, d2);
    }

    public void write(Drawable drawable, OutputStream closeable, double d, double d2, double d3, double d4) throws IOException {
        BufferedImage bufferedImage = new BufferedImage((int)Math.ceil(d3), (int)Math.ceil(d4), this.b);
        DrawingContext drawingContext = new DrawingContext((Graphics2D)bufferedImage.getGraphics());
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(this.getMimeType());
        if (iterator.hasNext()) {
            iterator = iterator.next();
            closeable = ImageIO.createImageOutputStream(closeable);
            ((ImageWriter)((Object)iterator)).setOutput(closeable);
            Rectangle2D rectangle2D = drawable.getBounds();
            drawable.setBounds(d, d2, d3, d4);
            try {
                drawable.draw(drawingContext);
                ((ImageWriter)((Object)iterator)).write(bufferedImage);
                return;
            }
            finally {
                drawable.setBounds(rectangle2D);
                closeable.close();
            }
        }
    }

    public String getMimeType() {
        return this.a;
    }

    static {
        BitmapWriter.addCapabilities(new IOCapabilities("BMP", Messages.getString("ImageIO.bmpDescription"), "image/bmp", new String[]{"bmp", "dib"}));
        BitmapWriter.addCapabilities(new IOCapabilities("GIF", Messages.getString("ImageIO.gifDescription"), "image/gif", new String[]{"gif"}));
        BitmapWriter.addCapabilities(new IOCapabilities("JPEG/JFIF", Messages.getString("ImageIO.jpegDescription"), "image/jpeg", new String[]{"jpg", "jpeg", "jpe", "jif", "jfif", "jfi"}));
        BitmapWriter.addCapabilities(new IOCapabilities("PNG", Messages.getString("ImageIO.pngDescription"), "image/png", new String[]{"png"}));
        BitmapWriter.addCapabilities(new IOCapabilities("WBMP", Messages.getString("ImageIO.wbmpDescription"), "image/vnd.wap.wbmp", new String[]{"wbmp"}));
    }
}

