/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.io.AbstractIOFactory;
import de.erichseifert.gral.io.data.DataReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataReaderFactory
extends AbstractIOFactory<DataReader> {
    private static DataReaderFactory a;

    private DataReaderFactory() throws IOException {
        super("datareaders.properties");
    }

    public static DataReaderFactory getInstance() {
        if (a == null) {
            try {
                a = new DataReaderFactory();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return a;
    }

    @Override
    public final DataReader get(String string) {
        DataReader dataReader = null;
        Class clazz = this.getTypeClass(string);
        try {
            if (clazz != null) {
                dataReader = (DataReader)clazz.getDeclaredConstructor(String.class).newInstance(string);
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (dataReader == null) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported MIME type: {0}", string));
        }
        return dataReader;
    }
}

