/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Vector;

public class XYPlot
extends Canvas {
    Container pappy;
    Dimension minSize;
    int width;
    int height;
    Vector xSegments;
    Vector ySegments;
    double[] xData;
    double[] yData;
    int xOffset = 40;
    int yOffset = 40;
    int xTickWidth = 100;
    int yTickWidth = 100;
    double minX;
    double zoomMinX = this.minX = 0.0;
    double maxX;
    double zoomMaxX = this.maxX = 10.0;
    double minY;
    double zoomMinY = this.minY = 0.0;
    double maxY;
    double zoomMaxY = this.maxY = 10.0;
    private double xScale;
    private double yScale;
    String title = "Title";
    String xLabel = "X Label";
    String yLabel = "Y Label";
    double mouseDownX;
    double mouseDownY;
    boolean DEBUG = false;

    public XYPlot(Container parent) {
        this.pappy = parent;
        this.width = 600;
        this.height = 600;
        this.minSize = new Dimension(this.width, this.height);
    }

    public XYPlot(Container parent, int width, int height) {
        this.pappy = parent;
        this.width = width;
        this.height = height;
        this.minSize = new Dimension(width, height);
    }

    @Override
    public Dimension preferredSize() {
        return this.minimumSize();
    }

    @Override
    public synchronized Dimension minimumSize() {
        return this.minSize;
    }

    public Insets insets() {
        return new Insets(5, 5, 5, 5);
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fontMetrics = g.getFontMetrics();
        this.xScale = ((double)this.width - 2.0 * (double)this.xOffset) / (this.zoomMaxX - this.zoomMinX);
        this.yScale = ((double)this.height - 2.0 * (double)this.yOffset) / (this.zoomMaxY - this.zoomMinY);
        if (this.DEBUG) {
            System.out.println("xOffset " + this.xOffset + " yOffset " + this.yOffset + " minX " + this.minX + " maxX " + this.maxX + " minY " + this.minY + " maxY " + this.maxY + " xScale " + this.xScale + " yScale " + this.yScale);
        }
        g.drawRect(0, 0, this.width - 1, this.height - 1);
        g.drawLine(this.xOffset, this.yOffset, this.xOffset, this.height - this.yOffset);
        g.drawLine(this.xOffset, this.height - this.yOffset, this.width - this.xOffset, this.height - this.yOffset);
        g.drawString(this.title, (this.width - fontMetrics.stringWidth(this.title)) / 2, this.yOffset - fontMetrics.getDescent() - fontMetrics.getLeading());
        g.drawString(this.xLabel, (this.width - fontMetrics.stringWidth(this.xLabel)) / 2, this.height - fontMetrics.getDescent() - fontMetrics.getLeading());
        int i = 0;
        while ((double)(i * this.xTickWidth) >= this.zoomMinX && (double)(i * this.xTickWidth) <= this.zoomMaxX) {
            g.drawLine(this.xOffset + (int)(this.xScale * ((double)(i * this.xTickWidth) - this.zoomMinX)), this.height - this.yOffset, this.xOffset + (int)(this.xScale * ((double)(i * this.xTickWidth) - this.zoomMinX)), this.height - (int)(0.75 * (double)this.yOffset));
            g.drawString("" + i * this.xTickWidth, this.xOffset + (int)(this.xScale * ((double)(i * this.xTickWidth) - this.zoomMinX)), this.height - fontMetrics.getAscent() - fontMetrics.getLeading());
            ++i;
        }
        i = 0;
        while ((double)(i * this.yTickWidth) >= this.zoomMinY && (double)(i * this.yTickWidth) <= this.zoomMaxY) {
            g.drawLine(this.xOffset, this.height - this.yOffset - (int)(this.yScale * ((double)(i * this.yTickWidth) - this.zoomMinY)), (int)(0.75 * (double)this.xOffset), this.height - this.yOffset - (int)(this.yScale * ((double)(i * this.yTickWidth) - this.zoomMinY)));
            g.drawString("" + i * this.yTickWidth, 0, this.height - this.yOffset - (int)(this.yScale * ((double)(i * this.yTickWidth) - this.zoomMinY)));
            ++i;
        }
        this.plotData(g);
    }

    public void plotData(Graphics g) {
        if (this.xSegments != null && this.ySegments != null) {
            if (this.xSegments.size() != this.ySegments.size()) {
                System.out.println("xSegments.size() != ySegments.size()");
            }
            for (int segNum = 0; segNum < this.xSegments.size(); ++segNum) {
                g.setColor(this.colorForSegment(segNum));
                this.xData = (double[])this.xSegments.elementAt(segNum);
                this.yData = (double[])this.ySegments.elementAt(segNum);
                if (this.xData != null) {
                    if (this.xData.length != this.yData.length || this.xData.length <= 0) continue;
                    for (int i = 0; i < this.xData.length - 1; ++i) {
                        g.drawLine(this.xOffset + (int)(this.xScale * (this.xData[i] - this.zoomMinX)), this.height - this.yOffset - (int)(this.yScale * (this.yData[i] - this.zoomMinY)), this.xOffset + (int)(this.xScale * (this.xData[i + 1] - this.zoomMinX)), this.height - this.yOffset - (int)(this.yScale * (this.yData[i + 1] - this.zoomMinY)));
                    }
                    continue;
                }
                System.out.println("null data");
            }
        }
        g.setColor(Color.black);
    }

    public Color colorForSegment(int segNum) {
        if (this.xSegments.size() == 1) {
            return Color.black;
        }
        int colorInc = (int)Math.floor(255 / (this.xSegments.size() - 1));
        return new Color(segNum * colorInc, 255 - segNum * colorInc, segNum % 3 * 127);
    }

    public void plot() {
        this.xData = new double[2];
        this.yData = new double[2];
        this.xData[0] = this.minX;
        this.yData[0] = this.minY;
        this.xData[1] = this.maxX;
        this.yData[1] = this.maxY;
        this.xSegments.addElement(this.xData);
        this.ySegments.addElement(this.yData);
        this.xData = null;
        this.yData = null;
    }

    @Override
    public boolean mouseDown(Event evt, int x, int y) {
        this.mouseDownX = x;
        this.mouseDownY = y;
        return true;
    }

    @Override
    public boolean mouseUp(Event evt, int mouseUpX, int mouseUpY) {
        if (Math.abs(this.mouseDownX - (double)mouseUpX) + Math.abs(this.mouseDownY - (double)mouseUpY) > 5.0) {
            double tempDown = (this.mouseDownX - (double)this.xOffset) / this.xScale + this.zoomMinX;
            double tempUp = (double)(mouseUpX - this.xOffset) / this.xScale + this.zoomMinX;
            if (tempDown > tempUp) {
                this.zoomMinX = tempUp;
                this.zoomMaxX = tempDown;
            } else {
                this.zoomMinX = tempDown;
                this.zoomMaxX = tempUp;
            }
            tempDown = (this.mouseDownY - (double)this.yOffset) / this.yScale + this.zoomMinY;
            tempUp = (double)(mouseUpY - this.yOffset) / this.yScale + this.zoomMinY;
            if (tempDown > tempUp) {
                this.zoomMinY = tempUp;
                this.zoomMaxY = tempDown;
            } else {
                this.zoomMinY = tempDown;
                this.zoomMaxY = tempUp;
            }
            this.repaint();
        }
        return true;
    }
}

