/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SeismicPhase
implements Serializable,
Cloneable {
    public transient boolean DEBUG = TauP_Time.DEBUG;
    public transient boolean verbose = false;
    public static transient boolean expert = TauP_Time.expert;
    protected TauModel tMod;
    public static final int TURN = 0;
    public static final int REFLECT_UNDERSIDE = 1;
    public static final int REFLECT_TOPSIDE = 2;
    public static final int TRANSUP = 3;
    public static final int TRANSDOWN = 4;
    protected static double maxRefraction = 20.0;
    protected static double maxDiffraction = 60.0;
    protected double sourceDepth;
    protected double receiverDepth = 0.0;
    protected double[] dist = new double[0];
    protected double[] time = new double[0];
    protected double[] rayParams = new double[0];
    protected double minRayParam;
    protected double maxRayParam;
    protected int maxRayParamIndex = -1;
    protected int minRayParamIndex = -1;
    protected double minDistance = 0.0;
    protected double maxDistance = Double.MAX_VALUE;
    protected List<Integer> branchSeq = new ArrayList<Integer>();
    protected String name;
    protected String puristName;
    protected ArrayList<String> legs = new ArrayList();
    protected transient int currBranch;
    protected ArrayList<Integer> legAction = new ArrayList();
    protected ArrayList<Boolean> downGoing = new ArrayList();
    protected ArrayList<Boolean> waveType = new ArrayList();
    protected double refineDistToleranceRadian = 8.552113334772214E-5;
    protected int maxRecursion = 5;
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;
    private String validationFailMessage = "";

    public SeismicPhase(String name, String modelName, double depth) throws TauModelException {
        this(name, TauModelLoader.load(modelName).depthCorrect(depth));
    }

    public SeismicPhase(String name, TauModel tMod) throws TauModelException {
        this(name, tMod, 0.0);
    }

    public SeismicPhase(String name, TauModel tMod, double receiverDepth) throws TauModelException {
        this.name = name;
        this.sourceDepth = tMod.getSourceDepth();
        this.receiverDepth = receiverDepth;
        this.tMod = tMod.splitBranch(receiverDepth);
        this.legs = SeismicPhase.legPuller(name);
        this.createPuristName(tMod);
        this.parseName(tMod);
        this.sumBranches(tMod);
    }

    public boolean phasesExistsInModel() {
        return this.getMaxRayParam() >= 0.0;
    }

    public Arrival getEarliestArrival(double degrees) {
        double soonest = 9.99999999E8;
        Arrival soonestArrival = null;
        List<Arrival> arrivals = this.calcTime(degrees);
        for (Arrival a : arrivals) {
            if (!(a.getTime() < soonest)) continue;
            soonestArrival = a;
            soonest = a.getTime();
        }
        return soonestArrival;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public double getMinDistanceDeg() {
        return this.getMinDistance() * 180.0 / Math.PI;
    }

    public double getMinDistance() {
        return this.minDistance;
    }

    public double getMaxDistanceDeg() {
        return this.getMaxDistance() * 180.0 / Math.PI;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    public double getMinRayParam() {
        return this.minRayParam;
    }

    public int getMaxRayParamIndex() {
        return this.maxRayParamIndex;
    }

    public int getMinRayParamIndex() {
        return this.minRayParamIndex;
    }

    public static double getMaxRefraction() {
        return maxRefraction;
    }

    public static void setMaxRefraction(double max) {
        maxRefraction = max;
    }

    public static double getMaxDiffraction() {
        return maxDiffraction;
    }

    public static void setMaxDiffraction(double max) {
        maxDiffraction = max;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.name;
    }

    public List<String> getLegs() {
        return Collections.unmodifiableList(this.legs);
    }

    public double getRayParams(int i) {
        return this.rayParams[i];
    }

    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    public double getDist(int i) {
        return this.dist[i];
    }

    public double[] getDist() {
        return (double[])this.dist.clone();
    }

    public double getTime(int i) {
        return this.time[i];
    }

    public double[] getTime() {
        return (double[])this.time.clone();
    }

    public double getTau(int i) {
        return this.time[i] - this.rayParams[i] * this.dist[i];
    }

    public double[] getTau() {
        double[] tau = new double[this.dist.length];
        for (int i = 0; i < this.dist.length; ++i) {
            tau[i] = this.time[i] - this.rayParams[i] * this.dist[i];
        }
        return tau;
    }

    public boolean[] getDownGoing() {
        Boolean[] b = this.downGoing.toArray(new Boolean[0]);
        boolean[] out = new boolean[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    public boolean[] getWaveType() {
        Boolean[] b = this.waveType.toArray(new Boolean[0]);
        boolean[] out = new boolean[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    public int[] getLegAction() {
        Integer[] b = this.legAction.toArray(new Integer[0]);
        int[] out = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    public boolean hasArrivals() {
        return this.dist != null && this.dist.length != 0;
    }

    public List<Arrival> calcTime(double deg) {
        double tempDeg = deg;
        if (tempDeg < 0.0) {
            tempDeg *= -1.0;
        }
        while (tempDeg > 360.0) {
            tempDeg -= 360.0;
        }
        if (tempDeg > 180.0) {
            tempDeg = 360.0 - tempDeg;
        }
        double radDist = tempDeg * Math.PI / 180.0;
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        int n = 0;
        while ((double)n * 2.0 * Math.PI + radDist <= this.maxDistance) {
            int rayNum;
            double searchDist = (double)n * 2.0 * Math.PI + radDist;
            for (rayNum = 0; rayNum < this.dist.length - 1; ++rayNum) {
                if (searchDist == this.dist[rayNum + 1] && rayNum + 1 != this.dist.length - 1 || !((this.dist[rayNum] - searchDist) * (searchDist - this.dist[rayNum + 1]) >= 0.0) || this.rayParams[rayNum] == this.rayParams[rayNum + 1] && this.rayParams.length > 2) continue;
                if (this.DEBUG) {
                    System.err.println("SeismicPhase " + this.name + ", found arrival:\n" + "dist " + (float)(57.29577951308232 * this.dist[rayNum]) + " " + (float)(57.29577951308232 * searchDist) + " " + (float)(57.29577951308232 * this.dist[rayNum + 1]));
                }
                arrivals.add(this.refineArrival(rayNum, searchDist, this.refineDistToleranceRadian, this.maxRecursion));
            }
            searchDist = (double)(n + 1) * 2.0 * Math.PI - radDist;
            if (tempDeg != 180.0) {
                for (rayNum = 0; rayNum < this.dist.length - 1; ++rayNum) {
                    if (searchDist == this.dist[rayNum + 1] && rayNum + 1 != this.dist.length - 1 || !((this.dist[rayNum] - searchDist) * (searchDist - this.dist[rayNum + 1]) >= 0.0) || this.rayParams[rayNum] == this.rayParams[rayNum + 1] && this.rayParams.length > 2) continue;
                    if (this.DEBUG) {
                        System.err.println("SeismicPhase " + this.name + ", found arrival:\n" + "dist " + (float)(57.29577951308232 * this.dist[rayNum]) + " " + (float)(57.29577951308232 * searchDist) + " " + (float)(57.29577951308232 * this.dist[rayNum + 1]));
                    }
                    arrivals.add(this.refineArrival(rayNum, searchDist, this.refineDistToleranceRadian, this.maxRecursion));
                }
            }
            ++n;
        }
        Collections.sort(arrivals, new Comparator<Arrival>(){

            @Override
            public int compare(Arrival o1, Arrival o2) {
                return Double.compare(o1.getTime(), o2.getTime());
            }
        });
        return arrivals;
    }

    public Arrival refineArrival(int rayNum, double distRadian, double distTolRadian, int maxRecursion) {
        Arrival left = new Arrival(this, this.getTime(rayNum), this.getDist(rayNum), this.getRayParams(rayNum), rayNum, this.name, this.puristName, this.sourceDepth);
        Arrival right = new Arrival(this, this.getTime(rayNum + 1), this.getDist(rayNum + 1), this.getRayParams(rayNum + 1), rayNum, this.name, this.puristName, this.sourceDepth);
        return this.refineArrival(left, right, distRadian, distTolRadian, maxRecursion);
    }

    public Arrival refineArrival(Arrival leftEstimate, Arrival rightEstimate, double searchDist, double distTolRadian, int maxRecursion) {
        Arrival linInterp = this.linearInterpArrival(searchDist, leftEstimate, rightEstimate);
        if (maxRecursion <= 0 || this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1 || this.name.endsWith("kmps")) {
            return linInterp;
        }
        if (this.DEBUG) {
            System.err.println("Phase: " + this);
            System.err.println("Refine: " + maxRecursion + "\nleft:  " + leftEstimate + "\nright: " + rightEstimate + "\nlinInterp: " + linInterp);
        }
        try {
            Arrival shoot = this.shootRay(linInterp.getRayParam());
            if ((leftEstimate.getDist() - searchDist) * (searchDist - shoot.getDist()) > 0.0) {
                if (Math.abs(shoot.getDist() - linInterp.getDist()) < distTolRadian) {
                    return this.linearInterpArrival(searchDist, leftEstimate, shoot);
                }
                return this.refineArrival(leftEstimate, shoot, searchDist, distTolRadian, maxRecursion - 1);
            }
            if (Math.abs(shoot.getDist() - linInterp.getDist()) < distTolRadian) {
                return this.linearInterpArrival(searchDist, shoot, rightEstimate);
            }
            return this.refineArrival(shoot, rightEstimate, searchDist, distTolRadian, maxRecursion - 1);
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
        catch (SlownessModelException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public Arrival shootRay(double rayParam) throws SlownessModelException, NoSuchLayerException {
        if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1 || this.name.endsWith("kmps")) {
            throw new SlownessModelException("Unable to shoot ray in non-body waves");
        }
        if (rayParam < this.minRayParam || this.maxRayParam < rayParam) {
            throw new SlownessModelException("Ray param " + rayParam + " is outside range for this phase: min=" + this.minRayParam + " max=" + this.maxRayParam);
        }
        int rayParamIndex = -1;
        for (rayParamIndex = 0; rayParamIndex < this.rayParams.length - 1 && this.rayParams[rayParamIndex + 1] >= rayParam; ++rayParamIndex) {
        }
        int[][] timesBranches = this.calcBranchMultiplier();
        TimeDist sum = new TimeDist(rayParam);
        for (int j = 0; j < this.tMod.getNumBranches(); ++j) {
            TimeDist td;
            int botLayerNum;
            int topLayerNum;
            if (timesBranches[0][j] != 0) {
                topLayerNum = this.tMod.getSlownessModel().layerNumberBelow(this.tMod.getTauBranch(j, true).getTopDepth(), true);
                botLayerNum = this.tMod.getSlownessModel().layerNumberAbove(this.tMod.getTauBranch(j, true).getBotDepth(), true);
                td = this.tMod.getTauBranch(j, true).calcTimeDist(this.tMod.getSlownessModel(), topLayerNum, botLayerNum, rayParam, true);
                td = new TimeDist(rayParam, (double)timesBranches[0][j] * td.getTime(), (double)timesBranches[0][j] * td.getDistRadian(), td.getDepth());
                sum = sum.add(td);
            }
            if (timesBranches[1][j] == 0) continue;
            topLayerNum = this.tMod.getSlownessModel().layerNumberBelow(this.tMod.getTauBranch(j, false).getTopDepth(), false);
            botLayerNum = this.tMod.getSlownessModel().layerNumberAbove(this.tMod.getTauBranch(j, false).getBotDepth(), false);
            td = this.tMod.getTauBranch(j, false).calcTimeDist(this.tMod.getSlownessModel(), topLayerNum, botLayerNum, rayParam, true);
            td = new TimeDist(rayParam, (double)timesBranches[1][j] * td.getTime(), (double)timesBranches[1][j] * td.getDistRadian(), td.getDepth());
            sum = sum.add(td);
        }
        return new Arrival(this, sum.getTime(), sum.getDistRadian(), rayParam, rayParamIndex, this.name, this.puristName, this.sourceDepth);
    }

    private Arrival linearInterpArrival(double searchDist, Arrival left, Arrival right) {
        if (left.getRayParamIndex() == 0 && searchDist == this.dist[0]) {
            return new Arrival(this, this.time[0], searchDist, this.rayParams[0], 0, this.name, this.puristName, this.sourceDepth, 0.0, 0.0);
        }
        if (left.getDist() == searchDist) {
            return left;
        }
        double arrivalTime = (searchDist - left.getDist()) / (right.getDist() - left.getDist()) * (right.getTime() - left.getTime()) + left.getTime();
        if (Double.isNaN(arrivalTime)) {
            throw new RuntimeException("Time is NaN, search " + searchDist + " leftDist " + left.getDist() + " leftTime " + left.getTime() + "  rightDist " + right.getDist() + "  rightTime " + right.getTime());
        }
        double arrivalRayParam = (searchDist - right.getDist()) * (left.getRayParam() - right.getRayParam()) / (left.getDist() - right.getDist()) + right.getRayParam();
        return new Arrival(this, arrivalTime, searchDist, arrivalRayParam, left.getRayParamIndex(), this.name, this.puristName, this.sourceDepth);
    }

    public double calcRayParamForTakeoffAngle(double takeoffDegree) {
        VelocityModel vMod = this.getTauModel().getVelocityModel();
        try {
            double takeoffVelocity = this.getDownGoing()[0] ? vMod.evaluateBelow(this.sourceDepth, this.name.charAt(0)) : vMod.evaluateAbove(this.sourceDepth, this.name.charAt(0));
            double rayParam = (this.getTauModel().getRadiusOfEarth() - this.sourceDepth) * Math.sin(takeoffDegree * Math.PI / 180.0) / takeoffVelocity;
            return rayParam;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public double calcTakeoffAngle(double arrivalRayParam) {
        if (this.name.endsWith("kmps")) {
            return 0.0;
        }
        VelocityModel vMod = this.getTauModel().getVelocityModel();
        try {
            double takeoffVelocity = this.getDownGoing()[0] ? vMod.evaluateBelow(this.sourceDepth, this.name.charAt(0)) : vMod.evaluateAbove(this.sourceDepth, this.name.charAt(0));
            double takeoffAngle = 57.29577951308232 * Math.asin(takeoffVelocity * arrivalRayParam / (this.getTauModel().getRadiusOfEarth() - this.sourceDepth));
            if (!this.getDownGoing()[0]) {
                takeoffAngle = 180.0 - takeoffAngle;
            }
            return takeoffAngle;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public double calcIncidentAngle(double arrivalRayParam) {
        if (this.name.endsWith("kmps")) {
            return 0.0;
        }
        VelocityModel vMod = this.getTauModel().getVelocityModel();
        try {
            char lastLeg = this.getLegs().get(this.getLegs().size() - 2).charAt(0);
            double incidentVelocity = this.getDownGoing()[this.getDownGoing().length - 1] ? vMod.evaluateAbove(this.receiverDepth, lastLeg) : vMod.evaluateBelow(this.receiverDepth, lastLeg);
            double incidentAngle = 57.29577951308232 * Math.asin(incidentVelocity * arrivalRayParam / (this.getTauModel().getRadiusOfEarth() - this.receiverDepth));
            if (this.getDownGoing()[this.getDownGoing().length - 1]) {
                incidentAngle = 180.0 - incidentAngle;
            }
            return incidentAngle;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    protected void phaseConversion(TauModel tMod, int fromBranch, int endAction, boolean isPtoS) throws TauModelException {
        if (endAction == 0) {
            throw new TauModelException("Illegal endAction: endAction=" + endAction + "\nphase conversion are not allowed at turn points.");
        }
        if (endAction == 1) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, !isPtoS).getMaxRayParam());
        } else if (endAction == 2) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMinTurnRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, !isPtoS).getMinTurnRayParam());
        } else if (endAction == 3) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch - 1, !isPtoS).getMinTurnRayParam());
        } else if (endAction == 4) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMinRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch + 1, !isPtoS).getMaxRayParam());
        } else {
            throw new TauModelException("Illegal endAction: endAction=" + endAction);
        }
    }

    public static final String endActionString(int endAction) {
        if (endAction == 0) {
            return "TURN";
        }
        if (endAction == 1) {
            return "REFLECT_UNDERSIDE";
        }
        if (endAction == 2) {
            return "REFLECT_TOPSIDE";
        }
        if (endAction == 3) {
            return "TRANSUP";
        }
        if (endAction == 4) {
            return "TRANSDOWN";
        }
        throw new RuntimeException("UNKNOWN Action: " + endAction);
    }

    protected void addToBranch(TauModel tMod, int startBranch, int endBranch, boolean isPWave, int endAction) throws TauModelException {
        boolean isDownGoing;
        int endOffset;
        if (endBranch < 0 || endBranch > tMod.getNumBranches()) {
            throw new IllegalArgumentException("end branch outside range: " + endBranch);
        }
        if (this.DEBUG) {
            System.out.println("before addToBranch: minRP=" + this.minRayParam + "  maxRP=" + this.maxRayParam);
            System.out.println("addToBranch start=" + startBranch + " end=" + endBranch + " endAction=" + SeismicPhase.endActionString(endAction) + " ");
        }
        if (endAction == 0) {
            endOffset = 0;
            isDownGoing = true;
            this.minRayParam = Math.max(this.minRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
        } else if (endAction == 1) {
            endOffset = 0;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
        } else if (endAction == 2) {
            endOffset = 0;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
        } else if (endAction == 3) {
            endOffset = -1;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
        } else if (endAction == 4) {
            endOffset = 1;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinRayParam());
        } else {
            throw new TauModelException("Illegal endAction: endAction=" + endAction);
        }
        if (isDownGoing) {
            if (startBranch > endBranch) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
            } else {
                int i;
                for (i = startBranch; i <= endBranch; ++i) {
                    this.branchSeq.add(new Integer(i));
                    this.downGoing.add(new Boolean(isDownGoing));
                    this.waveType.add(new Boolean(isPWave));
                    this.legAction.add(new Integer(endAction));
                }
                if (this.DEBUG) {
                    for (i = startBranch; i <= endBranch; ++i) {
                        System.out.println("i=" + i + " isDownGoing=" + isDownGoing + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + SeismicPhase.endActionString(endAction));
                    }
                }
            }
        } else if (startBranch < endBranch) {
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
        } else {
            int i;
            for (i = startBranch; i >= endBranch; --i) {
                this.branchSeq.add(new Integer(i));
                this.downGoing.add(new Boolean(isDownGoing));
                this.waveType.add(new Boolean(isPWave));
                this.legAction.add(new Integer(endAction));
            }
            if (this.DEBUG) {
                for (i = startBranch; i >= endBranch; --i) {
                    System.out.println("i=" + i + " isDownGoing=" + isDownGoing + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + SeismicPhase.endActionString(endAction));
                }
            }
        }
        this.currBranch = endBranch + endOffset;
    }

    public int closestBranchToDepth(TauModel tMod, String depthString) {
        if (depthString.equals("m")) {
            return tMod.getMohoBranch();
        }
        if (depthString.equals("c")) {
            return tMod.getCmbBranch();
        }
        if (depthString.equals("i")) {
            return tMod.getIocbBranch();
        }
        int disconBranch = -1;
        double disconMax = Double.MAX_VALUE;
        double disconDepth = Double.valueOf(depthString);
        for (int i = 0; i < tMod.getNumBranches(); ++i) {
            TauBranch tBranch = tMod.getTauBranch(i, true);
            if (!(Math.abs(disconDepth - tBranch.getTopDepth()) < disconMax) || tMod.isNoDisconDepth(tBranch.getTopDepth())) continue;
            disconBranch = i;
            disconMax = Math.abs(disconDepth - tBranch.getTopDepth());
        }
        return disconBranch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseName(TauModel tMod) throws TauModelException {
        int sLayerNum;
        boolean isPWave;
        String currLeg;
        String nextLeg = currLeg = this.legs.get(0);
        this.branchSeq.clear();
        boolean isPWavePrev = isPWave = true;
        int endAction = 4;
        if (this.legs.size() == 2 && currLeg.endsWith("kmps")) {
            return;
        }
        if (this.name.indexOf(74) != -1 && !tMod.getSlownessModel().isAllowInnerCoreS()) {
            throw new TauModelException("'J' phases were not created for this model: " + this.name);
        }
        if (currLeg.equals("p") || currLeg.startsWith("P") || currLeg.equals("K") || currLeg.equals("k") || currLeg.equals("I")) {
            isPWavePrev = isPWave = true;
        } else {
            if (!currLeg.equals("s") && !currLeg.startsWith("S") && !currLeg.equals("J")) throw new TauModelException("Unknown starting phase: " + currLeg);
            isPWavePrev = isPWave = false;
        }
        int upgoingRecBranch = tMod.findBranch(this.receiverDepth);
        int downgoingRecBranch = upgoingRecBranch - 1;
        if (currLeg.startsWith("s") || currLeg.startsWith("S")) {
            double sdep = tMod.getSourceDepth();
            if (tMod.getSlownessModel().depthInFluid(sdep, new DepthRange())) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot have S wave with starting depth in fluid layer" + currLeg + " within phase " + this.name);
                return;
            }
        }
        if (currLeg.startsWith("P") || currLeg.startsWith("S") || expert && (currLeg.startsWith("K") || currLeg.startsWith("I") || currLeg.startsWith("J"))) {
            this.currBranch = tMod.getSourceBranch();
            endAction = 1;
            try {
                sLayerNum = tMod.getSlownessModel().layerNumberBelow(tMod.getSourceDepth(), isPWavePrev);
                this.maxRayParam = tMod.getSlownessModel().getSlownessLayer(sLayerNum, isPWavePrev).getTopP();
            }
            catch (NoSuchLayerException e) {
                throw new RuntimeException("Should not happen", e);
            }
            this.maxRayParam = tMod.getTauBranch(tMod.getSourceBranch(), isPWave).getMaxRayParam();
        } else {
            if (!currLeg.equals("p") && !currLeg.equals("s") && (!expert || !currLeg.startsWith("k"))) throw new TauModelException("First phase not recognized: " + currLeg + " must be one of P, Pg, Pn, Pdiff, p, Ped or the S equivalents");
            endAction = 2;
            try {
                sLayerNum = tMod.getSlownessModel().layerNumberAbove(tMod.getSourceDepth(), isPWavePrev);
                this.maxRayParam = tMod.getSlownessModel().getSlownessLayer(sLayerNum, isPWavePrev).getBotP();
                DepthRange highSZoneDepth = new DepthRange();
                if (tMod.getSlownessModel().depthInHighSlowness(tMod.getSourceDepth(), this.maxRayParam, highSZoneDepth, isPWavePrev)) {
                    this.maxRayParam = Math.min(this.maxRayParam, highSZoneDepth.rayParam);
                }
            }
            catch (NoSuchLayerException e) {
                throw new RuntimeException("Should not happen", e);
            }
            if (tMod.getSourceBranch() != 0) {
                this.currBranch = tMod.getSourceBranch() - 1;
            } else {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                return;
            }
        }
        if (this.receiverDepth != 0.0) {
            this.maxRayParam = this.legs.get(this.legs.size() - 2).equals("Ped") || this.legs.get(this.legs.size() - 2).equals("Sed") ? Math.min(tMod.getTauBranch(downgoingRecBranch, isPWave).getMinTurnRayParam(), this.maxRayParam) : Math.min(tMod.getTauBranch(upgoingRecBranch, isPWave).getMaxRayParam(), this.maxRayParam);
        }
        this.minRayParam = 0.0;
        int disconBranch = 0;
        double nextLegDepth = 0.0;
        boolean isNextLegDepth = false;
        currLeg = "START";
        for (int legNum = 0; legNum < this.legs.size() - 1; ++legNum) {
            String prevLeg = currLeg;
            currLeg = nextLeg;
            nextLeg = this.legs.get(legNum + 1);
            if (this.DEBUG) {
                System.out.println(legNum + "  " + prevLeg + "  " + currLeg + "  " + nextLeg);
            }
            boolean isLegDepth = isNextLegDepth;
            try {
                nextLegDepth = new Double(nextLeg);
                isNextLegDepth = true;
            }
            catch (NumberFormatException e) {
                nextLegDepth = -1.0;
                isNextLegDepth = false;
            }
            isPWavePrev = isPWave;
            if (currLeg.equals("p") || currLeg.startsWith("P") || currLeg.equals("k") || currLeg.equals("I")) {
                isPWave = true;
            } else if (currLeg.equals("s") || currLeg.startsWith("S") || currLeg.equals("J")) {
                isPWave = false;
            } else if (currLeg.equals("K")) {
                // empty if block
            }
            if (this.branchSeq.size() > 0 && isPWavePrev != isPWave) {
                this.phaseConversion(tMod, this.branchSeq.get(this.branchSeq.size() - 1), endAction, isPWavePrev);
            }
            if (currLeg.equals("Ped") || currLeg.equals("Sed")) {
                if (!nextLeg.equals("END")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                if (this.receiverDepth > 0.0) {
                    endAction = 2;
                    this.addToBranch(tMod, this.currBranch, downgoingRecBranch, isPWave, endAction);
                    continue;
                }
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                return;
            }
            if (currLeg.equals("p") || currLeg.equals("s") || currLeg.equals("k")) {
                if (nextLeg.startsWith("v")) {
                    throw new TauModelException("p and s must always be up going  and cannot come immediately before a top-side reflection. currLeg=" + currLeg + " nextLeg=" + nextLeg);
                }
                if (nextLeg.startsWith("^")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (this.currBranch < disconBranch) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    endAction = 1;
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, endAction);
                    continue;
                }
                if (nextLeg.equals("m") && this.currBranch >= tMod.getMohoBranch()) {
                    endAction = 3;
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, endAction);
                    continue;
                }
                if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.equals("K") || nextLeg.equals("END")) {
                    disconBranch = nextLeg.equals("END") ? upgoingRecBranch : (nextLeg.equals("K") ? tMod.getCmbBranch() : 0);
                    endAction = currLeg.equals("k") && !nextLeg.equals("K") ? 3 : 1;
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, endAction);
                    continue;
                }
                if (!isNextLegDepth) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                disconBranch = this.closestBranchToDepth(tMod, nextLeg);
                endAction = 3;
                this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, endAction);
                continue;
            }
            if (currLeg.equals("P") || currLeg.equals("S")) {
                if (nextLeg.equals("P") || nextLeg.equals("S") || nextLeg.equals("Pn") || nextLeg.equals("Sn") || nextLeg.equals("END")) {
                    if (endAction == 4 || endAction == 1) {
                        endAction = 0;
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, endAction);
                    }
                    if (nextLeg.equals("END")) {
                        endAction = 1;
                        this.addToBranch(tMod, this.currBranch, upgoingRecBranch, isPWave, endAction);
                        continue;
                    }
                    endAction = 1;
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, endAction);
                    continue;
                }
                if (nextLeg.startsWith("v")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (this.currBranch > disconBranch - 1) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " < disconBranch=" + disconBranch);
                    endAction = 2;
                    this.addToBranch(tMod, this.currBranch, disconBranch - 1, isPWave, endAction);
                    continue;
                }
                if (nextLeg.startsWith("^")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (disconBranch == tMod.getNumBranches()) {
                        this.maxRayParam = -1.0;
                        if (!this.DEBUG) return;
                        System.out.println("Attempt to underside reflect from center of earth: " + nextLeg);
                        return;
                    }
                    if (prevLeg.equals("K")) {
                        endAction = 1;
                        this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, endAction);
                        continue;
                    }
                    if (prevLeg.startsWith("^") || prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("p") || prevLeg.equals("s") || prevLeg.equals("START")) {
                        endAction = 0;
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, endAction);
                        endAction = 1;
                        this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, endAction);
                        continue;
                    }
                    if (!(prevLeg.startsWith("v") && disconBranch < this.closestBranchToDepth(tMod, prevLeg.substring(1)) || prevLeg.equals("m") && disconBranch < tMod.getMohoBranch()) && (!prevLeg.equals("c") || disconBranch >= tMod.getCmbBranch())) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    if (disconBranch == tMod.getNumBranches()) {
                        this.maxRayParam = -1.0;
                        if (!this.DEBUG) return;
                        System.out.println("Attempt to reflect from center of earth: " + nextLeg);
                        return;
                    }
                    endAction = 1;
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, endAction);
                    continue;
                }
                if (nextLeg.equals("c")) {
                    if (tMod.getCmbBranch() == tMod.getNumBranches()) {
                        this.maxRayParam = -1.0;
                        if (!this.DEBUG) return;
                        System.out.println("Attempt to reflect from center of earth: " + nextLeg);
                        return;
                    }
                    endAction = 2;
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, endAction);
                    continue;
                }
                if (nextLeg.equals("K")) {
                    endAction = 4;
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, endAction);
                    continue;
                }
                if (nextLeg.equals("I") || nextLeg.equals("J")) {
                    if (tMod.getCmbDepth() == tMod.getIocbDepth()) {
                        endAction = 4;
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, endAction);
                        continue;
                    }
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("P or S followed by I or J can only exist if model has no outer core");
                    return;
                }
                if (!nextLeg.equals("m") && (!isNextLegDepth || !(nextLegDepth < tMod.getCmbDepth()))) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                disconBranch = this.closestBranchToDepth(tMod, nextLeg);
                if (this.DEBUG) {
                    System.out.println("DisconBranch=" + disconBranch + " for " + nextLeg);
                    System.out.println(tMod.getTauBranch(disconBranch, isPWave).getTopDepth());
                }
                if (endAction == 0 || endAction == 2 || endAction == 3) {
                    if (disconBranch > this.currBranch) {
                        throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    }
                    endAction = 3;
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, endAction);
                    continue;
                }
                String nextNextLeg = this.legs.get(legNum + 2);
                if (nextNextLeg.equals("p") || nextNextLeg.equals("s")) {
                    endAction = 0;
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, endAction);
                    endAction = 3;
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, endAction);
                    continue;
                }
                if (!nextNextLeg.equals("P") && !nextNextLeg.equals("S")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " followed by " + nextNextLeg);
                if (disconBranch > this.currBranch) {
                    endAction = 4;
                    this.addToBranch(tMod, this.currBranch, disconBranch - 1, isPWave, endAction);
                    continue;
                }
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot phase convert on the downgoing side if the discontinuity is above the phase leg starting point, " + currLeg + " " + nextLeg + " " + nextNextLeg + ", so this phase, " + this.getName() + " is illegal for this sourceDepth.");
                return;
            }
            if (currLeg.startsWith("P") || currLeg.startsWith("S")) {
                if (currLeg.equals("Pdiff") || currLeg.equals("Sdiff")) {
                    if (this.maxRayParam >= tMod.getTauBranch(tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam() && this.minRayParam <= tMod.getTauBranch(tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam()) {
                        endAction = 0;
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, endAction);
                        this.maxRayParam = this.minRayParam;
                        if (nextLeg.equals("END")) {
                            endAction = 1;
                            this.addToBranch(tMod, this.currBranch, upgoingRecBranch, isPWave, endAction);
                            continue;
                        }
                        if (!nextLeg.startsWith("P") && !nextLeg.startsWith("S")) continue;
                        endAction = 1;
                        this.addToBranch(tMod, this.currBranch, 0, isPWave, endAction);
                        continue;
                    }
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth and/or path.");
                    return;
                }
                if (!currLeg.equals("Pg") && !currLeg.equals("Sg") && !currLeg.equals("Pn") && !currLeg.equals("Sn")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                if (this.currBranch >= tMod.getMohoBranch()) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("(currBranch >= tMod.getMohoBranch() " + this.currBranch + " " + tMod.getMohoBranch() + " so there cannot be a " + currLeg + " phase for this sourceDepth and/or path.");
                    return;
                }
                if (currLeg.equals("Pg") || currLeg.equals("Sg")) {
                    endAction = 0;
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch() - 1, isPWave, endAction);
                    endAction = 1;
                    this.addToBranch(tMod, this.currBranch, upgoingRecBranch, isPWave, endAction);
                    continue;
                }
                if (!currLeg.equals("Pn") && !currLeg.equals("Sn")) continue;
                if (this.maxRayParam >= tMod.getTauBranch(tMod.getMohoBranch(), isPWave).getMaxRayParam() && this.minRayParam <= tMod.getTauBranch(tMod.getMohoBranch(), isPWave).getMaxRayParam()) {
                    endAction = 0;
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, endAction);
                    endAction = 3;
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, endAction);
                    this.minRayParam = this.maxRayParam;
                    if (nextLeg.equals("END")) {
                        endAction = 1;
                        this.addToBranch(tMod, this.currBranch, upgoingRecBranch, isPWave, endAction);
                        continue;
                    }
                    if (!nextLeg.startsWith("P") && !nextLeg.startsWith("S")) continue;
                    endAction = 1;
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, endAction);
                    continue;
                }
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth and/or path.");
                return;
            }
            if (currLeg.equals("K")) {
                if (tMod.getCmbDepth() == tMod.getRadiusOfEarth()) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("Cannot have K phase " + currLeg + " within phase " + this.name + " for this model as it has no core, cmb depth = radius of Earth.");
                    return;
                }
                if (tMod.getCmbDepth() == tMod.getIocbDepth()) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("Cannot have K phase " + currLeg + " within phase " + this.name + " for this model as it has no outer core, cmb depth = iocb depth, " + tMod.getCmbDepth());
                    return;
                }
                if (nextLeg.equals("P") || nextLeg.equals("S")) {
                    if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("K") || prevLeg.equals("k") || prevLeg.equals("START")) {
                        endAction = 0;
                        this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, endAction);
                    }
                    endAction = 3;
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch(), isPWave, endAction);
                    continue;
                }
                if (nextLeg.equals("K")) {
                    if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("K")) {
                        endAction = 0;
                        this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, endAction);
                    }
                    endAction = 1;
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch(), isPWave, endAction);
                    continue;
                }
                if (nextLeg.equals("I") || nextLeg.equals("J")) {
                    endAction = 4;
                    this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, endAction);
                    continue;
                }
                if (!nextLeg.equals("i")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                if (tMod.getIocbBranch() == tMod.getNumBranches()) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("Attempt to reflect from center of earth: " + nextLeg);
                    return;
                }
                endAction = 2;
                this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, endAction);
                continue;
            }
            if (currLeg.equals("I") || currLeg.equals("J")) {
                if (tMod.getIocbDepth() == tMod.getRadiusOfEarth()) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("Cannot have I or J phase " + currLeg + " within phase " + this.name + " for this model as it has no inner core, iocb depth = radius of Earth.");
                    return;
                }
                endAction = 0;
                this.addToBranch(tMod, this.currBranch, tMod.getNumBranches() - 1, isPWave, endAction);
                if (nextLeg.equals("I") || nextLeg.equals("J")) {
                    endAction = 1;
                    this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch(), isPWave, endAction);
                    continue;
                }
                if (nextLeg.equals("K")) {
                    endAction = 3;
                    this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch(), isPWave, endAction);
                    continue;
                }
                if (!nextLeg.equalsIgnoreCase("P") && !nextLeg.equalsIgnoreCase("S")) continue;
                if (tMod.getCmbDepth() == tMod.getIocbDepth()) {
                    endAction = 3;
                    this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch(), isPWave, endAction);
                    continue;
                }
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot have I or J phase " + currLeg + " within phase " + this.name + " for this model as it has an outer core so need K in between.");
                return;
            }
            if (currLeg.equals("m") || currLeg.equals("c") || currLeg.equals("i") || currLeg.startsWith("^")) continue;
            if (currLeg.startsWith("v")) {
                int b = this.closestBranchToDepth(tMod, currLeg.substring(1));
                if (b != 0) continue;
                throw new TauModelException("Phase not recognized: " + currLeg + " looks like a top side reflection at the free surface.");
            }
            if (!isLegDepth) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
            int b = this.closestBranchToDepth(tMod, currLeg);
            if (b != 0 || !nextLeg.equals("p") && !nextLeg.equals("s")) continue;
            throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " looks like a upgoing wave from the free surface as closest discontinuity to " + currLeg + " is zero depth.");
        }
        if (this.maxRayParam == -1.0) return;
        if (endAction == 1 && downgoingRecBranch == this.branchSeq.get(this.branchSeq.size() - 1)) {
            if (this.DEBUG) {
                System.out.println("Phase ends upgoing, but receiver is not on upgoing end of last branch");
            }
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            return;
        } else if (endAction == 2 && upgoingRecBranch == this.branchSeq.get(this.branchSeq.size() - 1)) {
            if (this.DEBUG) {
                System.out.println("Phase ends downgoing, but receiver is not on downgoing end of last branch");
            }
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            return;
        } else {
            if (!this.DEBUG) return;
            System.out.println("Last action is: " + SeismicPhase.endActionString(endAction) + " upR=" + upgoingRecBranch + " downR=" + downgoingRecBranch + " last=" + this.branchSeq.get(this.branchSeq.size() - 1));
        }
    }

    protected static ArrayList<String> legPuller(String name) throws TauModelException {
        int offset = 0;
        ArrayList<String> legs = new ArrayList<String>();
        if (name.endsWith("kmps")) {
            try {
                legs.add(name);
            }
            catch (NumberFormatException e) {
                throw new TauModelException("Invalid phase name:\n" + name);
            }
        } else {
            while (offset < name.length()) {
                String numString;
                if (offset + 2 < name.length() && name.charAt(offset + 1) == 'e' && name.charAt(offset + 2) == 'd' && (name.charAt(offset) == 'p' || name.charAt(offset) == 's' || name.charAt(offset) == 'k' || name.charAt(offset) == 'm' || name.charAt(offset) == 'c' || name.charAt(offset) == 'i' || name.charAt(offset) == '^' || name.charAt(offset) == 'v')) {
                    throw new TauModelException("Invalid phase name:\n" + name.charAt(offset) + " cannot be followed by " + "'ed' in " + name);
                }
                if (name.charAt(offset) == 'K' || name.charAt(offset) == 'I' || name.charAt(offset) == 'k' || name.charAt(offset) == 'J' || name.charAt(offset) == 'p' || name.charAt(offset) == 's' || name.charAt(offset) == 'm' || name.charAt(offset) == 'c' || name.charAt(offset) == 'i') {
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (name.charAt(offset) == 'P' || name.charAt(offset) == 'S') {
                    if (offset + 1 == name.length() || name.charAt(offset + 1) == 'P' || name.charAt(offset + 1) == 'S' || name.charAt(offset + 1) == 'K' || name.charAt(offset + 1) == 'I' || name.charAt(offset + 1) == 'J' || name.charAt(offset + 1) == 'm' || name.charAt(offset + 1) == 'c' || name.charAt(offset + 1) == '^' || name.charAt(offset + 1) == 'v' || Character.isDigit(name.charAt(offset + 1))) {
                        legs.add(name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (name.charAt(offset + 1) == 'p' || name.charAt(offset + 1) == 's') {
                        throw new TauModelException("Invalid phase name:\n" + name.charAt(offset) + " cannot be followed by " + name.charAt(offset + 1) + " in " + name);
                    }
                    if (name.charAt(offset + 1) == 'g' || name.charAt(offset + 1) == 'b' || name.charAt(offset + 1) == 'n') {
                        legs.add(name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    if (name.length() >= offset + 3 && (name.substring(offset, offset + 3).equals("Ped") || name.substring(offset, offset + 3).equals("Sed"))) {
                        legs.add(name.substring(offset, offset + 3));
                        offset += 3;
                        continue;
                    }
                    if (name.length() >= offset + 5 && (name.substring(offset, offset + 5).equals("Sdiff") || name.substring(offset, offset + 5).equals("Pdiff"))) {
                        legs.add(name.substring(offset, offset + 5));
                        offset += 5;
                        continue;
                    }
                    throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
                }
                if (name.charAt(offset) == '^' || name.charAt(offset) == 'v') {
                    if (name.charAt(offset + 1) == 'm' || name.charAt(offset + 1) == 'c' || name.charAt(offset + 1) == 'i') {
                        legs.add(name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    if (Character.isDigit(name.charAt(offset + 1)) || name.charAt(offset + 1) == '.') {
                        numString = name.substring(offset, offset + 1);
                        ++offset;
                        while (Character.isDigit(name.charAt(offset)) || name.charAt(offset) == '.') {
                            numString = numString + name.substring(offset, offset + 1);
                            ++offset;
                        }
                        try {
                            legs.add(numString);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new TauModelException("Invalid phase name: " + numString + "\n" + e.getMessage() + " in " + name);
                        }
                    }
                    throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
                }
                if (Character.isDigit(name.charAt(offset)) || name.charAt(offset) == '.') {
                    numString = name.substring(offset, offset + 1);
                    ++offset;
                    while (Character.isDigit(name.charAt(offset)) || name.charAt(offset) == '.') {
                        numString = numString + name.substring(offset, offset + 1);
                        ++offset;
                    }
                    try {
                        legs.add(numString);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new TauModelException("Invalid phase name: " + numString + "\n" + e.getMessage() + " in " + name);
                    }
                }
                throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
            }
        }
        legs.add(new String("END"));
        String validationMsg = SeismicPhase.phaseValidate(legs);
        if (validationMsg != null) {
            throw new TauModelException("Phase failed validation: " + name + "  " + validationMsg);
        }
        return legs;
    }

    protected void createPuristName(TauModel tMod) {
        String currLeg = this.legs.get(0);
        if (this.legs.size() == 2 && currLeg.endsWith("kmps")) {
            this.puristName = this.name;
            return;
        }
        this.puristName = "";
        for (int legNum = 0; legNum < this.legs.size() - 1; ++legNum) {
            int intLegDepth;
            double legDepth;
            int disconBranch;
            currLeg = this.legs.get(legNum);
            if (currLeg.startsWith("v") || currLeg.startsWith("^")) {
                disconBranch = this.closestBranchToDepth(tMod, currLeg.substring(1));
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                this.puristName = this.puristName + currLeg.substring(0, 1);
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    this.puristName = this.puristName + intLegDepth;
                    continue;
                }
                this.puristName = this.puristName + legDepth;
                continue;
            }
            try {
                legDepth = new Double(currLeg);
                disconBranch = this.closestBranchToDepth(tMod, currLeg);
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    this.puristName = this.puristName + intLegDepth;
                    continue;
                }
                this.puristName = this.puristName + legDepth;
                continue;
            }
            catch (NumberFormatException e) {
                this.puristName = this.puristName + currLeg;
            }
        }
    }

    protected int[][] calcBranchMultiplier() {
        int i;
        int[][] timesBranches = new int[2][this.tMod.getNumBranches()];
        for (i = 0; i < timesBranches[0].length; ++i) {
            timesBranches[0][i] = 0;
            timesBranches[1][i] = 0;
        }
        for (i = 0; i < this.branchSeq.size(); ++i) {
            if (this.waveType.get(i).booleanValue()) {
                int[] nArray = timesBranches[0];
                int n = this.branchSeq.get(i);
                nArray[n] = nArray[n] + 1;
                continue;
            }
            int[] nArray = timesBranches[1];
            int n = this.branchSeq.get(i);
            nArray[n] = nArray[n] + 1;
        }
        return timesBranches;
    }

    protected void sumBranches(TauModel tMod) throws TauModelException {
        int j;
        if (this.maxRayParam < 0.0 || this.minRayParam > this.maxRayParam) {
            this.rayParams = new double[0];
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            this.dist = new double[0];
            this.time = new double[0];
            this.maxDistance = -1.0;
            return;
        }
        if (this.name.endsWith("kmps")) {
            this.dist = new double[2];
            this.time = new double[2];
            this.rayParams = new double[2];
            this.dist[0] = 0.0;
            this.time[0] = 0.0;
            this.rayParams[0] = tMod.radiusOfEarth / Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.dist[1] = Math.PI * 2;
            this.time[1] = Math.PI * 2 * tMod.radiusOfEarth / Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.rayParams[1] = this.rayParams[0];
            this.minDistance = 0.0;
            this.maxDistance = Math.PI * 2;
            this.downGoing.add(true);
            return;
        }
        for (int i = 0; i < tMod.rayParams.length; ++i) {
            if (tMod.rayParams[i] >= this.minRayParam) {
                this.minRayParamIndex = i;
            }
            if (!(tMod.rayParams[i] >= this.maxRayParam)) continue;
            this.maxRayParamIndex = i;
        }
        if (this.maxRayParamIndex == 0 && this.minRayParamIndex == tMod.rayParams.length - 1) {
            this.rayParams = new double[tMod.rayParams.length];
            System.arraycopy(tMod.rayParams, 0, this.rayParams, 0, tMod.rayParams.length);
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1) {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            } else if (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1) {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            } else if (this.name.endsWith("kmps")) {
                this.rayParams = new double[2];
                this.rayParams[0] = 0.0;
                this.rayParams[1] = this.maxRayParam;
            } else {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            }
        } else {
            if (this.DEBUG) {
                System.out.println("maxRayParamIndex=" + this.maxRayParamIndex + " minRayParamIndex=" + this.minRayParamIndex + " tMod.rayParams.length=" + tMod.rayParams.length + " tMod.rayParams[0]=" + tMod.rayParams[0] + " maxRayParam=" + this.maxRayParam);
            }
            this.rayParams = new double[this.minRayParamIndex - this.maxRayParamIndex + 1];
            System.arraycopy(tMod.rayParams, this.maxRayParamIndex, this.rayParams, 0, this.minRayParamIndex - this.maxRayParamIndex + 1);
        }
        this.dist = new double[this.rayParams.length];
        this.time = new double[this.rayParams.length];
        int[][] timesBranches = this.calcBranchMultiplier();
        for (j = 0; j < tMod.getNumBranches(); ++j) {
            int i;
            if (timesBranches[0][j] != 0) {
                for (i = this.maxRayParamIndex; i < this.minRayParamIndex + 1; ++i) {
                    int n = i - this.maxRayParamIndex;
                    this.dist[n] = this.dist[n] + (double)timesBranches[0][j] * tMod.getTauBranch(j, true).getDist(i);
                    int n2 = i - this.maxRayParamIndex;
                    this.time[n2] = this.time[n2] + (double)timesBranches[0][j] * tMod.getTauBranch((int)j, (boolean)true).time[i];
                }
            }
            if (timesBranches[1][j] == 0) continue;
            for (i = this.maxRayParamIndex; i < this.minRayParamIndex + 1; ++i) {
                int n = i - this.maxRayParamIndex;
                this.dist[n] = this.dist[n] + (double)timesBranches[1][j] * tMod.getTauBranch(j, false).getDist(i);
                int n3 = i - this.maxRayParamIndex;
                this.time[n3] = this.time[n3] + (double)timesBranches[1][j] * tMod.getTauBranch((int)j, (boolean)false).time[i];
            }
        }
        if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1) {
            if (tMod.getSlownessModel().depthInHighSlowness(tMod.cmbDepth - 1.0E-10, this.minRayParam, this.name.charAt(0) == 'P')) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
                this.maxDistance = -1.0;
                this.dist = new double[0];
                this.time = new double[0];
                this.rayParams = new double[0];
                return;
            }
            this.dist[1] = this.dist[0] + SeismicPhase.getMaxDiffraction() * Math.PI / 180.0;
            this.time[1] = this.time[0] + SeismicPhase.getMaxDiffraction() * Math.PI / 180.0 * this.minRayParam;
        } else if (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1) {
            this.dist[1] = this.dist[0] + maxRefraction * Math.PI / 180.0;
            this.time[1] = this.time[0] + maxRefraction * Math.PI / 180.0 * this.minRayParam;
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            this.dist[1] = this.dist[0];
            this.time[1] = this.time[0];
        }
        this.minDistance = Double.MAX_VALUE;
        this.maxDistance = 0.0;
        for (j = 0; j < this.dist.length; ++j) {
            if (this.dist[j] < this.minDistance) {
                this.minDistance = this.dist[j];
            }
            if (!(this.dist[j] > this.maxDistance)) continue;
            this.maxDistance = this.dist[j];
        }
        boolean foundOverlap = false;
        boolean isPWave = true;
        for (int dummy = 0; dummy < 2; ++dummy) {
            DepthRange[] hsz = tMod.getSlownessModel().getHighSlowness(isPWave);
            int hSZIndex = 0;
            int indexOffset = 0;
            for (int i = 0; i < hsz.length; ++i) {
                int j2;
                if (!(this.maxRayParam > hsz[i].rayParam) || !(hsz[i].rayParam > this.minRayParam)) continue;
                int branchNum = tMod.findBranch(hsz[i].topDepth);
                foundOverlap = false;
                for (int legNum = 0; legNum < this.branchSeq.size(); ++legNum) {
                    if (this.branchSeq.get(legNum) != branchNum || this.waveType.get(legNum) != isPWave || !this.downGoing.get(legNum).booleanValue() || this.branchSeq.get(legNum - 1) != branchNum - 1 || this.waveType.get(legNum - 1) != isPWave || !this.downGoing.get(legNum - 1).booleanValue()) continue;
                    foundOverlap = true;
                    break;
                }
                if (!foundOverlap) continue;
                double[] newdist = new double[this.dist.length + 1];
                double[] newtime = new double[this.time.length + 1];
                double[] newrayParams = new double[this.rayParams.length + 1];
                for (j2 = 0; j2 < this.rayParams.length; ++j2) {
                    if (this.rayParams[j2] != hsz[i].rayParam) continue;
                    hSZIndex = j2;
                    break;
                }
                System.arraycopy(this.dist, 0, newdist, 0, hSZIndex);
                System.arraycopy(this.time, 0, newtime, 0, hSZIndex);
                System.arraycopy(this.rayParams, 0, newrayParams, 0, hSZIndex);
                newrayParams[hSZIndex] = hsz[i].rayParam;
                newdist[hSZIndex] = 0.0;
                newtime[hSZIndex] = 0.0;
                for (j2 = 0; j2 < tMod.getNumBranches(); ++j2) {
                    if (timesBranches[0][j2] != 0 && tMod.getTauBranch(j2, true).getTopDepth() < hsz[i].topDepth) {
                        int n = hSZIndex;
                        newdist[n] = newdist[n] + (double)timesBranches[0][j2] * tMod.getTauBranch((int)j2, (boolean)true).dist[this.maxRayParamIndex + hSZIndex - indexOffset];
                        int n4 = hSZIndex;
                        newtime[n4] = newtime[n4] + (double)timesBranches[0][j2] * tMod.getTauBranch((int)j2, (boolean)true).time[this.maxRayParamIndex + hSZIndex - indexOffset];
                    }
                    if (timesBranches[1][j2] == 0 || !(tMod.getTauBranch(j2, false).getTopDepth() < hsz[i].topDepth)) continue;
                    int n = hSZIndex;
                    newdist[n] = newdist[n] + (double)timesBranches[1][j2] * tMod.getTauBranch((int)j2, (boolean)false).dist[this.maxRayParamIndex + hSZIndex - indexOffset];
                    int n5 = hSZIndex;
                    newtime[n5] = newtime[n5] + (double)timesBranches[1][j2] * tMod.getTauBranch((int)j2, (boolean)false).time[this.maxRayParamIndex + hSZIndex - indexOffset];
                }
                System.arraycopy(this.dist, hSZIndex, newdist, hSZIndex + 1, this.dist.length - hSZIndex);
                System.arraycopy(this.time, hSZIndex, newtime, hSZIndex + 1, this.time.length - hSZIndex);
                System.arraycopy(this.rayParams, hSZIndex, newrayParams, hSZIndex + 1, this.rayParams.length - hSZIndex);
                ++indexOffset;
                this.dist = newdist;
                this.time = newtime;
                this.rayParams = newrayParams;
            }
            isPWave = false;
        }
    }

    @Deprecated
    public List<Arrival> calcPierce(double deg) throws TauModelException {
        List<Arrival> arrivals = this.calcTime(deg);
        for (Arrival a : arrivals) {
            a.getPierce();
        }
        return arrivals;
    }

    @Deprecated
    public Arrival calcPierce(Arrival currArrival) {
        currArrival.getPierce();
        return currArrival;
    }

    protected List<TimeDist> calcPierceTimeDist(Arrival currArrival) {
        double distRatio;
        double distB;
        double distA;
        double distRayParam;
        double branchDist = 0.0;
        double branchTime = 0.0;
        double prevBranchTime = 0.0;
        List<TimeDist> pierce = new ArrayList<TimeDist>();
        int rayNum = 0;
        int i = 0;
        while (i < this.tMod.rayParams.length - 1 && this.tMod.rayParams[i] >= currArrival.getRayParam()) {
            rayNum = i++;
        }
        if (currArrival.getRayParamIndex() == this.rayParams.length - 1) {
            distRayParam = this.rayParams[currArrival.getRayParamIndex()];
            distA = this.dist[currArrival.getRayParamIndex()];
            distB = this.dist[currArrival.getRayParamIndex()];
            distRatio = 1.0;
        } else {
            double rayParamA = this.rayParams[currArrival.getRayParamIndex()];
            double rayParamB = this.rayParams[currArrival.getRayParamIndex() + 1];
            distA = this.dist[currArrival.getRayParamIndex()];
            distB = this.dist[currArrival.getRayParamIndex() + 1];
            distRatio = (currArrival.getDist() - distA) / (distB - distA);
            distRayParam = distRatio * (rayParamB - rayParamA) + rayParamA;
        }
        pierce.add(new TimeDist(distRayParam, 0.0, 0.0, this.tMod.getSourceDepth()));
        for (int i2 = 0; i2 < this.branchSeq.size(); ++i2) {
            double timeB;
            double timeA;
            double turnDepth;
            int branchNum = this.branchSeq.get(i2);
            boolean isPWave = this.waveType.get(i2);
            if (this.DEBUG) {
                System.out.println(i2 + " branchNum =" + branchNum + " downGoing=" + this.downGoing.get(i2) + "  isPWave=" + isPWave);
            }
            try {
                turnDepth = distRayParam > this.tMod.getTauBranch(branchNum, isPWave).getMaxRayParam() ? this.tMod.getTauBranch(branchNum, isPWave).getTopDepth() : (distRayParam <= this.tMod.getTauBranch(branchNum, isPWave).getMinRayParam() ? this.tMod.getTauBranch(branchNum, isPWave).getBotDepth() : (isPWave || this.tMod.getSlownessModel().depthInFluid((this.tMod.getTauBranch(branchNum, isPWave).getTopDepth() + this.tMod.getTauBranch(branchNum, isPWave).getBotDepth()) / 2.0) ? this.tMod.getSlownessModel().findDepth(distRayParam, this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), true) : this.tMod.getSlownessModel().findDepth(distRayParam, this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), isPWave)));
            }
            catch (SlownessModelException e) {
                throw new RuntimeException("SeismicPhase.calcPierce: Caught SlownessModelException. ", e);
            }
            if (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Sn") != -1) {
                distA = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeA = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                distB = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeB = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
            } else {
                distA = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeA = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                distB = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum + 1);
                timeB = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum + 1];
            }
            branchDist += distRatio * (distB - distA) + distA;
            prevBranchTime = branchTime;
            branchTime += distRatio * (timeB - timeA) + timeA;
            double branchDepth = this.downGoing.get(i2) != false ? Math.min(this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), turnDepth) : Math.min(this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), turnDepth);
            if (!(Math.abs(prevBranchTime - branchTime) > 1.0E-10)) continue;
            pierce.add(new TimeDist(distRayParam, branchTime, branchDist, branchDepth));
            if (!this.DEBUG) continue;
            System.out.println(" branchTime=" + branchTime + " branchDist=" + branchDist + " branchDepth=" + branchDepth);
            System.out.println("incrementTime = " + distRatio * (timeB - timeA) + " timeB=" + timeB + " timeA=" + timeA);
        }
        if (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Sn") != -1) {
            pierce = this.handleHeadOrDiffractedWave(currArrival, pierce);
        } else if (this.name.indexOf("kmps") != -1) {
            pierce.add(new TimeDist(distRayParam, currArrival.getTime(), currArrival.getDist(), 0.0));
        }
        return pierce;
    }

    List<TimeDist> handleHeadOrDiffractedWave(Arrival currArrival, List<TimeDist> orig) {
        String[] phaseSegments = new String[]{"Pn", "Sn", "Pdiff", "Sdiff"};
        String phaseSeg = "";
        for (int i = 0; i < phaseSegments.length; ++i) {
            if (this.name.indexOf(phaseSegments[i]) == -1) continue;
            phaseSeg = phaseSegments[i];
            break;
        }
        if (phaseSeg.equals("")) {
            throw new RuntimeException("no head/diff segment in " + this.name);
        }
        double headDepth = phaseSeg.equals("Pn") || phaseSeg.equals("Sn") ? this.tMod.getMohoDepth() : this.tMod.getCmbDepth();
        int numFound = 0;
        int indexInString = -1;
        while ((indexInString = this.name.indexOf(phaseSeg, indexInString + 1)) != -1) {
            ++numFound;
        }
        double refractDist = currArrival.getDist() - this.dist[0];
        double refractTime = refractDist * currArrival.getRayParam();
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        int j = 0;
        for (TimeDist td : orig) {
            out.add(new TimeDist(td.getP(), td.getTime() + (double)j * refractTime / (double)numFound, td.getDistRadian() + (double)j * refractDist / (double)numFound, td.getDepth()));
            if (td.getDepth() != headDepth) continue;
            out.add(new TimeDist(td.getP(), td.getTime() + (double)(++j) * refractTime / (double)numFound, td.getDistRadian() + (double)j * refractDist / (double)numFound, td.getDepth()));
        }
        return out;
    }

    @Deprecated
    public List<Arrival> calcPath(double deg) {
        List<Arrival> arrivals = this.calcTime(deg);
        for (Arrival a : arrivals) {
            a.getPath();
        }
        return arrivals;
    }

    @Deprecated
    public Arrival calcPath(Arrival currArrival) {
        currArrival.getPath();
        return currArrival;
    }

    protected List<TimeDist> calcPathTimeDist(Arrival currArrival) {
        TimeDist cummulative;
        ArrayList<TimeDist[]> pathList = new ArrayList<TimeDist[]>();
        TimeDist[] tempTimeDist = new TimeDist[]{new TimeDist(currArrival.getRayParam(), 0.0, 0.0, this.tMod.getSourceDepth())};
        pathList.add(tempTimeDist);
        for (int i = 0; i < this.branchSeq.size(); ++i) {
            int branchNum = this.branchSeq.get(i);
            boolean isPWave = this.waveType.get(i);
            if (this.DEBUG) {
                System.out.println("i=" + i + " branchNum=" + branchNum + " isPWave=" + isPWave + " downgoing=" + this.downGoing.get(i));
            }
            try {
                tempTimeDist = this.tMod.getTauBranch(branchNum, isPWave).path(currArrival.getRayParam(), this.downGoing.get(i), this.tMod.getSlownessModel());
            }
            catch (SlownessModelException e) {
                throw new RuntimeException("SeismicPhase.calcPath: Caught SlownessModelException. ", e);
            }
            if (tempTimeDist != null) {
                pathList.add(tempTimeDist);
                for (int j = 0; j < tempTimeDist.length; ++j) {
                    if (!(tempTimeDist[j].getDistDeg() < 0.0)) continue;
                    throw new RuntimeException("Path is backtracking, no possible: " + j + " (" + tempTimeDist[j] + ")");
                }
            }
            if (branchNum == this.tMod.cmbBranch - 1 && i < this.branchSeq.size() - 1 && this.branchSeq.get(i + 1) == this.tMod.cmbBranch - 1 && (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Sdiff") != -1)) {
                TimeDist[] diffTD = new TimeDist[]{new TimeDist(currArrival.getRayParam(), (currArrival.getDist() - this.dist[0]) * currArrival.getRayParam(), currArrival.getDist() - this.dist[0], this.tMod.cmbDepth)};
                pathList.add(diffTD);
                continue;
            }
            if (branchNum != this.tMod.mohoBranch || i >= this.branchSeq.size() - 1 || this.branchSeq.get(i + 1) != this.tMod.mohoBranch || this.name.indexOf("Pn") == -1 && this.name.indexOf("Sn") == -1) continue;
            int numFound = 0;
            int indexInString = -1;
            while ((indexInString = this.name.indexOf("Pn", indexInString + 1)) != -1) {
                ++numFound;
            }
            while ((indexInString = this.name.indexOf("Sn", indexInString + 1)) != -1) {
                ++numFound;
            }
            TimeDist[] headTD = new TimeDist[]{new TimeDist(currArrival.getRayParam(), (currArrival.getDist() - this.dist[0]) / (double)numFound * currArrival.getRayParam(), (currArrival.getDist() - this.dist[0]) / (double)numFound, this.tMod.mohoDepth)};
            pathList.add(headTD);
        }
        if (this.name.indexOf("kmps") != -1) {
            TimeDist[] headTD = new TimeDist[]{new TimeDist(currArrival.getRayParam(), currArrival.getDist() * currArrival.getRayParam(), currArrival.getDist(), 0.0)};
            pathList.add(headTD);
        }
        ArrayList<TimeDist> outPath = new ArrayList<TimeDist>();
        TimeDist prev = cummulative = new TimeDist(currArrival.getRayParam(), 0.0, 0.0, currArrival.getSourceDepth());
        int numAdded = 0;
        for (int i = 0; i < pathList.size(); ++i) {
            TimeDist[] branchPath = (TimeDist[])pathList.get(i);
            for (int j = 0; j < branchPath.length; ++j) {
                prev = cummulative;
                cummulative = new TimeDist(cummulative.getP(), cummulative.getTime() + branchPath[j].getTime(), cummulative.getDistRadian() + branchPath[j].getDistRadian(), branchPath[j].getDepth());
                outPath.add(cummulative);
                if (numAdded > 0 && cummulative.getDistRadian() < prev.getDistRadian()) {
                    throw new RuntimeException("Backtracking ray, not possible: " + numAdded + " " + cummulative + ") < (" + prev + ")");
                }
                ++numAdded;
            }
        }
        return outPath;
    }

    public String getValidationFailMessage() {
        return this.validationFailMessage;
    }

    public static String phaseValidate(ArrayList<String> legs) {
        String currToken = legs.get(0);
        boolean prevIsReflect = false;
        if (legs.size() == 2 && (currToken.equals("Pdiff") || currToken.equals("Sdiff") || currToken.endsWith("kmps")) && legs.get(1).equals("END")) {
            return null;
        }
        if (!(currToken.equals("Pg") || currToken.equals("Pb") || currToken.equals("Pn") || currToken.equals("Pdiff") || currToken.equals("Sg") || currToken.equals("Sb") || currToken.equals("Sn") || currToken.equals("Sdiff") || currToken.equals("Ped") || currToken.equals("Sed") || currToken.equals("P") || currToken.equals("S") || currToken.equals("p") || currToken.equals("s") || expert && (currToken.equals("K") || currToken.equals("k") || currToken.equals("I")))) {
            String validationFailMessage = "First leg (" + currToken + ") must be one of Pg, Pb, Pn, Pdiff, Sg, Sb, Sn, Sdiff, P, S, p, s";
            if (expert) {
                validationFailMessage = validationFailMessage + ", K, k, I";
            }
            return validationFailMessage;
        }
        for (int i = 1; i < legs.size(); ++i) {
            String prevToken = currToken;
            currToken = legs.get(i);
            if (currToken.startsWith("^") || currToken.startsWith("v") || currToken.equals("m") || currToken.equals("c") || currToken.equals("i")) {
                if (prevIsReflect) {
                    return "Two reflections with no leg in between: " + prevToken + ", " + currToken;
                }
                prevIsReflect = true;
            } else {
                prevIsReflect = false;
            }
            if (prevToken.equals("END")) {
                return "Legs ended but more tokens exist: " + currToken;
            }
            if ((prevToken.equals("Ped") || prevToken.equals("Sed")) && !currToken.equals("END")) {
                return "'Ped' or 'Sed' can only be second to last token immediately before END";
            }
            if ((prevToken.startsWith("p") || prevToken.startsWith("s") || prevToken.equals("m") || prevToken.equals("c")) && (currToken.equals("I") || currToken.equals("J") || currToken.equals("i"))) {
                return "Cannot have P,S,p,s,m,c followed by I,J,i: " + prevToken + ", " + currToken;
            }
            if ((prevToken.equals("I") || prevToken.equals("J") || prevToken.equals("i")) && (currToken.equals("m") || currToken.equals("c"))) {
                return "Cannot have I,J,i followed by  m,c: " + prevToken + ", " + currToken;
            }
            if ((prevToken.equals("m") || prevToken.equals("c")) && (currToken.equals("K") || currToken.equals("I") || currToken.equals("J") || currToken.equals("i"))) {
                return "Cannot have m,c followed by K,I,i,J";
            }
            if (!currToken.equals("m") && !currToken.equals("c") || !prevToken.equals("K") && !prevToken.equals("I") && !prevToken.equals("J") && !prevToken.equals("i")) continue;
            return "Cannot have K,I,i,J followed by m,c";
        }
        if (!currToken.equals("END")) {
            return "Last token must be END";
        }
        return null;
    }

    public static Arrival getEarliestArrival(List<SeismicPhase> phases, double degrees) {
        Arrival minArrival = null;
        for (SeismicPhase seismicPhase : phases) {
            seismicPhase.calcTime(degrees);
            Arrival currArrival = seismicPhase.getEarliestArrival(degrees);
            if (currArrival == null || minArrival != null && !(minArrival.getTime() > currArrival.getTime())) continue;
            minArrival = currArrival;
        }
        return minArrival;
    }

    public String toString() {
        int i;
        String desc = this.name + ": ";
        for (i = 0; i < this.legs.size(); ++i) {
            desc = desc + this.legs.get(i) + " ";
        }
        desc = desc + "\n";
        for (i = 0; i < this.branchSeq.size(); ++i) {
            desc = desc + this.branchSeq.get(i) + " ";
        }
        desc = desc + "\n";
        desc = desc + "minRayParam=" + this.minRayParam + " maxRayParam=" + this.maxRayParam;
        desc = desc + "\n";
        desc = desc + "minDistance=" + this.minDistance * 180.0 / Math.PI + " maxDistance=" + this.maxDistance * 180.0 / Math.PI;
        return desc;
    }

    public void dump() {
        for (int j = 0; j < this.dist.length; ++j) {
            System.out.println(j + "  " + this.dist[j] + "  " + this.rayParams[j]);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                System.out.println("Usage: SeismicPhase modelfile depth phasename [phasename ...]");
            }
            TauModel tMod = TauModel.readModel(args[0]);
            TauModel tModDepth = tMod.depthCorrect(Double.valueOf(args[1]));
            for (int i = 2; i < args.length; ++i) {
                System.out.println("-----");
                SeismicPhase sp = new SeismicPhase(args[i], tModDepth);
                System.out.println(sp);
                sp.dump();
            }
            System.out.println("-----");
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (OptionalDataException e) {
            System.out.println(e.getMessage());
        }
        catch (StreamCorruptedException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (TauModelException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

