/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ArrivalTableModel
extends AbstractTableModel {
    protected List<Arrival> arrivals = new ArrayList<Arrival>();

    @Override
    public int getRowCount() {
        return this.arrivals.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return Outputs.formatDistance(this.arrivals.get(row).getModuloDistDeg());
            }
            case 1: {
                return Outputs.formatDistance(this.arrivals.get(row).getModuloDist() * this.arrivals.get(row).getPhase().getTauModel().getRadiusOfEarth());
            }
            case 2: {
                return Outputs.formatDepth(this.arrivals.get(row).getSourceDepth());
            }
            case 3: {
                return this.arrivals.get(row).getName();
            }
            case 4: {
                return Outputs.formatTime(this.arrivals.get(row).getTime());
            }
            case 5: {
                return Outputs.formatRayParam(Math.PI / 180 * this.arrivals.get(row).getRayParam());
            }
            case 6: {
                return Outputs.formatDistance(this.arrivals.get(row).getDistDeg());
            }
            case 7: {
                return this.arrivals.get(row).getName().equals(this.arrivals.get(row).getPuristName()) ? "=" : "*";
            }
            case 8: {
                return this.arrivals.get(row).getPuristName();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Dist";
            }
            case 1: {
                return "Dist (km)";
            }
            case 2: {
                return "Depth";
            }
            case 3: {
                return "Name";
            }
            case 4: {
                return "Time";
            }
            case 5: {
                return "Ray Param";
            }
            case 6: {
                return "Purist Dist";
            }
            case 7: {
                return "";
            }
            case 8: {
                return "Purist Name";
            }
        }
        return "";
    }

    public void setArrivals(List<Arrival> arrivals) {
        this.arrivals = arrivals;
        this.fireTableDataChanged();
    }
}

