/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.UnsupportedEncodingException;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VectorGraphics2D
extends Graphics2D {
    private static final int DEFAULT_PAINT_IMAGE_SIZE_MAXIMUM = 128;
    private final StringBuffer document;
    private final Rectangle2D bounds;
    private double resolution;
    private int rasteredImageSizeMaximum;
    private FontRendering fontRendering;
    private boolean transformed;
    private final RenderingHints hints = new RenderingHints(new HashMap());
    private Color background;
    private Color color;
    private Shape clip;
    private Composite composite;
    private final GraphicsConfiguration deviceConfig;
    private Font font;
    private final FontRenderContext fontRenderContext;
    private Paint paint;
    private Stroke stroke;
    private final AffineTransform transform;
    private Color xorMode;

    public VectorGraphics2D(double x, double y, double width, double height) {
        this.document = new StringBuffer();
        this.bounds = new Rectangle2D.Double(x, y, width, height);
        this.fontRendering = FontRendering.TEXT;
        this.resolution = 72.0;
        this.rasteredImageSizeMaximum = 128;
        this.background = Color.WHITE;
        this.color = Color.BLACK;
        this.composite = AlphaComposite.getInstance(1);
        this.deviceConfig = null;
        this.font = Font.decode(null);
        this.fontRenderContext = new FontRenderContext(null, false, true);
        this.paint = this.color;
        this.stroke = new BasicStroke(1.0f);
        this.transform = new AffineTransform();
        this.transformed = false;
        this.xorMode = Color.BLACK;
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.hints.putAll(hints);
    }

    @Override
    public void clip(Shape s) {
        if (this.getClip() != null && s != null) {
            Area clipAreaOld = new Area(this.getClip());
            Area clipAreaNew = new Area(s);
            clipAreaNew.intersect(clipAreaOld);
            s = clipAreaNew;
        }
        this.setClip(s);
    }

    @Override
    public void draw(Shape s) {
        this.writeShape(s);
        this.writeClosingDraw(s);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.draw(g.getOutline(x, y));
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        BufferedImage bimg = this.getTransformedImage(img, xform);
        this.drawImage(bimg, null, bimg.getMinX(), bimg.getMinY());
        return true;
    }

    private BufferedImage getTransformedImage(Image image, AffineTransform xform) {
        Integer interpolationType = (Integer)this.hints.get(RenderingHints.KEY_INTERPOLATION);
        interpolationType = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(interpolationType) ? Integer.valueOf(1) : (RenderingHints.VALUE_INTERPOLATION_BILINEAR.equals(interpolationType) ? Integer.valueOf(2) : Integer.valueOf(3));
        AffineTransformOp op = new AffineTransformOp(xform, interpolationType);
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        return op.filter(bufferedImage, null);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (op != null) {
            img = op.filter(img, null);
        }
        this.drawImage(img, x, y, img.getWidth(), img.getHeight(), null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage bimg = GraphicsUtils.toBufferedImage(img);
        this.drawImage(bimg, xform, null);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str != null && str.trim().isEmpty()) {
            return;
        }
        switch (this.getFontRendering()) {
            case VECTORS: {
                TextLayout layout = new TextLayout(str, this.getFont(), this.getFontRenderContext());
                Shape s = layout.getOutline(AffineTransform.getTranslateInstance(x, y));
                this.fill(s);
                break;
            }
            case TEXT: {
                this.writeString(str, x, y);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown font rendering mode.");
            }
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        StringBuffer buf = new StringBuffer();
        char c = iterator.first();
        while (c != '\uffff') {
            buf.append(c);
            c = iterator.next();
        }
        this.drawString(buf.toString(), x, y);
    }

    @Override
    public void fill(Shape s) {
        this.writeShape(s);
        this.writeClosingFill(s);
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.deviceConfig;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        if (RenderingHints.KEY_ANTIALIASING.equals(hintKey)) {
            return RenderingHints.VALUE_ANTIALIAS_OFF;
        }
        if (RenderingHints.KEY_TEXT_ANTIALIASING.equals(hintKey)) {
            return RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        }
        if (RenderingHints.KEY_FRACTIONALMETRICS.equals(hintKey)) {
            return RenderingHints.VALUE_FRACTIONALMETRICS_ON;
        }
        return this.hints.get(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            Shape sStroke = this.getStroke().createStrokedShape(s);
            return sStroke.intersects(rect);
        }
        return s.intersects(rect);
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (paint instanceof Color) {
                this.setColor((Color)paint);
            } else if (paint instanceof MultipleGradientPaint) {
                Color[] colors = ((MultipleGradientPaint)paint).getColors();
                if (colors.length == 1) {
                    this.setColor(colors[0]);
                } else if (colors.length > 1) {
                    Color colLight = colors[0];
                    float brightness = VectorGraphics2D.getBrightness(colLight);
                    int alpha = colLight.getAlpha();
                    for (int i = 1; i < colors.length; ++i) {
                        Color c = colors[i];
                        float b = VectorGraphics2D.getBrightness(c);
                        int a = c.getAlpha();
                        if (!(b < brightness) && a >= alpha) continue;
                        colLight = c;
                        brightness = b;
                    }
                    this.setColor(colLight);
                }
            }
        }
    }

    private static float getBrightness(Color c) {
        return Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null)[2];
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints.putAll(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    @Override
    public void setTransform(AffineTransform tx) {
        this.setAffineTransform(tx);
    }

    protected void setAffineTransform(AffineTransform tx) {
        if (!this.transform.equals(tx)) {
            this.transform.setTransform(tx);
            this.transformed = true;
        }
    }

    @Override
    public void shear(double shx, double shy) {
        AffineTransform transform = this.getTransform();
        transform.shear(shx, shy);
        this.setAffineTransform(transform);
    }

    @Override
    public void transform(AffineTransform tx) {
        AffineTransform transform = this.getTransform();
        transform.concatenate(tx);
        this.setAffineTransform(transform);
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform transform = this.getTransform();
        transform.translate(tx, ty);
        this.setAffineTransform(transform);
    }

    @Override
    public void rotate(double theta) {
        AffineTransform transform = this.getTransform();
        transform.rotate(theta);
        this.setAffineTransform(transform);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        AffineTransform transform = this.getTransform();
        transform.rotate(theta, x, y);
        this.setAffineTransform(transform);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform transform = this.getTransform();
        transform.scale(sx, sy);
        this.setAffineTransform(transform);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        int imgWidth = img.getWidth(observer);
        int imgHeight = img.getHeight(observer);
        this.writeImage(img, imgWidth, imgHeight, x, y, width, height);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int sx = Math.min(sx1, sx2);
        int sy = Math.min(sy1, sy2);
        int sw = Math.abs(sx2 - sx1);
        int sh = Math.abs(sy2 - sy1);
        int dx = Math.min(dx1, dx2);
        int dy = Math.min(dy1, dy2);
        int dw = Math.abs(dx2 - dx1);
        int dh = Math.abs(dy2 - dy1);
        BufferedImage bufferedImg = GraphicsUtils.toBufferedImage(img);
        BufferedImage cropped = bufferedImg.getSubimage(sx, sy, sw, sh);
        return this.drawImage(cropped, dx, dy, dw, dh, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int sx = Math.min(sx1, sx2);
        int sy = Math.min(sy1, sy2);
        int sw = Math.abs(sx2 - sx1);
        int sh = Math.abs(sy2 - sy1);
        int dx = Math.min(dx1, dx2);
        int dy = Math.min(dy1, dy2);
        int dw = Math.abs(dx2 - dx1);
        int dh = Math.abs(dy2 - dy1);
        Color bgcolorOld = this.getColor();
        this.setColor(bgcolor);
        this.fill(new Rectangle(dx, dy, dw, dh));
        this.setColor(bgcolorOld);
        BufferedImage bufferedImg = GraphicsUtils.toBufferedImage(img);
        BufferedImage cropped = bufferedImg.getSubimage(sx, sy, sw, sh);
        return this.drawImage(cropped, dx, dy, dw, dh, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Float p = new Path2D.Float();
        for (int i = 0; i < nPoints; ++i) {
            if (i > 0) {
                ((Path2D)p).lineTo(xPoints[i], yPoints[i]);
                continue;
            }
            ((Path2D)p).moveTo(xPoints[i], yPoints[i]);
        }
        p.closePath();
        this.draw(p);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Float p = new Path2D.Float();
        for (int i = 0; i < nPoints; ++i) {
            if (i > 0) {
                ((Path2D)p).lineTo(xPoints[i], yPoints[i]);
                continue;
            }
            ((Path2D)p).moveTo(xPoints[i], yPoints[i]);
        }
        this.draw(p);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Float p = new Path2D.Float();
        for (int i = 0; i < nPoints; ++i) {
            if (i > 0) {
                ((Path2D)p).lineTo(xPoints[i], yPoints[i]);
                continue;
            }
            ((Path2D)p).moveTo(xPoints[i], yPoints[i]);
        }
        p.closePath();
        this.fill(p);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public Shape getClip() {
        Shape clip = this.clip;
        if (clip != null) {
            try {
                clip = this.transform.createInverse().createTransformedShape(this.clip);
            }
            catch (NoninvertibleTransformException e) {
                clip = null;
            }
        }
        return clip;
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.getClip() == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        BufferedImage bi = new BufferedImage(1, 1, 3);
        Graphics g = bi.getGraphics();
        FontMetrics fontMetrics = g.getFontMetrics(this.getFont());
        g.dispose();
        bi = null;
        return fontMetrics;
    }

    @Override
    public void setClip(Shape clip) {
        this.clip = clip != null ? this.transform.createTransformedShape(clip) : null;
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public void setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
        }
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
        this.xorMode = c1;
    }

    protected void write(Object ... strs) {
        for (Object o : strs) {
            String str = o.toString();
            if (o instanceof Double || o instanceof Float) {
                str = String.format(Locale.ENGLISH, "%.7f", o).replaceAll("\\.?0+$", "");
            }
            this.document.append(str);
        }
    }

    protected void writeln(Object ... strs) {
        this.write(strs);
        this.write("\n");
    }

    protected abstract void writeShape(Shape var1);

    protected abstract void writeImage(Image var1, int var2, int var3, double var4, double var6, double var8, double var10);

    protected abstract void writeString(String var1, double var2, double var4);

    protected abstract void writeClosingDraw(Shape var1);

    protected void writeClosingFill(Shape s) {
        Rectangle2D shapeBounds = s.getBounds2D();
        int wImage = (int)Math.ceil(shapeBounds.getWidth() * this.getResolution());
        int hImage = (int)Math.ceil(shapeBounds.getHeight() * this.getResolution());
        wImage = Math.min(wImage, this.rasteredImageSizeMaximum);
        hImage = Math.min(hImage, this.rasteredImageSizeMaximum);
        BufferedImage paintImage = new BufferedImage(wImage, hImage, 2);
        Graphics2D g = (Graphics2D)paintImage.getGraphics();
        g.scale((double)wImage / shapeBounds.getWidth(), (double)hImage / shapeBounds.getHeight());
        g.translate(-shapeBounds.getX(), -shapeBounds.getY());
        g.setPaint(this.getPaint());
        g.fill(s);
        g.dispose();
        this.writeImage(paintImage, wImage, hImage, shapeBounds.getX(), shapeBounds.getY(), shapeBounds.getWidth(), shapeBounds.getHeight());
    }

    protected abstract void writeHeader();

    protected abstract String getFooter();

    protected boolean isDistorted() {
        int otherButTranslatedOrScaled;
        if (!this.isTransformed()) {
            return false;
        }
        int type = this.transform.getType();
        return (type & (otherButTranslatedOrScaled = -8)) != 0;
    }

    @Override
    public String toString() {
        return this.document.toString() + this.getFooter();
    }

    public byte[] getBytes() {
        try {
            return this.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return this.toString().getBytes();
        }
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Double b = new Rectangle2D.Double();
        b.setFrame(this.bounds);
        return b;
    }

    protected int size() {
        return this.document.length();
    }

    public FontRendering getFontRendering() {
        return this.fontRendering;
    }

    public void setFontRendering(FontRendering mode) {
        this.fontRendering = mode;
    }

    protected boolean isTransformed() {
        return this.transformed;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setResolution(double resolution) {
        if (resolution <= 0.0) {
            throw new IllegalArgumentException("Only positive non-zero values allowed");
        }
        this.resolution = resolution;
    }

    public int getRasteredImageSizeMaximum() {
        return this.rasteredImageSizeMaximum;
    }

    public void setRasteredImageSizeMaximum(int paintImageSizeMaximum) {
        this.rasteredImageSizeMaximum = paintImageSizeMaximum;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontRendering {
        TEXT,
        VECTORS;

    }
}

