/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeDecimalFormat;
import edu.sc.seis.fissuresUtil.xml.XMLStation;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.event.VelocityEvent;
import edu.sc.seis.sod.velocity.network.VelocityNetwork;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.velocity.VelocityContext;

public class VelocityStation
extends StationImpl {
    private boolean hashCalc = false;
    private int hash = 0;
    private VelocityNetwork velocityNet = null;
    private StationImpl sta;
    private int[] position;
    static final ThreadSafeDecimalFormat df = new ThreadSafeDecimalFormat("0.00");

    public VelocityStation(StationImpl sta) {
        if (sta == null) {
            throw new IllegalArgumentException("StationImpl cannot be null");
        }
        this.sta = sta;
        this.name = sta.getName();
        this.setLocation(sta.getLocation());
        this.setEffectiveTime(sta.getEffectiveTime());
        this.operator = sta.getOperator();
        this.description = sta.getDescription();
        this.comment = sta.getComment();
        this.setNetworkAttr(sta.getNetworkAttr());
    }

    public int getDbId() {
        return this.sta.getDbid();
    }

    public StationId get_id() {
        return this.sta.get_id();
    }

    public StationId getId() {
        return this.sta.getId();
    }

    public String get_code() {
        return this.sta.get_code();
    }

    public String getCode() {
        return this.get_code();
    }

    public String getCodes() {
        return this.getNetCode() + "." + this.getCode();
    }

    public String getNetCode() {
        return this.getNet().get_code();
    }

    public VelocityNetwork getNet() {
        if (this.velocityNet == null) {
            this.velocityNet = new VelocityNetwork((NetworkAttrImpl)this.getNetworkAttr());
        }
        return this.velocityNet;
    }

    public MicroSecondDate getStartDate() {
        return new MicroSecondDate(this.getEffectiveTime().start_time);
    }

    public MicroSecondDate getEndDate() {
        return new MicroSecondDate(this.getEffectiveTime().end_time);
    }

    public String getStart() {
        return FissuresFormatter.formatDate(this.getEffectiveTime().start_time);
    }

    public String getStart(String dateFormat) {
        if (dateFormat.equals("longfile")) {
            return FissuresFormatter.formatDateForFile(this.getEffectiveTime().start_time);
        }
        return SimpleVelocitizer.format(new MicroSecondDate(this.getEffectiveTime().start_time), dateFormat);
    }

    public String getEnd() {
        return FissuresFormatter.formatDate(this.getEffectiveTime().end_time);
    }

    public String getEnd(String dateFormat) {
        if (dateFormat.equals("longfile")) {
            return FissuresFormatter.formatDateForFile(this.getEffectiveTime().end_time);
        }
        return SimpleVelocitizer.format(new MicroSecondDate(this.getEffectiveTime().end_time), dateFormat);
    }

    public String getName() {
        return FissuresFormatter.oneLineAndClean(super.getName());
    }

    public String getCSVName() {
        return this.getName().replaceAll(",", "");
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getComment() {
        return this.comment;
    }

    public String getLatitude() {
        return df.format((double)this.sta.getLocation().latitude);
    }

    public String getLatitude(String format) {
        return new DecimalFormat(format).format(this.sta.getLocation().latitude);
    }

    public String getLongitude() {
        return df.format((double)this.sta.getLocation().longitude);
    }

    public String getLongitude(String format) {
        return new DecimalFormat(format).format(this.sta.getLocation().longitude);
    }

    public String getOrientedLatitude() {
        return VelocityStation.getOrientedLatitude(this.sta.getLocation().latitude);
    }

    public static String getOrientedLatitude(float latitude) {
        if (latitude < 0.0f) {
            return df.format((double)(-latitude)) + " S";
        }
        return df.format((double)latitude) + " N";
    }

    public String getOrientedLongitude() {
        return VelocityStation.getOrientedLongitude(this.sta.getLocation().longitude);
    }

    public static String getOrientedLongitude(float longitude) {
        if (longitude < 0.0f) {
            return df.format((double)(-longitude)) + " W";
        }
        return df.format((double)longitude) + " E";
    }

    public Float getFloatLatitude() {
        return new Float(this.getLocation().latitude);
    }

    public Float getFloatLongitude() {
        return new Float(this.getLocation().longitude);
    }

    public String getDepth() {
        return FissuresFormatter.formatElevation(QuantityImpl.createQuantityImpl((Quantity)this.sta.getLocation().depth));
    }

    public String getDepth(String format) {
        double depthInM = QuantityImpl.createQuantityImpl((Quantity)this.sta.getLocation().depth).convertTo((UnitImpl)UnitImpl.METER).value;
        return new DecimalFormat(format).format(depthInM);
    }

    public String getElevation() {
        return FissuresFormatter.formatElevation(QuantityImpl.createQuantityImpl((Quantity)this.sta.getLocation().elevation));
    }

    public String getElevation(String format) {
        double elevInMeters = QuantityImpl.createQuantityImpl((Quantity)this.sta.getLocation().elevation).convertTo((UnitImpl)UnitImpl.METER).value;
        return new DecimalFormat(format).format(elevInMeters);
    }

    public String getDistance(VelocityEvent event) {
        double km = DistAz.degreesToKilometers((double)new DistAz((Station)this, (EventAccessOperations)event).getDelta());
        return FissuresFormatter.formatDistance(new QuantityImpl(km, (Unit)UnitImpl.KILOMETER));
    }

    public String getDistanceDeg(VelocityEvent event) {
        return FissuresFormatter.formatDistance(this.getDist(event));
    }

    public String getAz(VelocityEvent event) {
        double az = new DistAz((Station)this, (EventAccessOperations)event).getAz();
        return FissuresFormatter.formatQuantity(new QuantityImpl(az, (Unit)UnitImpl.DEGREE));
    }

    public QuantityImpl getDist(VelocityEvent event) {
        double deg = new DistAz((Station)this, (EventAccessOperations)event).getDelta();
        return new QuantityImpl(deg, (Unit)UnitImpl.DEGREE);
    }

    public String getBaz(VelocityEvent event) {
        double baz = new DistAz((Station)this, (EventAccessOperations)event).getBaz();
        return FissuresFormatter.formatQuantity(new QuantityImpl(baz, (Unit)UnitImpl.DEGREE));
    }

    public String getURL() {
        return "stations/" + this.getNetCode() + "/" + this.getCode();
    }

    public String toXML() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlWriter = XMLUtil.getStaxOutputFactory().createXMLStreamWriter(writer);
        XMLStation.insert((XMLStreamWriter)xmlWriter, (Station)this);
        return writer.toString();
    }

    public String toString() {
        return StationIdUtil.toStringNoDates((StationId)this.get_id());
    }

    public boolean equals(Object o) {
        VelocityStation oVel;
        if (o == this) {
            return true;
        }
        if (o instanceof VelocityStation && (oVel = (VelocityStation)((Object)o)).getDbId() != -1 && this.getDbId() != -1 && oVel.getDbId() == this.getDbId()) {
            return true;
        }
        if (o instanceof Station) {
            Station oSta = (Station)o;
            return StationIdUtil.areEqual((Station)oSta, (Station)this.sta);
        }
        return false;
    }

    public int hashCode() {
        if (!this.hashCalc) {
            this.hash = StationIdUtil.toString((StationId)this.get_id()).hashCode();
            this.hashCalc = true;
        }
        return this.hash;
    }

    public void setPosition(int[] position) {
        this.position = position;
    }

    public int[] getPosition() {
        return this.position;
    }

    public void insertIntoContext(VelocityContext ctx) {
        ctx.put("station", (Object)this);
        ctx.put("sta", (Object)this);
        this.getNet().insertIntoContext(ctx);
    }

    public StationImpl getWrapped() {
        return this.sta;
    }

    public static VelocityStation[] wrap(Station[] stations) {
        VelocityStation[] out = new VelocityStation[stations.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new VelocityStation((StationImpl)stations[i]);
        }
        return out;
    }

    public static List<VelocityStation> wrapList(List<? extends Station> stations) {
        ArrayList<VelocityStation> out = new ArrayList<VelocityStation>();
        for (Station station : stations) {
            if (station instanceof VelocityStation) {
                out.add((VelocityStation)station);
                continue;
            }
            out.add(new VelocityStation((StationImpl)station));
        }
        return out;
    }
}

