/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityNetwork;
import edu.sc.seis.sod.velocity.network.VelocitySampling;
import edu.sc.seis.sod.velocity.network.VelocitySite;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;

public class VelocityChannel
extends ChannelImpl {
    private ChannelImpl chan;

    public VelocityChannel(ChannelImpl chan) {
        this.chan = chan;
        this.setSite(chan.getSite());
        this.setOrientation(chan.getOrientation());
        this.setSamplingInfo(chan.getSamplingInfo());
        this.setEffectiveTime(chan.getEffectiveTime());
        this.setName(chan.getName());
    }

    public ChannelId get_id() {
        return this.chan.get_id();
    }

    public ChannelId getId() {
        return this.chan.getId();
    }

    public String get_code() {
        return this.chan.get_code();
    }

    public float getAzimuth() {
        return this.getOrientation().azimuth;
    }

    public float getDip() {
        return this.getOrientation().dip;
    }

    public String getCode() {
        return this.get_code();
    }

    public String getBandCode() {
        return this.get_code().substring(0, 1);
    }

    public String getGainCode() {
        return this.get_code().substring(1, 2);
    }

    public String getOrientationCode() {
        return this.get_code().substring(2, 3);
    }

    public String getCodes() {
        return this.getNet().getCode() + "." + this.getStation().getCode() + "." + this.getSite().getCode() + "." + this.getCode();
    }

    public VelocityNetwork getNet() {
        return this.getStation().getNet();
    }

    public VelocityNetwork getNetwork() {
        return this.getNet();
    }

    public VelocityStation getStation() {
        return this.getSite().getStation();
    }

    public VelocitySite getSite() {
        return new VelocitySite((SiteImpl)super.getSite());
    }

    public MicroSecondDate getStartDate() {
        return new MicroSecondDate(this.getEffectiveTime().start_time);
    }

    public String getStart() {
        return FissuresFormatter.formatDate(this.getEffectiveTime().start_time);
    }

    public String getStart(String format) {
        return SimpleVelocitizer.format(this.getStartDate(), format);
    }

    public MicroSecondDate getEndDate() {
        return new MicroSecondDate(this.getEffectiveTime().end_time);
    }

    public String getEnd() {
        return FissuresFormatter.formatDate(this.getEffectiveTime().end_time);
    }

    public String getEnd(String format) {
        return SimpleVelocitizer.format(this.getEndDate(), format);
    }

    public VelocitySampling getSampling() {
        return new VelocitySampling(this.getSamplingInfo());
    }

    public String compactToString() {
        return ChannelIdUtil.toStringNoDates((Channel)this);
    }

    public String toString() {
        return ChannelIdUtil.toStringNoDates((ChannelId)this.chan.get_id());
    }

    public boolean hasDbId() {
        return this.chan.getDbid() >= 0;
    }

    public int getDbId() {
        if (this.hasDbId()) {
            return this.chan.getDbid();
        }
        throw new UnsupportedOperationException("This channel had no dbid");
    }

    public ChannelImpl getWrapped() {
        return this.chan;
    }

    public static VelocityChannel[] wrap(Channel[] chans) {
        VelocityChannel[] velChans = new VelocityChannel[chans.length];
        for (int i = 0; i < velChans.length; ++i) {
            velChans[i] = VelocityChannel.wrap(chans[i]);
        }
        return velChans;
    }

    public static List<VelocityChannel> wrap(List<? extends ChannelImpl> chans) {
        ArrayList<VelocityChannel> velChans = new ArrayList<VelocityChannel>();
        for (ChannelImpl channelImpl : chans) {
            velChans.add(VelocityChannel.wrap((Channel)channelImpl));
        }
        return velChans;
    }

    public void insertIntoContext(VelocityContext ctx) {
        ctx.put("channel", (Object)this);
        ctx.put("chan", (Object)this);
        this.getSite().insertIntoContext(ctx);
    }

    public static VelocityChannel wrap(Channel chan) {
        if (chan instanceof VelocityChannel) {
            return (VelocityChannel)chan;
        }
        return new VelocityChannel((ChannelImpl)chan);
    }
}

