/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.event;

import edu.iris.Fissures.FlinnEngdahlRegion;
import edu.iris.Fissures.FlinnEngdahlType;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeDecimalFormat;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.ParseRegions;
import edu.sc.seis.fissuresUtil.xml.XMLEvent;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.Object;

public class VelocityEvent
extends ProxyEventAccessOperations {
    private static ThreadSafeSimpleDateFormat fullDateIdentifier = new ThreadSafeSimpleDateFormat("yyyy/MM/dd/HH/mm/ss", ISOTime.UTC);
    private Origin origin;
    private int[] position;
    private static ParseRegions pr = ParseRegions.getInstance();
    private ThreadSafeDecimalFormat df = new ThreadSafeDecimalFormat("0.0");

    public VelocityEvent(CacheEvent event) {
        if (event == null) {
            throw new NullPointerException("event cannot be null");
        }
        this.event = event;
        this.origin = this.getOrigin();
    }

    public String getName() {
        if (this.get_attributes().name != null & this.get_attributes().name.length() > 0) {
            return this.get_attributes().name;
        }
        if (this.hasRegion()) {
            return this.getRegion();
        }
        return this.getTime();
    }

    public boolean hasRegion() {
        return this.get_attributes().region != null && this.get_attributes().region.number > 0;
    }

    public String getRegion() {
        return pr.getRegionName(this.get_attributes().region);
    }

    public String getRegionNumber() {
        FlinnEngdahlRegion region = this.get_attributes().region;
        String type = region.type == FlinnEngdahlType.GEOGRAPHIC_REGION ? "Geographic" : "Seismic";
        return type + " " + this.get_attributes().region.number;
    }

    public String getMagnitude() {
        if (this.origin.getMagnitudes().length == 0) {
            return "-";
        }
        return FissuresFormatter.formatMagnitude(this.origin.getMagnitudes()[0]);
    }

    public String getAllMagnitudes() {
        return this.getAllMagnitudes(", ");
    }

    public String getAllMagnitudes(String seperator) {
        String s = "";
        for (int i = 0; i < this.origin.getMagnitudes().length; ++i) {
            s = s + FissuresFormatter.formatMagnitude(this.origin.getMagnitudes()[i]);
            if (i == this.origin.getMagnitudes().length - 1) continue;
            s = s + seperator;
        }
        return s;
    }

    public String getMagnitudeValue() {
        if (this.origin.getMagnitudes().length != 0) {
            return "" + this.origin.getMagnitudes()[0].value;
        }
        return "";
    }

    public String getMagnitudeType() {
        if (this.origin.getMagnitudes().length != 0) {
            return this.origin.getMagnitudes()[0].type;
        }
        return "";
    }

    public String getMagnitudeContributor() {
        if (this.origin.getMagnitudes().length != 0) {
            return this.origin.getMagnitudes()[0].contributor;
        }
        return "";
    }

    public String getLatitude() {
        return this.df.format((double)this.origin.getLocation().latitude);
    }

    public String getLongitude() {
        return this.df.format((double)this.origin.getLocation().longitude);
    }

    public String getLatitude(String format) {
        return new DecimalFormat(format).format(this.origin.getLocation().latitude);
    }

    public String getLongitude(String format) {
        return new DecimalFormat(format).format(this.origin.getLocation().longitude);
    }

    public Float getFloatLatitude() {
        return new Float(this.origin.getLocation().latitude);
    }

    public Float getFloatLongitude() {
        return new Float(this.origin.getLocation().longitude);
    }

    public String getOrientedLatitude() {
        if (this.origin.getLocation().latitude < 0.0f) {
            return this.df.format((double)(-this.origin.getLocation().latitude)) + " S";
        }
        return this.df.format((double)this.origin.getLocation().latitude) + " N";
    }

    public String getOrientedLongitude() {
        if (this.origin.getLocation().longitude < 0.0f) {
            return this.df.format((double)(-this.origin.getLocation().longitude)) + " W";
        }
        return this.df.format((double)this.origin.getLocation().longitude) + " E";
    }

    public String getDepth() {
        return FissuresFormatter.formatDepth(FissuresFormatter.getDepth(this.origin));
    }

    public String getDepthValue() {
        return this.getDepth("0.0");
    }

    public String getDepth(String format) {
        double depthInKM = QuantityImpl.createQuantityImpl((Quantity)this.origin.getLocation().depth).convertTo((UnitImpl)UnitImpl.KILOMETER).value;
        return new DecimalFormat(format).format(depthInKM);
    }

    public String getElevation() {
        return FissuresFormatter.formatDepth(QuantityImpl.createQuantityImpl((Quantity)this.origin.getLocation().elevation));
    }

    public String getElevation(String format) {
        double elevInMeters = QuantityImpl.createQuantityImpl((Quantity)this.origin.getLocation().elevation).convertTo((UnitImpl)UnitImpl.METER).value;
        return new DecimalFormat(format).format(elevInMeters);
    }

    public String getTime() {
        return this.getTime("yyyy/MM/dd HH:mm:ss z");
    }

    public String getTimePrecise() {
        return this.getTime("yyyy/MM/dd HH:mm:ss.SSS Z");
    }

    public String getFilizedTime() {
        return this.getTime("yyyy_DDD_HH_mm_ss_ZZZ");
    }

    public String getTime(String format) {
        return SimpleVelocitizer.format(new MicroSecondDate(this.origin.getOriginTime()), format);
    }

    public String getCatalog() {
        return this.origin.getCatalog();
    }

    public String getContributor() {
        return this.origin.getContributor();
    }

    public int getId() {
        return this.getDbid();
    }

    public int getDbId() {
        return this.getDbid();
    }

    public int getDbid() {
        return ((CacheEvent)this.event).getDbid();
    }

    public OriginImpl getPreferred() throws NoPreferredOrigin {
        return this.getCacheEvent().getPreferred();
    }

    public Origin[] getOrigins() {
        return this.getCacheEvent().getOrigins();
    }

    public String getParam(String name) {
        for (int i = 0; i < this.origin.getParmIds().length; ++i) {
            if (!this.origin.getParmIds()[i].a_id.equals(name)) continue;
            return this.origin.getParmIds()[i].creator;
        }
        return null;
    }

    public String getDistanceDeg(VelocityStation sta) {
        return sta.getDistanceDeg(this);
    }

    public String getDistance(VelocityStation sta) {
        return sta.getDistance(this);
    }

    public String getAz(VelocityStation sta) {
        return sta.getAz(this);
    }

    public String getBaz(VelocityStation sta) {
        return sta.getBaz(this);
    }

    public void setPosition(int[] position) {
        this.position = position;
    }

    public int[] getPosition() {
        return this.position;
    }

    public String toXML() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlWriter = XMLUtil.getStaxOutputFactory().createXMLStreamWriter(writer);
        XMLEvent.insert((XMLStreamWriter)xmlWriter, (EventAccessOperations)this);
        return writer.toString();
    }

    public String getURL() {
        return "earthquakes/" + VelocityEvent.makeDateIdentifier(this);
    }

    public CacheEvent getCacheEvent() {
        if (this.event instanceof CacheEvent) {
            return (CacheEvent)this.event;
        }
        return new CacheEvent(this.event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeDateIdentifier(VelocityEvent event) {
        ThreadSafeSimpleDateFormat threadSafeSimpleDateFormat = fullDateIdentifier;
        synchronized (threadSafeSimpleDateFormat) {
            return fullDateIdentifier.format((Date)new MicroSecondDate(event.getOrigin().getOriginTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MicroSecondDate parseDateIdentifier(String eqIdentifier) throws ParseException {
        ThreadSafeSimpleDateFormat threadSafeSimpleDateFormat = fullDateIdentifier;
        synchronized (threadSafeSimpleDateFormat) {
            return new MicroSecondDate(fullDateIdentifier.parse(eqIdentifier));
        }
    }

    public static VelocityEvent[] wrap(List evs) {
        VelocityEvent[] velEvs = new VelocityEvent[evs.size()];
        for (int i = 0; i < velEvs.length; ++i) {
            velEvs[i] = VelocityEvent.wrap((EventAccessOperations)evs.get(i));
        }
        return velEvs;
    }

    public static VelocityEvent[] wrap(EventAccessOperations[] evs) {
        VelocityEvent[] velEvs = new VelocityEvent[evs.length];
        for (int i = 0; i < velEvs.length; ++i) {
            velEvs[i] = VelocityEvent.wrap(evs[i]);
        }
        return velEvs;
    }

    public static VelocityEvent wrap(EventAccessOperations event) {
        if (event instanceof VelocityEvent) {
            return (VelocityEvent)event;
        }
        if (event instanceof CacheEvent) {
            return new VelocityEvent((CacheEvent)event);
        }
        return new VelocityEvent(new CacheEvent(event));
    }

    public InterfaceDef _get_interface() {
        throw new RuntimeException("should never be called");
    }

    public Object _get_component() {
        throw new RuntimeException("should never be called");
    }
}

