/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.example;

import edu.sc.seis.sod.validator.ModelWalker;
import edu.sc.seis.sod.validator.model.Annotation;
import edu.sc.seis.sod.validator.model.Attribute;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Data;
import edu.sc.seis.sod.validator.model.DataList;
import edu.sc.seis.sod.validator.model.Empty;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.MultigenitorForm;
import edu.sc.seis.sod.validator.model.NamedElement;
import edu.sc.seis.sod.validator.model.Text;
import edu.sc.seis.sod.validator.model.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ExampleBuilder {
    private StringBuffer buf = new StringBuffer();
    private List attrQueue = new ArrayList();
    private String openBracket;
    private String closeBracket;
    private Annotation requiredExample = null;
    private Form requiredForm;
    private boolean exampleInserted = false;
    public static final String DEFAULT_TEXT_VALUE = "text";
    public static final int DEFAULT_INT_VALUE = 12;

    public ExampleBuilder(boolean htmlReadable) {
        if (htmlReadable) {
            this.openBracket = "&lt;";
            this.closeBracket = "&gt;";
        } else {
            this.openBracket = "<";
            this.closeBracket = ">";
        }
    }

    public ExampleBuilder(String openBracket, String closeBracket) {
        this.openBracket = openBracket;
        this.closeBracket = closeBracket;
    }

    public void setRequiredExample(Annotation ann) {
        this.requiredExample = ann;
        this.requiredForm = ann.getFormProvider().getForm();
    }

    public boolean isExampleInserted() {
        return this.exampleInserted;
    }

    public void write(Form f) {
        this.write(f, true);
    }

    public void write(Form f, boolean ignoreMin) {
        if (!(f.getMin() != 0 || ignoreMin || f.getAnnotation().getInclude() || ModelWalker.isTowards(f, this.requiredForm))) {
            return;
        }
        if (f.equals(this.requiredForm)) {
            this.exampleInserted = true;
            this.buf.append(this.requiredExample.getExample(false));
            this.requiredExample = null;
            this.requiredForm = null;
            return;
        }
        if (f instanceof Attribute) {
            Attribute attr = (Attribute)f;
            if (!this.attrQueue.contains(attr)) {
                this.attrQueue.add(attr);
                this.buf.append(' ' + attr.getName() + "=\"");
                Form kid = attr.getChild();
                if (kid != null) {
                    this.write(kid, false);
                }
                this.buf.append('\"');
            } else {
                this.attrQueue.remove(attr);
            }
        } else if (f instanceof Choice) {
            Choice c = (Choice)f;
            Form[] children = c.getChildren();
            if (ModelWalker.getDistance(f, this.requiredForm) != -1) {
                int minDist = Integer.MAX_VALUE;
                Form chosenChild = null;
                for (int i = 0; i < children.length; ++i) {
                    int curDist = ModelWalker.getDistance(children[i], this.requiredForm);
                    if (curDist <= -1 || curDist >= minDist) continue;
                    minDist = curDist;
                    chosenChild = children[i];
                }
                this.write(chosenChild, true);
            } else {
                for (int i = 0; i < children.length; ++i) {
                    if (ModelWalker.requiresSelfReferentiality(children[i])) continue;
                    this.write(children[i], false);
                    break;
                }
            }
        } else if (f instanceof Value) {
            this.buf.append(((Value)f).getValue());
        } else if (f instanceof Data) {
            if (f.getAnnotation().hasExampleFromAnnotation()) {
                this.buf.append(f.getAnnotation().getExample(false));
            } else {
                this.buf.append(12);
            }
        } else if (!(f instanceof DataList)) {
            if (f instanceof Group || f instanceof Interleave) {
                MultigenitorForm m = (MultigenitorForm)f;
                Form[] kids = m.getChildren();
                for (int i = 0; i < kids.length; ++i) {
                    if (this.requiredExample != null && f.equals(kids[i])) {
                        this.write(kids[i], true);
                        continue;
                    }
                    this.write(kids[i], false);
                }
            } else if (f instanceof NamedElement) {
                NamedElement ne = (NamedElement)f;
                this.buf.append(this.openBracket + ne.getName());
                if (ne.getAttributes() != null) {
                    Attribute[] attrs = ne.getAttributes();
                    for (int i = 0; i < attrs.length; ++i) {
                        this.write(attrs[i], false);
                    }
                }
                if (ne.getChild() instanceof Empty && !(ne.getChild() instanceof Text)) {
                    this.buf.append(" /" + this.closeBracket + '\n');
                } else {
                    this.buf.append(this.closeBracket);
                    Form kid = ne.getChild();
                    if (kid != null) {
                        this.write(kid, false);
                    }
                    this.buf.append(this.openBracket + '/' + ne.getName() + this.closeBracket + '\n');
                }
            } else if (f instanceof Text) {
                this.buf.append(DEFAULT_TEXT_VALUE);
            } else if (f instanceof Empty) {
                // empty if block
            }
        }
    }

    public String toString() {
        return this.buf.toString();
    }

    public static String getNamespacePrefix(String nsURL) {
        StringTokenizer tok = new StringTokenizer(nsURL, "/");
        String prefix = null;
        while (tok.hasMoreTokens()) {
            prefix = tok.nextToken();
        }
        return prefix;
    }
}

