/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.documenter;

import edu.sc.seis.sod.validator.documenter.SchemaDocumenter;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Definition;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.GenitorForm;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.MultigenitorForm;
import edu.sc.seis.sod.validator.model.NamedElement;
import java.io.File;

public class VelocityModelHelper {
    public String getClass(Form f) {
        String classAttr = "class=\"";
        if (f.getMin() == 0) {
            classAttr = f.getMax() == 1 ? classAttr + "zeroToOne" : classAttr + "zeroToMany";
        } else if (f.getMax() == 1) {
            if (f instanceof MultigenitorForm) {
                classAttr = classAttr + "one";
            }
        } else {
            classAttr = classAttr + "oneToMany";
        }
        if (f instanceof MultigenitorForm) {
            classAttr = this.appendMultigenitorClass((MultigenitorForm)f, classAttr);
        }
        return classAttr + "\"";
    }

    private String appendMultigenitorClass(MultigenitorForm mf, String classAttr) {
        if (mf instanceof Choice) {
            classAttr = classAttr + "Choice";
        } else if (mf instanceof Interleave) {
            classAttr = classAttr + "Interleave";
        }
        return classAttr;
    }

    public boolean isMultigen(Form f) {
        return f instanceof MultigenitorForm;
    }

    public boolean isGen(Form f) {
        return f instanceof GenitorForm;
    }

    public boolean isChoice(Form f) {
        return f instanceof Choice;
    }

    public boolean isInterleave(Form f) {
        return f instanceof Interleave;
    }

    public boolean isGroup(Form f) {
        return f instanceof Group;
    }

    public int getLen(Object[] array) {
        return array.length;
    }

    public Object getItem(Object[] array, Integer index) {
        return array[index];
    }

    public String getName(Object o) {
        if (o instanceof Definition) {
            return this.getDefName((Definition)o);
        }
        return o.toString();
    }

    public String getDefName(Object o) {
        if (o instanceof Definition) {
            return this.getDefName((Definition)o);
        }
        if (o == null) {
            return "NULL";
        }
        if (o instanceof Form) {
            return this.getDefName(SchemaDocumenter.getNearestDef((Form)o));
        }
        return o.toString();
    }

    public String getDefName(Definition d) {
        if (d.getForm() instanceof NamedElement) {
            return ((NamedElement)d.getForm()).getName();
        }
        if (d.getName().equals("")) {
            String filename = new File(d.getGrammar().getLoc()).getName();
            return filename.substring(0, filename.length() - 4) + " Start";
        }
        return d.getName();
    }

    public int length(Object[] objs) {
        return objs.length;
    }
}

