/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.tools;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.seisFile.client.AbstractClient;
import edu.sc.seis.sod.Args;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.Version;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.apache.velocity.VelocityContext;
import org.xml.sax.InputSource;

public class CommandLineTool
extends AbstractClient {
    protected boolean requiresStdin = false;

    public CommandLineTool(String[] args) throws JSAPException {
        super(args);
    }

    protected void addParams() throws JSAPException {
        super.addParams();
        this.add((Parameter)new Switch("recipe", 'r', "recipe", "Print the created recipe to stdout instead of running it"));
        this.add((Parameter)new FlaggedOption("server", (StringParser)JSAP.STRING_PARSER, null, false, 'S', "server", "The server to use, default is 'service.iris.edu'"));
    }

    public VelocityContext getContext() {
        VelocityContext vc = new VelocityContext();
        for (Object cur : this.params) {
            if (cur instanceof Switch) {
                Switch sw = (Switch)cur;
                if (!this.result.getBoolean(sw.getID())) continue;
                vc.put(sw.getID(), (Object)Boolean.TRUE);
                continue;
            }
            Option param = (Option)cur;
            if (param.isList()) {
                Object[] paramResult = this.result.getObjectArray(param.getID());
                if (paramResult.length <= 0) continue;
                vc.put(param.getID(), (Object)paramResult);
                continue;
            }
            if (this.result.getObject(param.getID()) == null) continue;
            vc.put(param.getID(), this.result.getObject(param.getID()));
        }
        return vc;
    }

    public boolean shouldPrintRecipe() {
        return this.result.getBoolean("recipe");
    }

    public InputStream getTemplate() throws IOException {
        String className = ((Object)((Object)this)).getClass().getName().replace('.', '/');
        return Start.createInputStream("jar:" + className + ".vm");
    }

    public static void run(CommandLineTool ls) throws Exception {
        Start.checkGCJ();
        if (ls.shouldPrintRecipe()) {
            System.out.println("<sod>");
            System.out.flush();
        }
        Start.setCommandName(ls.commandName);
        Properties props = System.getProperties();
        Initializer.loadProps((InputStream)Start.createInputStream("jar:edu/sc/seis/sod/tools/simple.props"), (Properties)props);
        Initializer.loadProperties((String[])ls.getArgs(), (Properties)props, (boolean)false);
        PropertyConfigurator.configure((Properties)props);
        if (ls.shouldPrintHelp()) {
            System.err.println(Args.makeHelp(ls.commandName, ls.params));
            System.exit(0);
        }
        if (ls.shouldPrintVersion()) {
            System.err.println(ls.commandName + " " + Version.current().getVersion());
            System.exit(0);
        }
        if (!ls.isSuccess()) {
            Start.exit(Args.makeError(ls.commandName, ls.params, ls.result));
        }
        VelocityContext ctx = ls.getContext();
        SimpleVelocitizer sv = new SimpleVelocitizer();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (System.in.available() > 0) {
            String line;
            StringBuffer buff = new StringBuffer();
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader r = new BufferedReader(isr);
            boolean inSod = false;
            while ((line = r.readLine()) != null) {
                if (!inSod && line.indexOf("<sod>") != -1) {
                    inSod = true;
                    continue;
                }
                if (!inSod) continue;
                if (line.indexOf("</sod>") != -1) {
                    inSod = false;
                    continue;
                }
                buff.append(line);
                buff.append('\n');
            }
            if (buff.length() == 0) {
                if (!inSod) {
                    System.err.println("There was input on sysin, but it doesn't look like it was a recipe file");
                }
                System.exit(1);
            }
            ctx.put("additionalArms", (Object)buff.toString());
        } else if (ls.requiresStdin) {
            Start.exit("This tool requires that a recipe be piped into it.");
        } else {
            ctx.put("additionalArms", (Object)"");
        }
        final String result = sv.evaluate(ls.getTemplate(), ctx);
        if (ls.shouldPrintRecipe()) {
            System.out.println(result);
            System.exit(0);
        }
        try {
            Start s = new Start(new Args(new String[]{"-f", "<stream>"}), new Start.InputSourceCreator(){

                @Override
                public InputSource create() {
                    return new InputSource(new StringReader("<sod>\n" + result));
                }
            }, props, true);
            s.start();
        }
        catch (UserConfigurationException e) {
            Start.exit(e.getMessage() + "  SOD will quit now and continue to cowardly quit until this is corrected.");
        }
    }
}

