/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.station;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public class BelongsToVirtual
implements StationSubsetter {
    private String name;
    private List<? extends StationImpl> stations;
    private TimeInterval refreshInterval;
    private MicroSecondDate lastQuery = new MicroSecondDate(0L);

    private static NetworkAccess getVirtual(NetworkSource networkSource, String name) throws ConfigurationException {
        try {
            List<? extends CacheNetworkAccess> nets = networkSource.getNetworkByName(name);
            if (nets.size() > 1) {
                throw new ConfigurationException("There are several nets with the name " + name);
            }
            return (NetworkAccess)nets.get(0);
        }
        catch (NetworkNotFound nnf) {
            throw new UserConfigurationException("No network by the name of " + name + " found");
        }
    }

    public BelongsToVirtual(Element el) throws ConfigurationException {
        this(SodUtil.getNestedText(el), null);
    }

    public BelongsToVirtual(String virtualNetName, TimeInterval refreshInterval) {
        this.name = virtualNetName;
        this.refreshInterval = refreshInterval;
    }

    @Override
    public StringTree accept(StationImpl station, NetworkSource network) throws ConfigurationException, SodSourceException {
        this.refreshStations(network);
        for (StationImpl stationImpl : this.stations) {
            if (!StationIdUtil.areEqual((Station)station, (Station)stationImpl)) continue;
            return new Pass(this);
        }
        return new Fail(this);
    }

    private void refreshStations(NetworkSource network) throws ConfigurationException, SodSourceException {
        if (ClockUtil.now().subtract(this.getRefreshInterval()).after((Date)this.lastQuery)) {
            this.lastQuery = ClockUtil.now();
            NetworkAccess virtual = BelongsToVirtual.getVirtual(network, this.name);
            this.stations = network.getStations((NetworkAttrImpl)virtual.get_attributes());
        }
    }

    public TimeInterval getRefreshInterval() {
        if (this.refreshInterval == null) {
            this.refreshInterval = Start.getNetworkArm().getRefreshInterval();
        }
        return this.refreshInterval;
    }
}

