/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.request;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.ParseRegions;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.VelocityFileElementParser;
import edu.sc.seis.sod.subsetter.request.RequestSubsetter;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.WaveformProcessContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.Element;

public class BreqFastRequest
implements RequestSubsetter {
    static final String nl = "\n";
    ThreadSafeSimpleDateFormat format = new ThreadSafeSimpleDateFormat("yyyy MM dd HH mm ss.", ISOTime.UTC);
    ThreadSafeSimpleDateFormat tenths = new ThreadSafeSimpleDateFormat("SSS", ISOTime.UTC);
    ParseRegions regions;
    Element config;
    private String fullTemplate;
    private String labelTemplate;
    private SimpleVelocitizer velocitizer = new SimpleVelocitizer();

    public BreqFastRequest(Element config) throws ConfigurationException {
        this.config = config;
        VelocityFileElementParser parser = new VelocityFileElementParser(config, this.getDefaultWorkingDir(), this.getDefaultFileTemplate());
        this.labelTemplate = DOMHelper.extractText((Element)config, (String)"label", (String)"${event.getTime('yyyy.DDD.HH.mm.ss.SSSS')}");
        this.fullTemplate = parser.getTemplate();
        this.regions = ParseRegions.getInstance();
    }

    @Override
    public StringTree accept(CacheEvent event, ChannelImpl channel, RequestFilter[] request, CookieJar cookieJar) {
        return new StringTreeLeaf(this, this.writeToBFEmail((EventAccessOperations)event, channel, request));
    }

    protected String getConfig(String name) {
        return SodUtil.getText(SodUtil.getElement(this.config, name));
    }

    protected synchronized boolean writeToBFEmail(EventAccessOperations event, ChannelImpl channel, RequestFilter[] request) {
        WaveformProcessContext ctx = new WaveformProcessContext(event, channel, request, new RequestFilter[0], new LocalSeismogramImpl[0], null);
        String bfastLoc = FissuresFormatter.filize(this.velocitizer.evaluate(this.fullTemplate, (VelocityContext)ctx));
        File bfFile = new File(bfastLoc);
        File parent = bfFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("Unable to create directory." + parent);
        }
        boolean fileExists = bfFile.exists();
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(bfFile.getAbsolutePath(), true));
            if (!fileExists) {
                this.insertEventHeader(event, out, this.velocitizer.evaluate(this.labelTemplate, (VelocityContext)ctx));
            }
            for (int i = 0; i < request.length; ++i) {
                this.insertRequest((Channel)channel, request, out, i);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Trouble writing breqfast request!", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close breqfast file!", e);
                }
            }
        }
        return true;
    }

    protected void optInsert(Writer out, String configName) throws IOException {
        this.optInsert(out, configName, configName.toUpperCase());
    }

    protected void optInsert(Writer out, String configName, String fieldName) throws IOException {
        if (SodUtil.getElement(this.config, configName) != null) {
            this.insert(out, configName, fieldName);
        }
    }

    protected void insert(Writer out, String configName) throws IOException {
        this.insert(out, configName, configName.toUpperCase());
    }

    protected void insert(Writer out, String configName, String fieldName) throws IOException {
        out.write("." + fieldName + " " + this.getConfig(configName) + nl);
    }

    protected void insertRequest(Channel channel, RequestFilter[] request, Writer out, int i) throws IOException {
        MicroSecondDate start = new MicroSecondDate(request[i].start_time);
        MicroSecondDate end = new MicroSecondDate(request[i].end_time);
        out.write(channel.getSite().getStation().get_code() + " " + channel.getSite().getStation().getNetworkAttr().get_code() + " " + this.format.format((Date)start) + this.tenths.format((Date)start).substring(0, 1) + " " + this.format.format((Date)end) + this.tenths.format((Date)end).substring(0, 1) + " 1 " + channel.get_code() + " " + channel.getSite().get_code() + nl);
    }

    protected void insertEventHeader(EventAccessOperations event, Writer out, String label) throws IOException {
        this.insert(out, "name");
        this.insert(out, "inst");
        this.insert(out, "mail");
        this.insert(out, "email");
        this.insert(out, "phone");
        this.insert(out, "fax");
        this.insert(out, "media");
        this.insert(out, "altmedia1", "ALTERNATIVE MEDIA");
        this.insert(out, "altmedia2", "ALTERNATIVE MEDIA");
        OriginImpl o = EventUtil.extractOrigin((EventAccessOperations)event);
        out.write(".SOURCE ~" + o.getCatalog() + " " + o.getContributor() + "~unknown~unknown~" + nl);
        MicroSecondDate oTime = new MicroSecondDate(o.getOriginTime());
        out.write(".HYPO ~" + this.format.format((Date)oTime) + this.tenths.format((Date)oTime) + "~" + o.getLocation().latitude + "~" + o.getLocation().longitude + "~" + ((QuantityImpl)o.getLocation().depth).convertTo(UnitImpl.KILOMETER).getValue() + "~0~" + event.get_attributes().region.number + "~" + this.regions.getRegionName(event.get_attributes().region) + "~" + nl);
        for (int j = 0; j < o.getMagnitudes().length; ++j) {
            out.write(".MAGNITUDE ~" + o.getMagnitudes()[j].value + "~" + o.getMagnitudes()[j].type + "~" + nl);
        }
        this.insert(out, "quality");
        out.write(".LABEL " + label + nl);
        out.write(".END\n");
        out.write(nl);
    }

    protected String getDefaultWorkingDir() {
        return "breqfast";
    }

    protected String getDefaultFileTemplate() {
        return "${event.getTime('yyyy.DDD.HH.mm.ss.SSSS')}.breq";
    }
}

