/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.InstrumentationLoader;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairSensitivity
implements ChannelSubsetter {
    private Logger logger = LoggerFactory.getLogger(RepairSensitivity.class);

    @Override
    public StringTree accept(ChannelImpl channel, NetworkSource network) throws Exception {
        Instrumentation instrumentation;
        try {
            QuantityImpl sensitivity = network.getSensitivity(channel);
            if (InstrumentationLoader.isValidSensitivity((QuantityImpl)sensitivity)) {
                return new Pass(this);
            }
            instrumentation = network.getInstrumentation(channel);
        }
        catch (ChannelNotFound e) {
            return new Fail((Object)this, "No instrumentation");
        }
        catch (InvalidResponse e) {
            return new Fail((Object)this, "Invalid instrumentation: " + e.getMessage());
        }
        if (InstrumentationLoader.isValid((Instrumentation)instrumentation)) {
            return new Pass(this);
        }
        Response resp = instrumentation.the_response;
        Stage[] stages = resp.stages;
        if (stages.length == 0) {
            return new StringTreeLeaf(this, false, "No stages in the response of " + ChannelIdUtil.toString((ChannelId)channel.get_id()));
        }
        InstrumentationLoader.repairResponse((Response)instrumentation.the_response);
        return new StringTreeLeaf(this, InstrumentationLoader.isValid((Response)instrumentation.the_response));
    }
}

