/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeBranch;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.channel.CompositeChannelSubsetter;
import edu.sc.seis.sod.subsetter.station.StationLogicalSubsetter;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public abstract class ChannelLogicalSubsetter
extends CompositeChannelSubsetter {
    public static final List<String> packages = new LinkedList<String>();

    public ChannelLogicalSubsetter(Element config) throws ConfigurationException {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringTree accept(ChannelImpl e, NetworkSource network) throws Exception {
        ArrayList<StringTree> reasons = new ArrayList<StringTree>(this.subsetters.size());
        Iterator it = this.subsetters.iterator();
        while (it.hasNext()) {
            StringTree result;
            ChannelSubsetter processor;
            ChannelSubsetter channelSubsetter = processor = (ChannelSubsetter)it.next();
            synchronized (channelSubsetter) {
                result = processor.accept(e, network);
            }
            reasons.add(result);
            if (this.shouldContinue(result)) continue;
            break;
        }
        StringTree[] results = reasons.toArray(new StringTree[0]);
        return new StringTreeBranch((Object)this, this.isSuccess(results), results);
    }

    public abstract boolean shouldContinue(StringTree var1);

    public abstract boolean isSuccess(StringTree[] var1);

    public static ChannelSubsetter createSubsetter(final Subsetter s) throws ConfigurationException {
        if (s instanceof ChannelSubsetter) {
            return (ChannelSubsetter)s;
        }
        return new ChannelSubsetter(){
            StationSubsetter ss;
            {
                this.ss = StationLogicalSubsetter.createSubsetter(s);
            }

            @Override
            public StringTree accept(ChannelImpl channel, NetworkSource network) throws Exception {
                return this.ss.accept((StationImpl)channel.getStation(), network);
            }
        };
    }

    static {
        packages.add("channel");
        packages.addAll(StationLogicalSubsetter.packages);
    }
}

