/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.status.ErrorCountTemplate;
import edu.sc.seis.sod.status.IndexTemplate;
import edu.sc.seis.sod.status.NowTemplate;
import edu.sc.seis.sod.status.RunNameTemplate;
import edu.sc.seis.sod.status.StartTimeTemplate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Template {
    private String builtUpText = "";
    protected List templates = new ArrayList();
    private static Logger logger = LoggerFactory.getLogger(Template.class);

    protected abstract Object textTemplate(String var1);

    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        return this.getCommonTemplate(tag, el);
    }

    protected Object getCommonTemplate(String tag, Element el) {
        if (tag.equals("runName")) {
            return new RunNameTemplate();
        }
        if (tag.equals("startTime")) {
            return new StartTimeTemplate();
        }
        if (tag.equals("now")) {
            return new NowTemplate();
        }
        if (tag.equals("configFileLoc")) {
            return this.textTemplate(IndexTemplate.getCopiedConfigFileLocation());
        }
        if (tag.equals("htmlConfigFileLoc")) {
            return this.textTemplate(IndexTemplate.getHtmlConfigFileName());
        }
        if (tag.equals("errorCount")) {
            return new ErrorCountTemplate();
        }
        return null;
    }

    protected void parse(Element el) throws ConfigurationException {
        this.parse(el, false);
    }

    protected void parse(Element el, boolean trim) throws ConfigurationException {
        this.parse(el.getChildNodes(), trim);
        if (!this.builtUpText.equals("")) {
            this.templates.add(this.textTemplate(this.builtUpText));
        }
    }

    private void parse(NodeList nl) throws ConfigurationException {
        this.parse(nl, false);
    }

    private void parse(NodeList nl, boolean trim) throws ConfigurationException {
        for (int i = 0; i < nl.getLength(); ++i) {
            String name;
            Node n = nl.item(i);
            if (n.getNodeType() == 3) {
                String s = n.getNodeValue();
                if (trim) {
                    s = s.trim();
                    s = s.replaceAll("\\s", "");
                }
                this.addString(s);
                continue;
            }
            if (n.getNodeType() == 8 || (name = n.getNodeName()).equals("attribute")) continue;
            Object template = this.getTemplate(name, (Element)n);
            if (template != null) {
                this.addTemplate(template);
                continue;
            }
            this.addString("<" + name);
            int numAttr = this.addAttributes(n);
            if (n.getChildNodes().getLength() - numAttr == 0) {
                this.addString("/>");
                continue;
            }
            this.addString(">");
            this.parse(n.getChildNodes());
            this.addString("</" + name + ">");
        }
    }

    private void addTemplate(Object template) {
        if (!this.builtUpText.equals("")) {
            this.templates.add(this.textTemplate(this.builtUpText));
        }
        this.templates.add(template);
        this.builtUpText = "";
    }

    private void addString(String text) {
        this.builtUpText = this.builtUpText + text;
    }

    private int addAttributes(Node n) throws ConfigurationException {
        this.addString(this.getAttrString(n));
        int numAttr = 0;
        for (int i = 0; i < n.getChildNodes().getLength() && Template.childName(i, n).equals("attribute"); ++i) {
            Element attr = (Element)n.getChildNodes().item(i);
            this.addString(" " + attr.getAttribute("name") + "=\"");
            this.parse(attr.getChildNodes());
            this.addString("\"");
            ++numAttr;
        }
        return numAttr;
    }

    private static String childName(int i, Node n) {
        return n.getChildNodes().item(i).getNodeName();
    }

    private String getAttrString(Node n) {
        String result = "";
        NamedNodeMap attr = n.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            result = result + " " + attr.item(i).getNodeName();
            result = result + "=\"" + attr.item(i).getNodeValue() + "\"";
        }
        return result;
    }

    public void setUp() {
    }
}

