/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.RequestFilterUtil;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.waveserver.MenuItem;
import edu.sc.seis.seisFile.waveserver.WaveServer;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WinstonWaveServerSource
implements SeismogramSource {
    private WaveServer ws;

    public WinstonWaveServerSource(WaveServer ws) {
        this.ws = ws;
    }

    public static MicroSecondDate toDate(double d) {
        return new MicroSecondDate(Math.round(d * 1000000.0));
    }

    public static double toEpochSeconds(Time d) {
        return (double)new MicroSecondDate(d).getMicroSecondTime() / 1000000.0;
    }

    public static double toY2KSeconds(Time d) {
        return WinstonWaveServerSource.toY2KSeconds(new MicroSecondDate(d));
    }

    public static double toY2KSeconds(MicroSecondDate d) {
        return (double)d.getMicroSecondTime() / 1000000.0 - 9.46728E8;
    }

    public static MicroSecondDate y2kSecondsToDate(double d) {
        return WinstonWaveServerSource.toDate(d + 9.46728E8);
    }

    @Override
    public List<RequestFilter> availableData(List<RequestFilter> request) throws SeismogramSourceException {
        ArrayList<RequestFilter> out = new ArrayList<RequestFilter>();
        try {
            List menu = this.ws.getMenu();
            for (RequestFilter rf : request) {
                for (MenuItem item : menu) {
                    MicroSecondTimeRange rfRange;
                    MicroSecondDate end;
                    MicroSecondDate start;
                    MicroSecondTimeRange menuRange;
                    if (!item.getChannel().equals(rf.channel_id.channel_code) || !item.getStation().equals(rf.channel_id.station_code) || !item.getNetwork().equals(rf.channel_id.network_id.network_code) || !item.getLocation().equals(rf.channel_id.site_code) && (!item.getLocation().equals("--") || !rf.channel_id.site_code.equals("  ")) || !(menuRange = new MicroSecondTimeRange(start = WinstonWaveServerSource.toDate(item.getStart()), end = WinstonWaveServerSource.toDate(item.getEnd()))).intersects(rfRange = new MicroSecondTimeRange(rf))) continue;
                    MicroSecondTimeRange intersection = menuRange.intersection(rfRange);
                    out.add(new RequestFilter(rf.channel_id, intersection.getBeginTime().getFissuresTime(), intersection.getEndTime().getFissuresTime()));
                }
            }
            return out;
        }
        catch (IOException e) {
            throw new SeismogramSourceException("unable to get menu from WaveServer(" + this.ws.getHost() + ", " + this.ws.getPort() + ")", e);
        }
    }

    @Override
    public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws SeismogramSourceException {
        ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
        for (RequestFilter rf : request) {
            try {
                List traceBufs = this.ws.getTraceBuf(rf.channel_id.network_id.network_code, rf.channel_id.station_code, rf.channel_id.site_code, rf.channel_id.channel_code, (Date)new MicroSecondDate(rf.start_time), (Date)new MicroSecondDate(rf.end_time));
                if (traceBufs == null) continue;
                for (TraceBuf2 buf : traceBufs) {
                    out.add(WinstonWaveServerSource.toFissures(buf, rf.channel_id));
                }
            }
            catch (IOException e) {
                throw new SeismogramSourceException("unable to get TraceBuf from WaveServer(" + this.ws.getHost() + ", " + this.ws.getPort() + ") for " + RequestFilterUtil.toString((RequestFilter)rf), e);
            }
        }
        return out;
    }

    public static LocalSeismogramImpl toFissures(TraceBuf2 buf, ChannelId chan) {
        SeismogramAttrImpl seisAttr = new SeismogramAttrImpl("via WaveServer:" + Math.random(), WinstonWaveServerSource.toDate(buf.getStartTime()).getFissuresTime(), buf.getNumSamples(), (Sampling)new SamplingImpl(1, new TimeInterval(1.0 / buf.getSampleRate(), UnitImpl.SECOND)), (Unit)UnitImpl.COUNT, chan);
        if (buf.isShortData()) {
            return new LocalSeismogramImpl((SeismogramAttr)seisAttr, buf.getShortData());
        }
        if (buf.isIntData()) {
            return new LocalSeismogramImpl((SeismogramAttr)seisAttr, buf.getIntData());
        }
        if (buf.isFloatData()) {
            return new LocalSeismogramImpl((SeismogramAttr)seisAttr, buf.getFloatData());
        }
        if (buf.isDoubleData()) {
            return new LocalSeismogramImpl((SeismogramAttr)seisAttr, buf.getDoubleData());
        }
        throw new RuntimeException("Unknwon data type: " + buf.getDataType());
    }
}

