/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Cut;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceException;
import java.util.ArrayList;
import java.util.List;

public class PromiseSeismogramList {
    SeismogramSourceException seismogramSourceException;
    List<LocalSeismogramImpl> matching;
    List<RequestFilter> request;

    PromiseSeismogramList(List<RequestFilter> request) {
        this.request = request;
    }

    public List<RequestFilter> getRequest() {
        return this.request;
    }

    public synchronized List<LocalSeismogramImpl> getResult() throws SeismogramSourceException {
        while (this.matching == null && this.seismogramSourceException == null) {
            try {
                this.notifyAll();
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.seismogramSourceException != null) {
            throw this.seismogramSourceException;
        }
        return this.matching;
    }

    synchronized void finishRequest(List<LocalSeismogramImpl> seisList) throws SeismogramSourceException {
        try {
            this.matching = new ArrayList<LocalSeismogramImpl>();
            block2: for (LocalSeismogramImpl seis : seisList) {
                for (RequestFilter rf : this.request) {
                    MicroSecondTimeRange seisRange;
                    MicroSecondTimeRange rfRange;
                    if (!ChannelIdUtil.areEqualExceptForBeginTime((ChannelId)rf.channel_id, (ChannelId)seis.getChannelID()) || !(rfRange = new MicroSecondTimeRange(rf)).intersects(seisRange = new MicroSecondTimeRange(seis))) continue;
                    Cut c = new Cut(rf);
                    this.matching.add(c.applyEncoded(seis));
                    continue block2;
                }
            }
            this.notifyAll();
        }
        catch (FissuresException e) {
            throw new SeismogramSourceException(e);
        }
    }

    synchronized void seismogramSourceException(SeismogramSourceException e) {
        this.seismogramSourceException = e;
        this.notifyAll();
    }
}

