/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.seismogram.ChoiceSourceItem;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChoiceSource
implements SeismogramSourceLocator {
    private List<ChoiceSourceItem> choices = new ArrayList<ChoiceSourceItem>();
    private SeismogramSourceLocator otherwise;

    public ChoiceSource(List<ChoiceSourceItem> choices, SeismogramSourceLocator otherwise) {
        this.choices = choices;
        this.otherwise = otherwise;
    }

    public ChoiceSource(Element config) throws ConfigurationException {
        NodeList choiceNodes = DOMHelper.extractNodes((Element)config, (String)"choice");
        for (int i = 0; i < choiceNodes.getLength(); ++i) {
            this.choices.add(new ChoiceSourceItem((Element)choiceNodes.item(i)));
        }
        Element otherwiseEl = DOMHelper.extractElement((Element)config, (String)"otherwise/*");
        this.otherwise = (SeismogramSourceLocator)SodUtil.load(otherwiseEl, "seismogram");
    }

    @Override
    public SeismogramSource getSeismogramSource(CacheEvent event, ChannelImpl channel, RequestFilter[] infilters, CookieJar cookieJar) throws Exception {
        for (ChoiceSourceItem cur : this.choices) {
            if (!cur.accept(event, channel, cookieJar).isSuccess()) continue;
            return cur.getSeismogramSource(event, channel, infilters, cookieJar);
        }
        return this.otherwise.getSeismogramSource(event, channel, infilters, cookieJar);
    }
}

