/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.BoxAreaImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.InstrumentationImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.chooser.CoarseAvailableData;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.fissuresUtil.stationxml.ChannelSensitivityBundle;
import edu.sc.seis.fissuresUtil.stationxml.StationXMLToFissures;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.DataAvailability;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationIterator;
import edu.sc.seis.sod.BuildVersion;
import edu.sc.seis.sod.RunProperties;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.AbstractNetworkSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.subsetter.station.StationPointDistance;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FdsnStation
extends AbstractNetworkSource {
    boolean includeAvailability = true;
    boolean validateXML = false;
    public static final TimeInterval ONE_SECOND = new TimeInterval(1.0, UnitImpl.SECOND);
    CoarseAvailableData availableData = new CoarseAvailableData();
    HashMap<String, QuantityImpl> chanSensitivityMap = new HashMap();
    FDSNStationQueryParams queryParams = new FDSNStationQueryParams();
    private static final Logger logger = LoggerFactory.getLogger(FdsnStation.class);

    public FdsnStation() {
        super("defaultFDSNNetwork", -1);
    }

    public FdsnStation(String name, int retries, FDSNStationQueryParams queryParams) {
        super(name, retries);
        this.queryParams = queryParams;
    }

    public FdsnStation(Element config) throws Exception {
        super(config);
        this.queryParams.clearIncludeRestricted();
        this.queryParams.clearIncludeAvailability();
        this.includeAvailability = SodUtil.isTrue(config, "includeAvailability", true);
        this.validateXML = SodUtil.isTrue(config, "validate", false);
        if (config != null) {
            int port = SodUtil.loadInt(config, "port", -1);
            if (port > 0) {
                this.queryParams.setPort(port);
            }
            NodeList childNodes = config.getChildNodes();
            for (int counter = 0; counter < childNodes.getLength(); ++counter) {
                String fdsnwsPath;
                Node node = childNodes.item(counter);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                if (element.getTagName().equals("stationBoxArea")) {
                    BoxAreaImpl a = SodUtil.loadBoxArea(element);
                    this.queryParams.area(a.min_latitude, a.max_latitude, a.min_longitude, a.max_longitude);
                    continue;
                }
                if (element.getTagName().equals("stationPointDistance")) {
                    StationPointDistance pd = (StationPointDistance)SodUtil.load(element, new String[]{"station"});
                    this.queryParams.donut((float)pd.getLatitude(), (float)pd.getLongitude(), (float)pd.getMin().getValue(UnitImpl.DEGREE), (float)pd.getMax().getValue(UnitImpl.DEGREE));
                    continue;
                }
                if (element.getTagName().equals("networkCode")) {
                    this.queryParams.appendToNetwork(SodUtil.getNestedText(element));
                    continue;
                }
                if (element.getTagName().equals("stationCode")) {
                    this.queryParams.appendToStation(SodUtil.getNestedText(element));
                    continue;
                }
                if (element.getTagName().equals("siteCode")) {
                    this.queryParams.appendToLocation(SodUtil.getNestedText(element));
                    continue;
                }
                if (element.getTagName().equals("channelCode")) {
                    this.queryParams.appendToChannel(SodUtil.getNestedText(element));
                    continue;
                }
                if (element.getTagName().equals("includeRestricted")) {
                    this.queryParams.setIncludeRestricted(true);
                    continue;
                }
                if (element.getTagName().equals("host")) {
                    String host = SodUtil.getNestedText(element);
                    this.queryParams.setHost(host);
                    this.name = host;
                    continue;
                }
                if (!element.getTagName().equals("fdsnwsPath") || (fdsnwsPath = SodUtil.getNestedText(element)) == null || fdsnwsPath.length() == 0) continue;
                this.queryParams.setFdsnwsPath(fdsnwsPath);
                logger.debug("Set fdsnwsPath: " + fdsnwsPath);
            }
        }
    }

    public void includeRestricted(boolean val) {
        this.queryParams.setIncludeRestricted(val);
    }

    @Override
    public CacheNetworkAccess getNetwork(NetworkAttrImpl attr) {
        return new CacheNetworkAccess(null, attr);
    }

    @Override
    public List<? extends CacheNetworkAccess> getNetworkByName(String name) throws NetworkNotFound {
        throw new NetworkNotFound();
    }

    @Override
    public List<? extends NetworkAttrImpl> getNetworks() throws SodSourceException {
        ArrayList<NetworkAttrImpl> out = new ArrayList<NetworkAttrImpl>();
        FDSNStationXML staxml = null;
        try {
            FDSNStationQueryParams staQP = this.setupQueryParams();
            staQP.setLevel("network");
            staQP.clearChannel();
            staQP.clearStartAfter().clearStartBefore().clearStartTime();
            staQP.clearEndAfter().clearEndBefore().clearEndTime();
            logger.debug("getNetworks " + staQP.formURI());
            staxml = this.internalGetStationXML(staQP);
            NetworkIterator netIt = staxml.getNetworks();
            while (netIt.hasNext()) {
                Network n = netIt.next();
                out.add(StationXMLToFissures.convert((Network)n));
            }
            ArrayList<NetworkAttrImpl> arrayList = out;
            return arrayList;
        }
        catch (URISyntaxException e) {
            throw new SodSourceException("Problem forming URI", e);
        }
        catch (SeisFileException e) {
            throw new SodSourceException(e);
        }
        catch (XMLValidationException e) {
            logger.warn("InvalidXML: getting networks" + e.getMessage().replace('\n', ' '));
            logger.debug("InvalidXML: getting networks" + e.getMessage().replace('\n', ' '), (Throwable)e);
            ArrayList<NetworkAttrImpl> arrayList = out;
            return arrayList;
        }
        catch (XMLStreamException e) {
            throw new SodSourceException(e);
        }
        finally {
            if (staxml != null) {
                staxml.closeReader();
            }
        }
    }

    @Override
    public List<? extends StationImpl> getStations(NetworkAttrImpl net) throws SodSourceException {
        ArrayList<StationImpl> out = new ArrayList<StationImpl>();
        FDSNStationXML staxml = null;
        try {
            FDSNStationQueryParams staQP = this.setupQueryParams();
            String netString = staQP.getParam("network");
            if (netString != null) {
                String[] paramNets = netString.split(",");
                staQP.clearNetwork();
                for (int i = 0; i < paramNets.length; ++i) {
                    if (paramNets[i].length() <= 2) continue;
                    staQP.appendToNetwork(paramNets[i]);
                }
            }
            staQP.setLevel("station");
            staQP.appendToNetwork(net.getId().network_code);
            FdsnStation.setTimeParams(staQP, net.getBeginTime(), net.getEndTime(), this.constraints);
            logger.debug("getStations " + staQP.formURI());
            staxml = this.internalGetStationXML(staQP);
            NetworkIterator netIt = staxml.getNetworks();
            while (netIt.hasNext()) {
                Network n = netIt.next();
                NetworkAttrImpl netAttr = StationXMLToFissures.convert((Network)n);
                StationIterator staIt = n.getStations();
                while (staIt.hasNext()) {
                    Station s = staIt.next();
                    out.add(StationXMLToFissures.convert((Station)s, (NetworkAttrImpl)netAttr));
                }
            }
            ArrayList<StationImpl> arrayList = out;
            return arrayList;
        }
        catch (URISyntaxException e) {
            throw new SodSourceException("Problem forming URI", e);
        }
        catch (SeisFileException e) {
            throw new SodSourceException(e);
        }
        catch (XMLValidationException e) {
            logger.warn("InvalidXML: " + NetworkIdUtil.toString((NetworkId)net.get_id()) + " " + e.getMessage().replace('\n', ' '));
            logger.debug("InvalidXML: " + NetworkIdUtil.toString((NetworkId)net.get_id()) + " " + e.getMessage().replace('\n', ' '), (Throwable)e);
            ArrayList<StationImpl> arrayList = out;
            return arrayList;
        }
        catch (XMLStreamException e) {
            throw new SodSourceException(e);
        }
        finally {
            if (staxml != null) {
                staxml.closeReader();
            }
        }
    }

    @Override
    public List<? extends ChannelImpl> getChannels(StationImpl station) throws SodSourceException {
        ArrayList<ChannelImpl> out = new ArrayList<ChannelImpl>();
        FDSNStationXML staxml = null;
        try {
            FDSNStationQueryParams staQP = this.setupQueryParams();
            staQP.setLevel("channel");
            staQP.setIncludeAvailability(this.includeAvailability);
            staQP.clearNetwork().appendToNetwork(station.getId().network_id.network_code).clearStation().appendToStation(station.getId().station_code);
            FdsnStation.setTimeParams(staQP, station.getBeginTime(), station.getEndTime(), this.constraints);
            logger.info("getChannels " + staQP.formURI());
            staxml = this.internalGetStationXML(staQP);
            NetworkIterator netIt = staxml.getNetworks();
            while (netIt.hasNext()) {
                Network n = netIt.next();
                NetworkAttrImpl netAttr = StationXMLToFissures.convert((Network)n);
                StationIterator staIt = n.getStations();
                while (staIt.hasNext()) {
                    Station s = staIt.next();
                    StationImpl sImpl = StationXMLToFissures.convert((Station)s, (NetworkAttrImpl)netAttr);
                    for (Channel c : s.getChannelList()) {
                        ArrayList<MicroSecondTimeRange> mstrList;
                        MicroSecondTimeRange range;
                        ChannelSensitivityBundle csb = StationXMLToFissures.convert((Channel)c, (StationImpl)sImpl);
                        out.add(csb.getChan());
                        this.chanSensitivityMap.put(ChannelIdUtil.toString((ChannelId)csb.getChan().get_id()), csb.getSensitivity());
                        DataAvailability da = c.getDataAvailability();
                        if (da != null && da.getExtent() != null) {
                            range = new MicroSecondTimeRange(new MicroSecondDate(da.getExtent().getStart()), new MicroSecondDate(da.getExtent().getEnd()));
                            mstrList = new ArrayList();
                            mstrList.add(range);
                            this.availableData.update(csb.getChan().get_id(), mstrList);
                            continue;
                        }
                        if (this.includeAvailability) {
                            this.availableData.update(csb.getChan().get_id(), new ArrayList());
                            continue;
                        }
                        range = new MicroSecondTimeRange(csb.getChan().getEffectiveTime());
                        mstrList = new ArrayList<MicroSecondTimeRange>();
                        mstrList.add(range);
                        this.availableData.update(csb.getChan().get_id(), mstrList);
                    }
                }
            }
            ArrayList<ChannelImpl> arrayList = out;
            return arrayList;
        }
        catch (URISyntaxException e) {
            throw new SodSourceException("Problem forming URI", e);
        }
        catch (SeisFileException e) {
            throw new SodSourceException(e);
        }
        catch (XMLValidationException e) {
            logger.warn("InvalidXML: " + StationIdUtil.toString((StationId)station.get_id()) + " " + e.getMessage().replace('\n', ' '));
            logger.debug("InvalidXML: " + StationIdUtil.toString((StationId)station.get_id()) + " " + e.getMessage().replace('\n', ' '), (Throwable)e);
            ArrayList<ChannelImpl> arrayList = out;
            return arrayList;
        }
        catch (XMLStreamException e) {
            throw new SodSourceException(e);
        }
        finally {
            if (staxml != null) {
                staxml.closeReader();
            }
        }
    }

    @Override
    public QuantityImpl getSensitivity(ChannelImpl chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        String key = ChannelIdUtil.toString((ChannelId)chan.getId());
        if (!this.chanSensitivityMap.containsKey(key)) {
            this.getChannels(chan.getStationImpl());
        }
        if (!this.chanSensitivityMap.containsKey(key)) {
            throw new ChannelNotFound(chan.getId());
        }
        return this.chanSensitivityMap.get(key);
    }

    /*
     * Loose catch block
     */
    @Override
    public Instrumentation getInstrumentation(ChannelImpl chan) throws SodSourceException, ChannelNotFound, InvalidResponse {
        FDSNStationXML staxml = null;
        try {
            if (chan == null) {
                throw new IllegalArgumentException("Channel is null");
            }
            if (chan.getId() == null) {
                throw new IllegalArgumentException("Channel id is null");
            }
            if (chan.getId().begin_time == null) {
                throw new IllegalArgumentException("Channel begin time is null");
            }
            FDSNStationQueryParams staQP = this.setupQueryParams();
            staQP.setLevel("response");
            staQP.clearNetwork().appendToNetwork(chan.getId().network_id.network_code).clearStation().appendToStation(chan.getId().station_code).clearLocation().appendToLocation(chan.getId().site_code).clearChannel().appendToChannel(chan.getId().channel_code);
            FdsnStation.setTimeParamsToGetSingleChan(staQP, chan.getBeginTime(), chan.getEndTime());
            logger.debug("getInstrumentation " + staQP.formURI());
            staxml = this.internalGetStationXML(staQP);
            NetworkIterator netIt = staxml.getNetworks();
            MicroSecondTimeRange chanTR = new MicroSecondTimeRange(chan.getEffectiveTime());
            while (netIt.hasNext()) {
                Network n = netIt.next();
                NetworkAttrImpl netAttr = StationXMLToFissures.convert((Network)n);
                StationIterator staIt = n.getStations();
                while (staIt.hasNext()) {
                    Station s = staIt.next();
                    StationImpl sImpl = StationXMLToFissures.convert((Station)s, (NetworkAttrImpl)netAttr);
                    for (Channel c : s.getChannelList()) {
                        MicroSecondDate endDate = c.getEndDate() != null ? new MicroSecondDate(c.getEndDate()) : TimeUtils.future;
                        MicroSecondTimeRange cTR = new MicroSecondTimeRange(new MicroSecondDate(c.getStartDate()), endDate);
                        if (cTR.equals((Object)chanTR)) {
                            ChannelSensitivityBundle csb = StationXMLToFissures.convert((Channel)c, (StationImpl)sImpl);
                            this.chanSensitivityMap.put(ChannelIdUtil.toString((ChannelId)csb.getChan().get_id()), csb.getSensitivity());
                            InstrumentationImpl out = StationXMLToFissures.convertInstrumentation((Channel)c);
                            if (staxml != null) {
                                staxml.closeReader();
                                staxml = null;
                            }
                            InstrumentationImpl instrumentationImpl = out;
                            return instrumentationImpl;
                        }
                        logger.info("Instrumentation channel time range not same as channel time range for " + ChannelIdUtil.toStringFormatDates((ChannelId)chan.getId()) + ": " + chanTR + " " + cTR);
                    }
                }
            }
            {
                throw new ChannelNotFound();
            }
            catch (URISyntaxException e) {
                throw new SodSourceException("Problem forming URI", e);
            }
            catch (SeisFileException e) {
                throw new SodSourceException(e);
            }
            catch (XMLValidationException e) {
                logger.warn("InvalidXML: " + ChannelIdUtil.toString((ChannelId)chan.get_id()) + " " + e.getMessage().replace('\n', ' '));
                logger.warn("InvalidXML: " + ChannelIdUtil.toString((ChannelId)chan.get_id()) + " " + e.getMessage().replace('\n', ' '), (Throwable)e);
                throw new InvalidResponse((Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new SodSourceException(e);
            }
        }
        finally {
            if (staxml != null) {
                staxml.closeReader();
            }
        }
    }

    public CoarseAvailableData getAvailableData() {
        return this.availableData;
    }

    FDSNStationQueryParams setupQueryParams() {
        FDSNStationQueryParams cloneQP = this.queryParams.clone();
        if (this.constraints != null) {
            for (String netCode : this.constraints.getConstrainingNetworkCodes()) {
                cloneQP.appendToNetwork(netCode);
            }
            for (String staCode : this.constraints.getConstrainingStationCodes()) {
                cloneQP.appendToStation(staCode);
            }
            for (String siteCode : this.constraints.getConstrainingLocationCodes()) {
                cloneQP.appendToLocation(siteCode);
            }
            for (String chanCode : this.constraints.getConstrainingChannelCodes()) {
                cloneQP.appendToChannel(chanCode);
            }
            if (this.constraints.getConstrainingBeginTime() != null) {
                cloneQP.setEndAfter((Date)this.constraints.getConstrainingBeginTime());
            }
            if (this.constraints.getConstrainingEndTime() != null) {
                cloneQP.setStartBefore((Date)this.constraints.getConstrainingEndTime());
            }
        }
        return cloneQP;
    }

    FDSNStationQuerier setupQuerier(FDSNStationQueryParams queryParams) {
        FDSNStationQuerier querier = new FDSNStationQuerier(queryParams);
        RunProperties runProps = Start.getRunProps();
        if (runProps.getProxyHost() != null) {
            querier.setProxyHost(runProps.getProxyHost());
            querier.setProxyPort(runProps.getProxyPort());
            querier.setProxyScheme(runProps.getProxyScheme());
        }
        if (this.validateXML) {
            querier.setValidate(true);
        }
        querier.setUserAgent("SOD/" + BuildVersion.getVersion());
        return querier;
    }

    FDSNStationXML internalGetStationXML(FDSNStationQueryParams staQP) {
        int count = 0;
        SeisFileException latest = null;
        FDSNStationXML out = null;
        while (count == 0 || this.getRetryStrategy().shouldRetry(latest, (Object)this, count)) {
            try {
                FDSNStationQuerier querier = this.setupQuerier(staQP);
                out = querier.getFDSNStationXML();
                if (count > 0) {
                    this.getRetryStrategy().serverRecovered((Object)this);
                }
                return out;
            }
            catch (SeisFileException e) {
                ++count;
                if (out != null) {
                    out.closeReader();
                    out = null;
                }
                latest = e;
                Throwable rootCause = AbstractFDSNQuerier.extractRootCause((Throwable)e);
                if (rootCause instanceof IOException) continue;
                if (e instanceof FDSNWSException && ((FDSNWSException)((Object)e)).getHttpResponseCode() != 200) {
                    latest = e;
                    if (((FDSNWSException)((Object)e)).getHttpResponseCode() != 400) continue;
                    Start.simpleArmFailure(Start.getNetworkArm(), "The remote web service just indicated that the query was badly formed. This may be because it does not support all of the parameters that SOD uses or it could be a bug in SOD. Check your recipe and if you cannot figure it out contact the developers at sod@seis.sc.edu.  " + ((FDSNWSException)((Object)e)).getMessage() + " on " + ((FDSNWSException)((Object)e)).getTargetURI());
                    continue;
                }
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw new RuntimeException(latest);
    }

    public FDSNStationQueryParams getDefaultQueryParams() {
        return this.queryParams;
    }

    static void setTimeParamsToGetSingleChan(FDSNStationQueryParams staQP, Time startTime, Time endTime) {
        MicroSecondDate end;
        staQP.setStartBefore((Date)new MicroSecondDate(startTime).add(ONE_SECOND));
        MicroSecondDate microSecondDate = end = endTime != null ? new MicroSecondDate(endTime) : TimeUtils.future;
        if (end.before((Date)ClockUtil.now())) {
            staQP.setEndAfter((Date)end.subtract(ONE_SECOND));
        } else {
            staQP.setEndAfter((Date)ClockUtil.now());
        }
    }

    static void setTimeParams(FDSNStationQueryParams staQP, Time startTime, Time endTime, NetworkQueryConstraints constraints) {
        MicroSecondDate earliest = new MicroSecondDate(startTime).add(ONE_SECOND);
        MicroSecondDate latest = null;
        if (endTime != null) {
            latest = new MicroSecondDate(endTime).subtract(ONE_SECOND);
        }
        if (constraints != null) {
            if (earliest == null || constraints.getConstrainingBeginTime() != null && constraints.getConstrainingBeginTime().after((Date)earliest)) {
                earliest = constraints.getConstrainingBeginTime();
            }
            if (latest == null || constraints.getConstrainingEndTime() != null && constraints.getConstrainingEndTime().before((Date)latest)) {
                latest = constraints.getConstrainingEndTime();
            }
        }
        if (earliest == null) {
            staQP.setStartTime((Date)earliest);
            staQP.clearEndAfter().clearStartBefore();
        }
        if (latest != null && latest.before((Date)ClockUtil.now())) {
            staQP.setEndTime((Date)latest);
            staQP.clearEndAfter().clearStartBefore();
        }
    }
}

