/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import org.w3c.dom.Element;

public abstract class AbstractNetworkSource
extends AbstractSource
implements NetworkSource {
    protected NetworkQueryConstraints constraints;
    protected TimeInterval refreshInterval;
    public static final String REFRESH_ELEMENT = "refreshInterval";

    public AbstractNetworkSource(String name, int retries) {
        super(name, retries);
        this.refreshInterval = new TimeInterval(1.0, UnitImpl.FORTNIGHT);
    }

    public AbstractNetworkSource(NetworkSource wrapped) {
        this(wrapped.getName(), wrapped.getRetries());
    }

    public AbstractNetworkSource(Element config) throws ConfigurationException {
        super(config, "default", -1);
        Element subElement = SodUtil.getElement(config, REFRESH_ELEMENT);
        this.refreshInterval = subElement != null ? SodUtil.loadTimeInterval(subElement) : new TimeInterval(1.0, UnitImpl.FORTNIGHT);
    }

    @Override
    public TimeInterval getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
        this.constraints = constraints;
    }
}

