/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.RetryStrategy;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.QueryTime;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.event.EventDCQuerier;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import java.util.Date;
import org.omg.CORBA.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EventFinder
extends AbstractSource
implements EventSource {
    private int eventFinderId;
    private static int eventFinderCount = 0;
    private EventDCQuerier querier;
    private MicroSecondTimeRangeSupplier eventTimeRange;
    private MicroSecondDate sleepUntilTime = null;
    private String dns;
    private static Logger logger = LoggerFactory.getLogger(EventFinder.class);
    protected TimeInterval increment;
    protected TimeInterval lag;
    protected TimeInterval refreshInterval = new TimeInterval(10.0, UnitImpl.MINUTE);
    private RetryStrategy retryStrat = Start.createRetryStrategy(this.getRetries());

    public EventFinder(Element config) throws Exception {
        super(config, "IRIS_EventDC");
        this.processConfig(config);
        if (this.getDNS().equals("edu/iris/dmc")) {
            System.err.println("WARNING: DHI servers will be turned off June 2013, switch to <fdsnEvent>");
        }
        this.eventFinderId = eventFinderCount++;
        this.processConfig(config);
        this.refreshInterval = Start.getRunProps().getEventRefreshInterval();
        this.lag = Start.getRunProps().getEventLag();
        this.increment = Start.getRunProps().getEventQueryIncrement();
    }

    protected void processConfig(Element config) throws ConfigurationException {
        this.dns = SodUtil.loadText(config, "dns", "edu/iris/dmc");
        Element queryTimeEl = DOMHelper.extractElement((Element)config, (String)"originTimeRange");
        if (queryTimeEl == null) {
            queryTimeEl = DOMHelper.extractElement((Element)config, (String)"networkTimeRange");
        }
        this.eventTimeRange = (MicroSecondTimeRangeSupplier)SodUtil.load(queryTimeEl, new String[]{"eventArm", "origin"});
        this.querier = new EventDCQuerier(this.getName(), this.getDNS(), this.getRetries(), config);
    }

    @Override
    public String getDescription() {
        return "EventFinder Source: " + this.getDNS() + " " + this.getUniqueName() + " " + this.eventTimeRange.getMSTR() + " " + this.querier.getMagRange().getMinValue();
    }

    @Override
    public boolean hasNext() {
        MicroSecondDate queryEnd = this.getEventTimeRange().getEndTime();
        MicroSecondDate quitDate = queryEnd.add(this.lag);
        logger.debug(this.getUniqueName() + " Checking if more queries to the event server are in order.  The quit date is " + quitDate + " the last query was for " + this.getQueryStart() + " and we're querying to " + queryEnd);
        return quitDate.equals((Object)ClockUtil.now()) || quitDate.after((Date)ClockUtil.now()) || !this.getQueryStart().equals((Object)queryEnd);
    }

    private CacheEvent[] internalNext() {
        MicroSecondDate now = ClockUtil.now();
        MicroSecondTimeRange queryTime = this.getQueryTime();
        CacheEvent[] results = this.querier.query(queryTime);
        logger.debug("Retrieved" + results.length + " events for time range " + queryTime);
        if (this.caughtUpWithRealtime() && this.hasNext()) {
            this.sleepUntilTime = now.add(this.refreshInterval);
            logger.debug("set sleepUntilTime " + this.sleepUntilTime);
            this.resetQueryTimeForLag();
        }
        this.updateQueryEdge(queryTime);
        return results;
    }

    @Override
    public CacheEvent[] next() {
        SystemException latest;
        int count = 0;
        try {
            return this.internalNext();
        }
        catch (SystemException t) {
            latest = t;
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of memory", e);
        }
        while (this.retryStrat.shouldRetry((Throwable)latest, (Object)this.querier.getEventDC(), count++)) {
            try {
                CacheEvent[] result = this.internalNext();
                this.retryStrat.serverRecovered((Object)this.querier.getEventDC());
                return result;
            }
            catch (SystemException t) {
                latest = t;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw latest;
    }

    protected void updateQueryEdge(MicroSecondTimeRange queryTime) {
        this.setQueryEdge(queryTime.getEndTime());
    }

    @Override
    public TimeInterval getWaitBeforeNext() {
        if (this.sleepUntilTime != null) {
            logger.debug(this.getUniqueName() + " sleeping caught up, " + this.refreshInterval + " " + this.sleepUntilTime);
            return this.sleepUntilTime.subtract(ClockUtil.now());
        }
        return new TimeInterval(0.0, UnitImpl.SECOND);
    }

    protected boolean caughtUpWithRealtime() {
        return ClockUtil.now().subtract(this.refreshInterval).before((Date)this.getQueryStart()) || this.getQueryStart().add(new TimeInterval(10.0, UnitImpl.SECOND)).after((Date)this.getEventTimeRange().getEndTime());
    }

    @Override
    public MicroSecondTimeRange getEventTimeRange() {
        return this.eventTimeRange.getMSTR();
    }

    protected MicroSecondDate getQueryStart() {
        try {
            return this.getQueryEdge();
        }
        catch (NotFound e) {
            logger.debug("the query times database didn't have an entry for our server/dns combo, just use the time in the config file");
            this.setQueryEdge(this.getEventTimeRange().getBeginTime());
            return this.getEventTimeRange().getBeginTime();
        }
    }

    protected MicroSecondTimeRange getQueryTime() {
        MicroSecondDate queryStart = this.getQueryStart();
        MicroSecondDate queryEnd = queryStart.add(this.increment);
        if (this.getEventTimeRange().getEndTime().before((Date)queryEnd)) {
            queryEnd = this.getEventTimeRange().getEndTime();
        }
        if (ClockUtil.now().before((Date)queryEnd)) {
            queryEnd = ClockUtil.now();
        }
        return new MicroSecondTimeRange(queryStart, queryEnd);
    }

    private void resetQueryTimeForLag() {
        MicroSecondDate newEdge = this.getQueryStart().subtract(this.lag);
        if (newEdge.before((Date)this.getEventTimeRange().getBeginTime())) {
            this.setQueryEdge(this.getEventTimeRange().getBeginTime());
        } else {
            this.setQueryEdge(newEdge);
        }
    }

    protected MicroSecondDate getQueryEdge() throws NotFound {
        SodDB sdb = SodDB.getSingleton();
        QueryTime t = sdb.getQueryTime(this.getUniqueName(), this.getDNS());
        SodDB.commit();
        if (t == null) {
            throw new NotFound();
        }
        return new MicroSecondDate(t.getTime());
    }

    protected void setQueryEdge(MicroSecondDate edge) {
        SodDB sdb = SodDB.getSingleton();
        QueryTime qt = sdb.getQueryTime(this.getUniqueName(), this.getDNS());
        if (qt != null) {
            qt.setTime(edge.getTimestamp());
            SodDB.getSession().saveOrUpdate((Object)qt);
        } else {
            sdb.putQueryTime(new QueryTime(this.getUniqueName(), this.getDNS(), edge.getTimestamp()));
        }
        SodDB.commit();
    }

    private String getUniqueName() {
        return this.getName() + this.eventFinderId;
    }

    public String getDNS() {
        return this.dns;
    }
}

