/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventAccessSeqHolder;
import edu.iris.Fissures.IfEvent.EventSeqIter;
import edu.iris.Fissures.IfEvent.EventSeqIterHolder;
import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.GlobalAreaImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyEventDC;
import edu.sc.seis.fissuresUtil.cache.RetryEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.VestingEventDC;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.CommonAccess;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.subsetter.origin.Catalog;
import edu.sc.seis.sod.subsetter.origin.Contributor;
import edu.sc.seis.sod.subsetter.origin.MagnitudeRange;
import edu.sc.seis.sod.subsetter.origin.OriginDepthRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EventDCQuerier {
    private int sequenceMaximum = 100;
    private ProxyEventDC eventDC;
    private String[] catalogs;
    private String[] contributors;
    private QuantityImpl minDepth = new QuantityImpl(-90000.0, (Unit)UnitImpl.KILOMETER);
    private QuantityImpl maxDepth = new QuantityImpl(90000.0, (Unit)UnitImpl.KILOMETER);
    private String serverName;
    private String serverDNS;
    private MagnitudeRange magRange = new MagnitudeRange();
    private Area area = new GlobalAreaImpl();
    private int numRetries;
    private static Logger logger = LoggerFactory.getLogger(EventDCQuerier.class);

    public EventDCQuerier(String serverName, String serverDNS, int numRetries, Element config) throws ConfigurationException {
        this.serverName = serverName;
        this.serverDNS = serverDNS;
        this.numRetries = numRetries;
        NodeList childNodes = config.getChildNodes();
        ArrayList<String> configCatalogs = new ArrayList<String>();
        ArrayList<String> configContributors = new ArrayList<String>();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            String tagName;
            Node node = childNodes.item(counter);
            if (!(node instanceof Element) || (tagName = ((Element)node).getTagName()).equals("name") || tagName.equals("dns") || tagName.equals("retries") || tagName.equals("originTimeRange")) continue;
            Object object = SodUtil.load((Element)node, new String[]{"eventArm", "origin"});
            if (tagName.equals("originDepthRange")) {
                OriginDepthRange dr = (OriginDepthRange)object;
                this.minDepth = dr.getMinDepth();
                this.maxDepth = dr.getMaxDepth();
                continue;
            }
            if (tagName.equals("magnitudeRange")) {
                this.magRange = (MagnitudeRange)object;
                continue;
            }
            if (object instanceof Area) {
                this.area = (Area)object;
                continue;
            }
            if (tagName.equals("catalog")) {
                configCatalogs.add(((Catalog)object).getCatalog());
                continue;
            }
            if (!tagName.equals("contributor")) continue;
            configContributors.add(((Contributor)object).getContributor());
        }
        this.catalogs = configCatalogs.toArray(new String[configCatalogs.size()]);
        this.contributors = configContributors.toArray(new String[configContributors.size()]);
    }

    public ProxyEventDC getEventDC() {
        if (this.eventDC == null) {
            this.eventDC = new VestingEventDC(this.serverName, this.serverDNS, CommonAccess.getNameService(), Start.createRetryStrategy(this.getRetries()));
        }
        return this.eventDC;
    }

    public CacheEvent[] query(MicroSecondTimeRange tr) {
        logger.debug("querying for events from " + tr);
        EventSeqIterHolder holder = new EventSeqIterHolder();
        EventAccessOperations[] events = this.getEvents(tr, holder);
        logger.debug("got " + events.length + " events from query " + tr);
        if (holder.value != null) {
            LinkedList<Object> allEvents = new LinkedList<Object>();
            for (int j = 0; j < events.length; ++j) {
                allEvents.add(events[j]);
            }
            EventSeqIter iterator = holder.value;
            EventAccessSeqHolder eHolder = new EventAccessSeqHolder();
            while (iterator.how_many_remain() > 0) {
                iterator.next_n(this.sequenceMaximum, eHolder);
                EventAccess[] iterEvents = eHolder.value;
                for (int j = 0; j < iterEvents.length; ++j) {
                    allEvents.add(iterEvents[j]);
                }
            }
            events = allEvents.toArray(new EventAccessOperations[0]);
        }
        CacheEvent[] cached = this.cacheEvents(events);
        Arrays.sort(cached, new Comparator(){

            public int compare(Object first, Object second) {
                MicroSecondDate firstOrigin = new MicroSecondDate(((CacheEvent)first).getOrigin().getOriginTime());
                MicroSecondDate secondOrigin = new MicroSecondDate(((CacheEvent)second).getOrigin().getOriginTime());
                return firstOrigin.compareTo((Date)secondOrigin);
            }
        });
        return cached;
    }

    private EventAccessOperations[] getEvents(MicroSecondTimeRange tr, EventSeqIterHolder holder) {
        return this.getEventDC().a_finder().query_events(this.area, (Quantity)this.minDepth, (Quantity)this.maxDepth, tr.getFissuresTimeRange(), this.magRange.getSearchTypes(), (float)this.magRange.getMinValue(), (float)this.magRange.getMaxValue(), this.catalogs, this.contributors, this.sequenceMaximum, holder);
    }

    private CacheEvent[] cacheEvents(EventAccessOperations[] uncached) {
        CacheEvent[] cached = new CacheEvent[uncached.length];
        for (int counter = 0; counter < cached.length; ++counter) {
            cached[counter] = uncached[counter] instanceof CacheEvent ? (CacheEvent)uncached[counter] : new CacheEvent((EventAccessOperations)new RetryEventAccessOperations(uncached[counter], 3));
            cached[counter].get_attributes();
            Origin[] origins = cached[counter].get_origins();
            for (int i = 0; i < origins.length; ++i) {
                EventDCQuerier.putPassingMagFirst(origins[i], this.magRange);
            }
            EventDCQuerier.putPassingMagFirst((Origin)EventUtil.extractOrigin((EventAccessOperations)cached[counter]), this.magRange);
        }
        return cached;
    }

    public static boolean putPassingMagFirst(Origin o, MagnitudeRange magRange) {
        Magnitude[] acceptable = magRange.getAcceptable(o.getMagnitudes());
        if (acceptable.length > 0) {
            Magnitude zeroth = o.getMagnitudes()[0];
            for (int i = 0; i < o.getMagnitudes().length; ++i) {
                if (!o.getMagnitudes()[i].equals(acceptable[0])) continue;
                o.getMagnitudes()[0] = acceptable[0];
                o.getMagnitudes()[i] = zeroth;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "EventDCQuerier(" + this.serverDNS + "/" + this.serverName + ")";
    }

    public int getRetries() {
        return this.numRetries;
    }

    public String[] getCatalogs() {
        return this.catalogs;
    }

    public String[] getContributors() {
        return this.contributors;
    }

    public QuantityImpl getMinDepth() {
        return this.minDepth;
    }

    public QuantityImpl getMaxDepth() {
        return this.maxDepth;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerDNS() {
        return this.serverDNS;
    }

    public MagnitudeRange getMagRange() {
        return this.magRange;
    }

    public Area getArea() {
        return this.area;
    }
}

