/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.QueryTime;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.event.EventSource;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class AbstractEventSource
extends AbstractSource
implements EventSource {
    protected boolean caughtUpToRealtime = false;
    protected boolean everCaughtUpToRealtime = false;
    protected MicroSecondDate lastQueryTime = null;
    public static final String NO_DNS = "NO_DNS";
    protected MicroSecondDate sleepUntilTime = null;
    protected TimeInterval increment;
    protected TimeInterval lag;
    protected TimeInterval refreshInterval = new TimeInterval(10.0, UnitImpl.MINUTE);
    protected TimeInterval nearRealTimeInterval = new TimeInterval(2.0, UnitImpl.MINUTE);
    private static final Logger logger = LoggerFactory.getLogger(AbstractEventSource.class);
    public static final String EVENT_QUERY_INCREMENT = "eventQueryIncrement";
    public static final String EVENT_REFRESH_INTERVAL = "eventRefreshInterval";
    public static final String EVENT_LAG = "eventLag";
    public static final TimeInterval MIN_INCREMENT = new TimeInterval(1.0, UnitImpl.DAY);

    public AbstractEventSource(String name, int retries) {
        super(name, retries);
        this.refreshInterval = Start.getRunProps().getEventRefreshInterval();
        this.lag = Start.getRunProps().getEventLag();
        this.increment = Start.getRunProps().getEventQueryIncrement();
    }

    public AbstractEventSource(Element config, String defaultName) throws ConfigurationException {
        super(config, defaultName, -1);
        this.refreshInterval = DOMHelper.hasElement((Element)config, (String)"refreshInterval") ? SodUtil.loadTimeInterval(SodUtil.getElement(config, "refreshInterval")) : Start.getRunProps().getEventRefreshInterval();
        this.increment = DOMHelper.hasElement((Element)config, (String)EVENT_QUERY_INCREMENT) ? SodUtil.loadTimeInterval(SodUtil.getElement(config, EVENT_QUERY_INCREMENT)) : Start.getRunProps().getEventQueryIncrement();
        this.lag = DOMHelper.hasElement((Element)config, (String)EVENT_LAG) ? SodUtil.loadTimeInterval(SodUtil.getElement(config, EVENT_LAG)) : Start.getRunProps().getEventLag();
    }

    @Override
    public TimeInterval getWaitBeforeNext() {
        TimeInterval sleepTime;
        MicroSecondDate now = ClockUtil.now();
        if (!this.caughtUpWithRealtime()) {
            return new TimeInterval(0.0, UnitImpl.SECOND);
        }
        if (this.lastQueryTime == null) {
            this.lastQueryTime = now.subtract(this.refreshInterval).subtract(this.nearRealTimeInterval);
        }
        if ((sleepTime = now.subtract(this.lastQueryTime).add(this.refreshInterval)).getValue() < 0.0) {
            this.caughtUpToRealtime = false;
        }
        logger.debug("getWaitBeforeNext() lq=" + this.lastQueryTime + " sleep=" + sleepTime.getValue(UnitImpl.SECOND) + "  now=" + now + "  refesh=" + this.refreshInterval.getValue(UnitImpl.SECOND));
        return sleepTime;
    }

    protected boolean caughtUpWithRealtime() {
        return this.caughtUpToRealtime;
    }

    protected boolean isEverCaughtUpToRealtime() {
        return this.everCaughtUpToRealtime;
    }

    protected MicroSecondDate getQueryStart() {
        try {
            return this.getQueryEdge();
        }
        catch (NotFound e) {
            logger.debug("the query times database didn't have an entry for our server/dns combo, just use the time in the config file");
            this.setQueryEdge(this.getEventTimeRange().getBeginTime());
            return this.getEventTimeRange().getBeginTime();
        }
    }

    protected MicroSecondTimeRange getQueryTime() {
        MicroSecondDate now = ClockUtil.now();
        MicroSecondDate queryStart = this.getQueryStart();
        if (this.caughtUpWithRealtime()) {
            queryStart = this.resetQueryTimeForLag();
            this.caughtUpToRealtime = false;
        }
        MicroSecondDate queryEnd = queryStart.add(this.increment);
        if (this.getEventTimeRange().getEndTime().before((Date)queryEnd)) {
            queryEnd = this.getEventTimeRange().getEndTime();
            logger.debug("Caught up with edge of event time range.");
            this.caughtUpToRealtime = true;
            this.everCaughtUpToRealtime = true;
        }
        if (now.before((Date)queryEnd)) {
            logger.info("Caught up with now.");
            queryEnd = now;
            this.caughtUpToRealtime = true;
            this.everCaughtUpToRealtime = true;
        }
        if (queryStart.after((Date)ClockUtil.wayFuture())) {
            throw new RuntimeException("start way in future: qs=" + queryStart + " lag=" + this.getLag() + " end=" + queryEnd);
        }
        if (queryEnd.subtract(queryStart).lessThan((QuantityImpl)new TimeInterval(1.0, UnitImpl.MINUTE))) {
            logger.warn("Query for very short time window: start:" + queryStart + " end:" + queryEnd + " inc:" + this.increment + " now:" + now + "  cuwrt:" + this.caughtUpToRealtime + " ecuwrt:" + this.everCaughtUpToRealtime + "  tot end:" + this.getEventTimeRange().getEndTime());
        }
        return new MicroSecondTimeRange(queryStart, queryEnd);
    }

    public void increaseQueryTimeWidth() {
        this.increment = (TimeInterval)this.increment.multiplyBy(2.0);
    }

    public void decreaseQueryTimeWidth() {
        if (this.getIncrement().greaterThan((QuantityImpl)MIN_INCREMENT)) {
            this.increment = (TimeInterval)this.increment.multiplyBy(0.75);
        }
    }

    protected MicroSecondDate resetQueryTimeForLag() {
        MicroSecondDate newEdge = this.getQueryStart().subtract(this.lag);
        if (newEdge.before((Date)this.getEventTimeRange().getBeginTime())) {
            newEdge = this.getEventTimeRange().getBeginTime();
        }
        return newEdge;
    }

    protected MicroSecondDate getQueryEdge() throws NotFound {
        SodDB sdb = SodDB.getSingleton();
        QueryTime t = sdb.getQueryTime(this.getName(), NO_DNS);
        SodDB.commit();
        if (t == null) {
            throw new NotFound();
        }
        return new MicroSecondDate(t.getTime());
    }

    protected void setQueryEdge(MicroSecondDate edge) {
        this.lastQueryTime = ClockUtil.now();
        SodDB sdb = SodDB.getSingleton();
        QueryTime qt = sdb.getQueryTime(this.getName(), NO_DNS);
        if (qt != null) {
            qt.setTime(edge.getTimestamp());
            SodDB.getSession().saveOrUpdate((Object)qt);
        } else {
            sdb.putQueryTime(new QueryTime(this.getName(), NO_DNS, edge.getTimestamp()));
        }
        SodDB.commit();
    }

    protected void updateQueryEdge(MicroSecondTimeRange queryTime) {
        this.setQueryEdge(queryTime.getEndTime());
    }

    public MicroSecondDate getSleepUntilTime() {
        return this.sleepUntilTime;
    }

    public TimeInterval getLag() {
        return this.lag;
    }

    public TimeInterval getIncrement() {
        return this.increment;
    }

    public void setIncrement(TimeInterval increment) {
        this.increment = increment;
    }

    public void setLag(TimeInterval lag) {
        this.lag = lag;
    }

    public TimeInterval getRefreshInterval() {
        return this.refreshInterval;
    }
}

