/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.ComponentSortedSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.configuration.AmpConfigConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.SeismogramDisplayConfiguration;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSetSeismogram;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.process.waveform.SeismogramImageProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorImageProcess
extends SeismogramImageProcess
implements WaveformVectorProcess {
    private AmpConfigConfiguration globalACConf;
    private SeismogramDisplayConfiguration edc = new SeismogramDisplayConfiguration();
    private SeismogramDisplayConfiguration vdc = new SeismogramDisplayConfiguration();
    private SeismogramDisplayConfiguration ndc = new SeismogramDisplayConfiguration();
    private static final Logger logger = LoggerFactory.getLogger(VectorImageProcess.class);

    public VectorImageProcess(Element el) throws Exception {
        super(el);
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("displayTemplate")) {
                SeismogramDisplayConfiguration.create((Element)((Element)n));
                continue;
            }
            if (n.getNodeName().equals("verticalDisplayConfig")) {
                this.vdc = SeismogramDisplayConfiguration.create((Element)((Element)n));
                continue;
            }
            if (n.getNodeName().equals("eastDisplayConfig")) {
                this.edc = SeismogramDisplayConfiguration.create((Element)((Element)n));
                continue;
            }
            if (n.getNodeName().equals("northDisplayConfig")) {
                this.ndc = SeismogramDisplayConfiguration.create((Element)((Element)n));
                continue;
            }
            if (!n.getNodeName().equals("globalizedAmpConfig")) continue;
            this.globalACConf = AmpConfigConfiguration.create((Element)((Element)n));
        }
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
        DataSetSeismogram[] seis = this.createDataSetSeismograms((EventAccessOperations)event, channelGroup, original, available, seismograms);
        ArrayList<VelocityChannel> chanList = new ArrayList<VelocityChannel>();
        chanList.add(new VelocityChannel(channelGroup.getChannel1()));
        chanList.add(new VelocityChannel(channelGroup.getChannel2()));
        chanList.add(new VelocityChannel(channelGroup.getChannel3()));
        ComponentSortedSeismogramDisplay sd = this.createPopulatedDisplay((EventAccessOperations)event, chanList, seis);
        String picFileName = this.locator.getLocation(event, (Channel)channelGroup.getChannels()[0]);
        this.writeImage((SeismogramDisplay)sd, this.locator.getFileType(), picFileName);
        return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, true));
    }

    private DataSetSeismogram[] createDataSetSeismograms(EventAccessOperations event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms) throws Exception {
        MemoryDataSetSeismogram[] seis = new MemoryDataSetSeismogram[seismograms.length];
        MemoryDataSet dataset = new MemoryDataSet("temp", "Temp Dataset for image creation", "temp", new AuditInfo[0]);
        dataset.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", (Object)event, new AuditInfo[0]);
        for (int i = 0; i < seis.length; ++i) {
            seis[i] = VectorImageProcess.createSeis(seismograms[i], original[i]);
            dataset.addDataSetSeismogram((DataSetSeismogram)seis[i], new AuditInfo[0]);
            dataset.addParameter("edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)channelGroup.getChannels()[i].get_id()), (Object)channelGroup.getChannels()[i], new AuditInfo[0]);
        }
        ArrayList<DataSetSeismogram> seisList = new ArrayList<DataSetSeismogram>();
        String[] dssNames = dataset.getDataSetSeismogramNames();
        for (int i = 0; i < dssNames.length; ++i) {
            seisList.add(dataset.getDataSetSeismogram(dssNames[i]));
        }
        return seisList.toArray(new DataSetSeismogram[0]);
    }

    public ComponentSortedSeismogramDisplay createPopulatedDisplay(EventAccessOperations event, List<VelocityChannel> channels, DataSetSeismogram[] seis) throws Exception {
        MicroSecondTimeRange timeWindow = null;
        if (seis.length > 0) {
            timeWindow = VectorImageProcess.getTimeWindow(this.phaseWindow, seis[0]);
            this.updateTitles(event, (Channel)channels.iterator().next(), timeWindow);
        }
        ComponentSortedSeismogramDisplay sd = new ComponentSortedSeismogramDisplay(false);
        BasicSeismogramDisplay vert = (BasicSeismogramDisplay)this.vdc.createDisplay();
        TimeConfig tc = vert.getTimeConfig();
        sd.setTimeConfig(tc);
        sd.setZ(vert);
        sd.setNorth((BasicSeismogramDisplay)this.ndc.createDisplay());
        sd.setEast((BasicSeismogramDisplay)this.edc.createDisplay());
        this.populateDisplay(sd, event, channels, seis);
        if (timeWindow != null) {
            VectorImageProcess.setTimeWindow(tc, timeWindow, tc.getTime(seis[0]));
        }
        return sd;
    }

    private void populateDisplay(ComponentSortedSeismogramDisplay sd, EventAccessOperations event, List<VelocityChannel> channels, DataSetSeismogram[] seis) throws Exception {
        OriginImpl o = EventUtil.extractOrigin((EventAccessOperations)event);
        List<Arrival> arrivals = this.getArrivals((Channel)channels.iterator().next(), (Origin)o, this.phaseFlagNames);
        AmpConfig globalAC = null;
        if (this.globalACConf != null) {
            globalAC = this.globalACConf.createAmpConfig();
            globalAC.add(seis);
        }
        for (int i = 0; i < seis.length; ++i) {
            sd.add(new DataSetSeismogram[]{seis[i]});
            if (globalAC != null) {
                sd.get(seis[i]).setAmpConfig(globalAC);
            }
            this.addFlags(arrivals, (Origin)o, sd.get(seis[i]), seis[i]);
        }
    }
}

