/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Rotate;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.vector.VectorTrim;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.status.StringTreeBranch;
import edu.sc.seis.sod.status.StringTreeLeaf;
import org.w3c.dom.Element;

public class RotateGCP
implements WaveformVectorProcess,
Threadable {
    private String radialOrientationCode;
    private String transverseOrientationCode;
    private float ninetyDegreeTol = 0.01f;
    private VectorTrim trimmer = new VectorTrim();

    public RotateGCP(Element el) {
        this.radialOrientationCode = DOMHelper.extractText((Element)el, (String)"radialOrientationCode", (String)"R");
        this.transverseOrientationCode = DOMHelper.extractText((Element)el, (String)"transverseOrientationCode", (String)"T");
        this.ninetyDegreeTol = SodUtil.loadFloat(el, "ninetyDegreeTol", this.ninetyDegreeTol);
    }

    @Override
    public WaveformVectorResult accept(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
        int i;
        int i2;
        WaveformVectorResult trimResult = this.trimmer.accept(event, channelGroup, original, available, seismograms, cookieJar);
        if (!trimResult.isSuccess()) {
            return new WaveformVectorResult(false, trimResult.getSeismograms(), new StringTreeBranch((Object)this, false, trimResult.getReason()));
        }
        seismograms = trimResult.getSeismograms();
        ChannelImpl[] horizontal = channelGroup.getHorizontalXY(this.ninetyDegreeTol);
        if (horizontal.length == 0) {
            Orientation o1 = channelGroup.getChannel1().getOrientation();
            Orientation o2 = channelGroup.getChannel2().getOrientation();
            Orientation o3 = channelGroup.getChannel3().getOrientation();
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Channels not rotatable, unable to find horizontals with 90 deg separation: " + o1.azimuth + "/" + o1.dip + " " + o2.azimuth + "/" + o2.dip + " " + o3.azimuth + "/" + o3.dip + " tol=" + this.ninetyDegreeTol));
        }
        if (!Rotate.areRotatable((Orientation)horizontal[0].getOrientation(), (Orientation)horizontal[1].getOrientation(), (float)this.ninetyDegreeTol)) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "horizontal channels not orthogonal with tol=" + this.ninetyDegreeTol + ": xAzimuth=" + horizontal[0].getOrientation().azimuth + " yAzimuth=" + horizontal[1].getOrientation().azimuth));
        }
        int xIndex = -1;
        int yIndex = -1;
        for (i2 = 0; i2 < seismograms.length; ++i2) {
            if (seismograms[i2].length == 0) continue;
            if (ChannelIdUtil.areEqual((ChannelId)seismograms[i2][0].channel_id, (ChannelId)horizontal[0].get_id())) {
                xIndex = i2;
            }
            if (!ChannelIdUtil.areEqual((ChannelId)seismograms[i2][0].channel_id, (ChannelId)horizontal[1].get_id())) continue;
            yIndex = i2;
        }
        if (xIndex == -1 || yIndex == -1) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Can't find seismograms to match horizontal channels: xIndex=" + xIndex + " yIndex=" + yIndex));
        }
        if (seismograms[xIndex].length != seismograms[yIndex].length) {
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, "Seismogram lengths for horizontal channels don't match: " + seismograms[xIndex].length + " != " + seismograms[yIndex].length));
        }
        for (i2 = 0; i2 < seismograms[xIndex].length; ++i2) {
            if (seismograms[xIndex][i2].getNumPoints() == seismograms[yIndex][i2].getNumPoints()) continue;
            return new WaveformVectorResult(seismograms, new StringTreeLeaf(this, false, i2 + " Seismogram num points for horizontal channels don't match: " + seismograms[xIndex][i2].getNumPoints() + " != " + seismograms[yIndex][i2].getNumPoints()));
        }
        Location staLoc = horizontal[0].getSite().getLocation();
        Location eventLoc = EventUtil.extractOrigin((EventAccessOperations)event).getLocation();
        LocalSeismogramImpl[][] out = new LocalSeismogramImpl[seismograms.length][];
        for (i = 0; i < out.length; ++i) {
            out[i] = new LocalSeismogramImpl[seismograms[i].length];
            System.arraycopy(seismograms[i], 0, out[i], 0, out[i].length);
        }
        for (i = 0; i < seismograms[xIndex].length; ++i) {
            LocalSeismogramImpl[] rot = Rotate.rotateGCP((LocalSeismogramImpl)seismograms[xIndex][i], (Orientation)horizontal[0].getOrientation(), (LocalSeismogramImpl)seismograms[yIndex][i], (Orientation)horizontal[1].getOrientation(), (Location)staLoc, (Location)eventLoc, (String)this.transverseOrientationCode, (String)this.radialOrientationCode, (float)this.ninetyDegreeTol);
            out[xIndex][i] = rot[0];
            out[yIndex][i] = rot[1];
        }
        channelGroup.makeTransverseAndRadial(xIndex, yIndex, (EventAccessOperations)event);
        return new WaveformVectorResult(out, new StringTreeLeaf(this, true));
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

