/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ArmListener;
import edu.sc.seis.sod.ChannelGrouper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventArm;
import edu.sc.seis.sod.QueryTime;
import edu.sc.seis.sod.RefreshNetworkArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.source.network.FdsnStation;
import edu.sc.seis.sod.source.network.InstrumentationFromDB;
import edu.sc.seis.sod.source.network.LoadedNetworkSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.RetryNetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.networkArm.NetworkMonitor;
import edu.sc.seis.sod.subsetter.channel.ChannelEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.channel.PassChannel;
import edu.sc.seis.sod.subsetter.network.NetworkEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.network.NetworkSubsetter;
import edu.sc.seis.sod.subsetter.network.PassNetwork;
import edu.sc.seis.sod.subsetter.station.PassStation;
import edu.sc.seis.sod.subsetter.station.StationEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetworkArm
implements Arm {
    public static final String[] PACKAGES = new String[]{"networkArm", "channel", "site", "station", "network"};
    private NetworkSource internalFinder;
    private NetworkSource finder;
    private NetworkSubsetter attrSubsetter = new PassNetwork();
    private NetworkSubsetter netEffectiveSubsetter = new PassNetwork();
    private StationSubsetter stationSubsetter = new PassStation();
    private StationSubsetter staEffectiveSubsetter = new PassStation();
    private List<ChannelSubsetter> chanSubsetters = new ArrayList<ChannelSubsetter>();
    private ChannelSubsetter chanEffectiveSubsetter = new PassChannel();
    private ChannelGrouper channelGrouper;
    private HashSet<String> allStationFailureNets = new HashSet();
    private HashSet<String> allChannelFailureStations = new HashSet();
    private HashSet<String> allChannelGroupFailureStations = new HashSet();
    private List<NetworkMonitor> statusMonitors = new ArrayList<NetworkMonitor>();
    private List<ArmListener> armListeners = new ArrayList<ArmListener>();
    private static Logger logger = LoggerFactory.getLogger(NetworkArm.class);
    private static final Logger failLogger = LoggerFactory.getLogger((String)"Fail.NetworkArm");
    private boolean armFinished = false;
    private boolean initialStartupFinished = false;
    RefreshNetworkArm refresh;
    private QueryTime lastQueryTime = null;
    final Object netGetSync = new Object();
    final Object staGetSync = new Object();
    final Object chanGetSync = new Object();
    public static final String NO_NETWORKS_MSG = "Found no networks.  Make sure the network codes you entered are valid. This can also be caused by asking for a restricted networks without <includeRestricted>true</includeRestricted> in a <fdsnStation> network source.";

    public NetworkArm(Element config) throws ConfigurationException {
        this.channelGrouper = new ChannelGrouper(Start.getRunProps().getChannelGroupingRules());
        this.processConfig(config);
        this.refresh = new RefreshNetworkArm(this);
    }

    @Override
    public void run() {
        try {
            SodDB sodDb = SodDB.getSingleton();
            this.lastQueryTime = sodDb.getQueryTime(this.getInternalNetworkSource().getName(), "");
            if (this.getRefreshInterval().value > 0.0 && Start.getWaveformRecipe() != null) {
                Timer timer = new Timer("Refresh NetworkArm", true);
                long period = (long)this.getInternalNetworkSource().getRefreshInterval().getValue(UnitImpl.MILLISECOND);
                long firstDelay = this.lastQueryTime == null ? 0L : this.lastQueryTime.delayUntilNextRefresh(this.getRefreshInterval());
                logger.debug("Refresh timer startup: period: " + period + "  firstDelay: " + firstDelay + "  last query: " + (this.lastQueryTime == null ? "null" : this.lastQueryTime.getTime()));
                timer.schedule((TimerTask)this.refresh, firstDelay, period);
                if (period == 0L) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.initialStartupFinished = true;
            } else {
                this.initialStartupFinished = true;
                this.refresh.run();
            }
            SodDB.rollback();
        }
        catch (Throwable e) {
            this.armFinished = true;
            Start.armFailure(this, e);
        }
    }

    @Override
    public boolean isActive() {
        return !this.armFinished;
    }

    @Override
    public String getName() {
        return "NetworkArm";
    }

    public NetworkAttrImpl getNetwork(NetworkId network_id) throws NetworkNotFound {
        List<NetworkAttrImpl> netDbs = this.getSuccessfulNetworks();
        MicroSecondDate beginTime = new MicroSecondDate(network_id.begin_time);
        String netCode = network_id.network_code;
        for (NetworkAttrImpl attr : netDbs) {
            if (!netCode.equals(attr.get_code()) || !new MicroSecondTimeRange(attr.getEffectiveTime()).contains(beginTime)) continue;
            return attr;
        }
        throw new NetworkNotFound("No network for id: " + NetworkIdUtil.toString((NetworkId)network_id));
    }

    private void processConfig(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            this.loadConfigElement(SodUtil.load((Element)node, PACKAGES));
        }
        TimeRange timeRange = this.configureEffectiveTimeCheckers();
        NetworkQueryConstraints constraints = new NetworkQueryConstraints(this.attrSubsetter, this.stationSubsetter, this.chanSubsetters, timeRange);
        this.getNetworkSource().setConstraints(constraints);
    }

    private TimeRange configureEffectiveTimeCheckers() {
        EventArm arm = Start.getEventArm();
        if (arm != null && !Start.getRunProps().allowDeadNets()) {
            EventSource[] sources = arm.getSources();
            MicroSecondTimeRange fullTime = sources[0].getEventTimeRange();
            for (int i = 1; i < sources.length; ++i) {
                fullTime = new MicroSecondTimeRange(fullTime, sources[i].getEventTimeRange());
            }
            TimeRange eventQueryTimes = fullTime.getFissuresTimeRange();
            this.netEffectiveSubsetter = new NetworkEffectiveTimeOverlap(eventQueryTimes);
            this.staEffectiveSubsetter = new StationEffectiveTimeOverlap(eventQueryTimes);
            this.chanEffectiveSubsetter = new ChannelEffectiveTimeOverlap(eventQueryTimes);
            return eventQueryTimes;
        }
        logger.debug("No implicit effective time constraint");
        return null;
    }

    private void loadConfigElement(Object sodElement) throws ConfigurationException {
        if (sodElement instanceof NetworkSource) {
            this.internalFinder = new RetryNetworkSource((NetworkSource)sodElement);
            this.finder = new InstrumentationFromDB(this.internalFinder);
        } else if (sodElement instanceof NetworkSubsetter) {
            this.attrSubsetter = (NetworkSubsetter)sodElement;
        } else if (sodElement instanceof StationSubsetter) {
            this.stationSubsetter = (StationSubsetter)sodElement;
        } else if (sodElement instanceof ChannelSubsetter) {
            this.chanSubsetters.add((ChannelSubsetter)sodElement);
        } else {
            throw new ConfigurationException("Unknown configuration object: " + sodElement.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NetworkMonitor monitor) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            this.statusMonitors.add(monitor);
        }
    }

    public TimeInterval getRefreshInterval() {
        return this.getInternalNetworkSource().getRefreshInterval();
    }

    public List<ChannelSubsetter> getChannelSubsetters() {
        return this.chanSubsetters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkAttrImpl> getSuccessfulNetworks() {
        RefreshNetworkArm refreshNetworkArm = this.refresh;
        synchronized (refreshNetworkArm) {
            List<NetworkAttrImpl> cacheNets = this.loadNetworksFromDB();
            while (cacheNets == null && this.lastQueryTime == null && !Start.isArmFailure()) {
                logger.info("Waiting on initial network load");
                this.refresh.notifyAll();
                try {
                    this.refresh.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                cacheNets = this.loadNetworksFromDB();
            }
            return cacheNets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<NetworkAttrImpl> loadNetworksFromDB() {
        Object object = this.netGetSync;
        synchronized (object) {
            List fromDB = this.getNetworkDB().getAllNetworks();
            for (NetworkAttrImpl net : fromDB) {
                this.change(net, Status.get(Stage.NETWORK_SUBSETTER, Standing.SUCCESS));
            }
            return fromDB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<NetworkAttrImpl> getSuccessfulNetworksFromServer() throws SodSourceException {
        Object object = this.netGetSync;
        synchronized (object) {
            this.statusChanged("Getting networks");
            logger.info("Getting networks from server");
            ArrayList<NetworkAttrImpl> successes = new ArrayList<NetworkAttrImpl>();
            List<? extends NetworkAttrImpl> allNets = this.getInternalNetworkSource().getNetworks();
            logger.info("Found " + allNets.size() + " networks");
            int i = 0;
            for (NetworkAttrImpl networkAttrImpl : allNets) {
                block15: {
                    try {
                        if (this.netEffectiveSubsetter.accept(networkAttrImpl).isSuccess()) {
                            StringTree result;
                            try {
                                result = this.attrSubsetter.accept(networkAttrImpl);
                            }
                            catch (Throwable t) {
                                logger.debug("Network subsetter exception: ", t);
                                result = new Fail((Object)this.attrSubsetter, "Exception", t);
                            }
                            if (result.isSuccess()) {
                                NetworkDB ndb = this.getNetworkDB();
                                int dbid = ndb.put(networkAttrImpl);
                                NetworkDB.commit();
                                logger.info("store network: " + NetworkIdUtil.toStringNoDates((NetworkAttr)networkAttrImpl) + " " + networkAttrImpl.getDbid() + " " + dbid);
                                successes.add(networkAttrImpl);
                                this.change(networkAttrImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.SUCCESS));
                            } else {
                                this.change(networkAttrImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                                failLogger.info(NetworkIdUtil.toString((NetworkId)networkAttrImpl.get_id()) + " was rejected. " + result);
                            }
                            break block15;
                        }
                        this.change(networkAttrImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                        failLogger.info(NetworkIdUtil.toString((NetworkId)networkAttrImpl.get_id()) + " was rejected because it wasn't active during the time range of requested events");
                    }
                    catch (Throwable th) {
                        GlobalExceptionHandler.handle((String)("Got an exception while trying getSuccessfulNetworks for the " + i + "th networkAccess (" + (networkAttrImpl == null ? "null" : NetworkIdUtil.toStringNoDates((NetworkAttr)networkAttrImpl))), (Throwable)th);
                    }
                }
                ++i;
            }
            if (this.lastQueryTime == null && allNets.size() == 0) {
                logger.warn(NO_NETWORKS_MSG);
                Start.simpleArmFailure(this, NO_NETWORKS_MSG);
            }
            logger.info(successes.size() + " networks passed");
            this.statusChanged("Waiting for a request");
            RefreshNetworkArm refreshNetworkArm = this.refresh;
            synchronized (refreshNetworkArm) {
                this.refresh.notifyAll();
            }
            return successes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        this.armFinished = true;
        this.lastQueryTime = new QueryTime(this.getInternalNetworkSource().getName(), "", ClockUtil.now().getTimestamp());
        SodDB.getSingleton().putQueryTime(this.lastQueryTime);
        SodDB.commit();
        logger.info("Network arm finished.");
        for (ArmListener listener : this.armListeners) {
            listener.finished(this);
        }
        if (Start.getEventArm() != null && Start.getEventArm().getWaveformArmSync() != null) {
            Object object = Start.getEventArm().getWaveformArmSync();
            synchronized (object) {
                Start.getEventArm().getWaveformArmSync().notifyAll();
            }
        }
    }

    public void add(ArmListener listener) {
        this.armListeners.add(listener);
        if (this.armFinished) {
            listener.finished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StationImpl[] getSuccessfulStations(NetworkAttrImpl net) {
        String netCode = net.get_code();
        logger.debug("getSuccessfulStations: " + net.get_code());
        RefreshNetworkArm refreshNetworkArm = this.refresh;
        synchronized (refreshNetworkArm) {
            while (this.refresh.isNetworkBeingReloaded(net.getDbid())) {
                try {
                    this.refresh.notifyAll();
                    this.refresh.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.allStationFailureNets.contains(NetworkIdUtil.toStringNoDates((NetworkAttr)net))) {
                return new StationImpl[0];
            }
            List sta = this.getNetworkDB().getStationForNet(net);
            if (sta.size() != 0) {
                logger.debug("getSuccessfulStations " + netCode + " - from db " + sta.size());
                return sta.toArray(new StationImpl[0]);
            }
            this.allStationFailureNets.add(NetworkIdUtil.toStringNoDates((NetworkAttr)net));
            return new StationImpl[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StationImpl[] getSuccessfulStationsFromServer(NetworkAttrImpl net) {
        NetworkArm networkArm = this;
        synchronized (networkArm) {
            NetworkAttrImpl netAttr;
            try {
                netAttr = NetworkDB.getSingleton().getNetwork(net.getDbid());
            }
            catch (NotFound e1) {
                throw new RuntimeException("Network not in db yet: " + NetworkIdUtil.toString((NetworkAttr)net));
            }
            this.statusChanged("Getting stations for " + net.getName());
            ArrayList<StationImpl> arrayList = new ArrayList<StationImpl>();
            try {
                List<? extends StationImpl> stations = this.getInternalNetworkSource().getStations(netAttr);
                for (StationImpl stationImpl : stations) {
                    logger.debug("Station in NetworkArm: " + StationIdUtil.toString((Station)stationImpl));
                }
                for (StationImpl stationImpl : stations) {
                    stationImpl.setNetworkAttr((NetworkAttr)netAttr);
                    StringTree effResult = this.staEffectiveSubsetter.accept(stationImpl, this.getNetworkSource());
                    if (effResult.isSuccess()) {
                        StringTree staResult;
                        try {
                            staResult = this.stationSubsetter.accept(stationImpl, this.getNetworkSource());
                        }
                        catch (Throwable t) {
                            logger.debug("Station subsetter exception: ", t);
                            staResult = new Fail((Object)this.stationSubsetter, "Exception", t);
                        }
                        if (staResult.isSuccess()) {
                            int dbid = this.getNetworkDB().put(stationImpl);
                            logger.info("Store " + stationImpl.get_code() + " as " + dbid + " in " + this.getNetworkDB());
                            arrayList.add(stationImpl);
                            this.change((Station)stationImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.SUCCESS));
                            continue;
                        }
                        this.change((Station)stationImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                        failLogger.info(StationIdUtil.toString((StationId)stationImpl.get_id()) + " was rejected: " + staResult);
                        continue;
                    }
                    this.change((Station)stationImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                    failLogger.info(StationIdUtil.toString((StationId)stationImpl.get_id()) + " was rejected because the station was not active during the time range of requested events: " + effResult);
                }
                NetworkDB.commit();
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)("Problem in method getSuccessfulStations for net " + NetworkIdUtil.toString((NetworkId)net.get_id())), (Throwable)e);
                NetworkDB.rollback();
            }
            StationImpl[] rtnValues = new StationImpl[arrayList.size()];
            rtnValues = arrayList.toArray(rtnValues);
            this.statusChanged("Waiting for a request");
            logger.debug("getSuccessfulStations " + NetworkIdUtil.toStringNoDates((NetworkAttr)net) + " - from server " + rtnValues.length);
            if (rtnValues.length == 0) {
                this.allStationFailureNets.add(NetworkIdUtil.toStringNoDates((NetworkAttr)net));
            } else {
                this.allStationFailureNets.remove(NetworkIdUtil.toStringNoDates((NetworkAttr)net));
            }
            return rtnValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelImpl> getSuccessfulChannels(StationImpl station) {
        RefreshNetworkArm refreshNetworkArm = this.refresh;
        synchronized (refreshNetworkArm) {
            while (this.refresh.isNetworkBeingReloaded(((NetworkAttrImpl)station.getNetworkAttr()).getDbid()) || this.refresh.isStationBeingReloaded(station.getDbid())) {
                try {
                    this.refresh.notifyAll();
                    this.refresh.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.allChannelFailureStations.contains(StationIdUtil.toStringNoDates((Station)station))) {
                return new ArrayList<ChannelImpl>(0);
            }
            List sta = this.getNetworkDB().getChannelsForStation(station);
            if (sta.size() != 0) {
                logger.debug("successfulChannels " + station.get_code() + " - from db " + sta.size());
                return sta;
            }
            this.allChannelFailureStations.add(StationIdUtil.toStringNoDates((Station)station));
            return new ArrayList<ChannelImpl>(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ChannelImpl> getSuccessfulChannelsFromServer(StationImpl station, LoadedNetworkSource loadedNetworkSource) {
        NetworkArm networkArm = this;
        synchronized (networkArm) {
            this.statusChanged("Getting channels for " + station);
            ArrayList<ChannelImpl> successes = new ArrayList<ChannelImpl>();
            try {
                List<? extends ChannelImpl> chansAtStation = loadedNetworkSource.getChannels(station);
                Status inProg = Status.get(Stage.NETWORK_SUBSETTER, Standing.IN_PROG);
                boolean needCommit = false;
                StationImpl dbSta = NetworkDB.getSingleton().getStation(station.getDbid());
                for (ChannelImpl channelImpl : chansAtStation) {
                    channelImpl.getSite().setStation((Station)dbSta);
                    this.change((Channel)channelImpl, inProg);
                    StringTree effectiveTimeResult = this.chanEffectiveSubsetter.accept(channelImpl, loadedNetworkSource);
                    NetworkDB.flush();
                    if (effectiveTimeResult.isSuccess()) {
                        NetworkDB.flush();
                        boolean accepted = true;
                        List<ChannelSubsetter> list = this.chanSubsetters;
                        synchronized (list) {
                            for (ChannelSubsetter cur : this.chanSubsetters) {
                                StringTree result;
                                try {
                                    result = cur.accept(channelImpl, loadedNetworkSource);
                                }
                                catch (Throwable t) {
                                    logger.debug("Channel subsetter exception: ", t);
                                    result = new Fail((Object)cur, "Exception", t);
                                }
                                if (result.isSuccess()) continue;
                                this.change((Channel)channelImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                                String resultToString = result.toString();
                                if (result.toString().trim().length() == 0) {
                                    resultToString = cur.getClass().getName();
                                }
                                failLogger.info("Rejected " + ChannelIdUtil.toString((ChannelId)channelImpl.get_id()) + ": " + resultToString);
                                accepted = false;
                                break;
                            }
                        }
                        if (!accepted) continue;
                        this.getNetworkDB().put(channelImpl);
                        logger.debug("Accept " + ChannelIdUtil.toString((ChannelId)channelImpl.get_id()));
                        needCommit = true;
                        successes.add(channelImpl);
                        this.change((Channel)channelImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.SUCCESS));
                        continue;
                    }
                    this.change((Channel)channelImpl, Status.get(Stage.NETWORK_SUBSETTER, Standing.REJECT));
                    failLogger.info(ChannelIdUtil.toString((ChannelId)channelImpl.get_id()) + " was rejected because the channel was not active during the time range of requested events: " + effectiveTimeResult);
                }
                if (needCommit) {
                    NetworkDB.commit();
                }
            }
            catch (Throwable e) {
                GlobalExceptionHandler.handle((String)("Problem in method getSuccessfulChannels for " + StationIdUtil.toString((StationId)station.get_id())), (Throwable)e);
                NetworkDB.rollback();
            }
            this.statusChanged("Waiting for a request");
            if (successes.size() == 0) {
                this.allChannelFailureStations.add(StationIdUtil.toStringNoDates((Station)station));
            } else {
                this.allChannelFailureStations.remove(StationIdUtil.toStringNoDates((Station)station));
            }
            return successes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelGroup> getSuccessfulChannelGroups(StationImpl station) {
        if (!this.refresh.isNetworkBeingReloaded(((NetworkAttrImpl)station.getNetworkAttr()).getDbid()) && this.allChannelGroupFailureStations.contains(StationIdUtil.toStringNoDates((Station)station))) {
            return new ArrayList<ChannelGroup>(0);
        }
        RefreshNetworkArm refreshNetworkArm = this.refresh;
        synchronized (refreshNetworkArm) {
            while (this.refresh.isNetworkBeingReloaded(((NetworkAttrImpl)station.getNetworkAttr()).getDbid()) && this.refresh.isStationBeingReloaded(station.getDbid())) {
                try {
                    this.refresh.notifyAll();
                    this.refresh.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.allChannelGroupFailureStations.contains(StationIdUtil.toStringNoDates((Station)station))) {
                return new ArrayList<ChannelGroup>(0);
            }
            List sta = this.getNetworkDB().getChannelGroupsForStation(station);
            if (sta.size() != 0) {
                logger.debug("successfulChannelGroups " + station.get_code() + " - from db " + sta.size());
                return sta;
            }
            this.allChannelGroupFailureStations.add(StationIdUtil.toStringNoDates((Station)station));
            return new ArrayList<ChannelGroup>(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ChannelGroup> getSuccessfulChannelGroupsFromServer(StationImpl station, LoadedNetworkSource net) {
        NetworkArm networkArm = this;
        synchronized (networkArm) {
            ArrayList<ChannelImpl> failures = new ArrayList<ChannelImpl>();
            List<ChannelGroup> chanGroups = this.channelGrouper.group(this.getSuccessfulChannelsFromServer(station, net), failures);
            for (ChannelGroup cg : chanGroups) {
                this.getNetworkDB().put(cg);
            }
            if (chanGroups.size() != 0) {
                NetworkDB.commit();
                this.allChannelGroupFailureStations.remove(StationIdUtil.toStringNoDates((Station)station));
            } else {
                this.allChannelGroupFailureStations.add(StationIdUtil.toStringNoDates((Station)station));
            }
            for (ChannelImpl failchan : failures) {
                failLogger.info(ChannelIdUtil.toString((ChannelId)failchan.get_id()) + "  Channel not grouped into 3 components.");
            }
            return chanGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statusChanged(String newStatus) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (NetworkMonitor netMon : this.statusMonitors) {
                try {
                    netMon.setArmStatus(newStatus);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle((String)"Problem changing status in NetworkArm", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(Channel chan, Status newStatus) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (NetworkMonitor netMon : this.statusMonitors) {
                try {
                    netMon.change(chan, newStatus);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle((String)"Problem changing channel status in NetworkArm", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(Station sta, Status newStatus) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (NetworkMonitor netMon : this.statusMonitors) {
                try {
                    netMon.change(sta, newStatus);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle((String)"Problem changing station status in NetworkArm", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(NetworkAttrImpl na, Status newStatus) {
        List<NetworkMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (NetworkMonitor netMon : this.statusMonitors) {
                try {
                    netMon.change(na, newStatus);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle((String)"Problem changing network status in NetworkArm", (Throwable)e);
                }
            }
        }
    }

    public NetworkSource getNetworkSource() {
        if (this.finder == null) {
            this.finder = new InstrumentationFromDB(this.getInternalNetworkSource());
        }
        return this.finder;
    }

    protected NetworkSource getInternalNetworkSource() {
        if (this.internalFinder == null) {
            this.internalFinder = new RetryNetworkSource(new FdsnStation());
        }
        return this.internalFinder;
    }

    protected NetworkDB getNetworkDB() {
        return NetworkDB.getSingleton();
    }

    public boolean isBeingRefreshed(NetworkAttrImpl net) {
        return this.refresh.isNetworkBeingReloaded(net.getDbid());
    }

    public boolean isBeingRefreshed(StationImpl sta) {
        return this.refresh.isStationBeingReloaded(sta.getDbid());
    }

    public RefreshNetworkArm getRefresher() {
        return this.refresh;
    }

    public boolean isInitialStartupFinished() {
        return this.initialStartupFinished;
    }

    public ChannelGrouper getChannelGrouper() {
        return this.channelGrouper;
    }
}

