/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.network;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.network.TimeFormatter;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class NetworkIdUtil {
    private static Pattern tempNetPattern = Pattern.compile("[1-9XYZ].?");
    public static final String DOT = ".";

    public static boolean isTemporary(NetworkId id) {
        return NetworkIdUtil.isTemporary(id.network_code);
    }

    public static boolean isTemporary(String code) {
        return tempNetPattern.matcher(code).matches();
    }

    public static boolean areEqual(NetworkId a, NetworkId b) {
        if (!a.network_code.equals(b.network_code)) {
            return false;
        }
        return !NetworkIdUtil.isTemporary(a) || TimeUtils.areEqual(a.begin_time, b.begin_time);
    }

    public static String toString(NetworkAttr net) {
        return NetworkIdUtil.toString(net.get_id());
    }

    public static String toString(NetworkId id) {
        return id.network_code + DOT + new MicroSecondDate((Time)id.begin_time).getFissuresTime().date_time;
    }

    public static NetworkId fromString(String s) {
        StringTokenizer st = new StringTokenizer(s, DOT);
        return new NetworkId(st.nextToken(), new ISOTime(st.nextToken()).getDate().getFissuresTime());
    }

    public static StringTokenizer getTokenizerAfterNetworkId(String s) {
        StringTokenizer st = new StringTokenizer(s, DOT);
        st.nextToken();
        st.nextToken();
        return st;
    }

    public static String toStringFormatDates(NetworkAttr net) {
        return NetworkIdUtil.toStringFormatDates(net.get_id());
    }

    public static String toStringFormatDates(NetworkId id) {
        return id.network_code + DOT + TimeFormatter.format(id.begin_time);
    }

    public static String toStringNoDates(NetworkAttr net) {
        return NetworkIdUtil.toStringNoDates(net.get_id());
    }

    public static String toStringNoDates(NetworkId id) {
        if (id.network_code.startsWith("X") || id.network_code.startsWith("Y") || id.network_code.startsWith("Z")) {
            return id.network_code + NetworkIdUtil.getTwoCharYear(id);
        }
        return id.network_code;
    }

    public static String getTwoCharYear(NetworkId id) {
        return id.begin_time.date_time.substring(2, 4);
    }

    public static String getYear(NetworkId id) {
        return id.begin_time.date_time.substring(0, 4);
    }

    public static int hashCode(NetworkId id) {
        return 57 + NetworkIdUtil.toString(id).hashCode();
    }
}

