/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.client.AbstractClient;
import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFileCompare;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import edu.sc.seis.seisFile.winston.WinstonSCNL;
import edu.sc.seis.seisFile.winston.WinstonUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;

public class PurgeOldData
extends AbstractClient {
    Properties winstonConfig = new Properties();
    SyncFile upstreamSyncfile;
    public static final String YEAR_DAY = "date";
    public static final String DRY_RUN = "dryrun";
    public static final String WINSTON_CONFIG = "winston";
    public static final String SYNCFILE = "syncfile";

    public PurgeOldData(String[] args) throws JSAPException {
        super(args);
        this.winstonConfig.put("winston.driver", "com.mysql.jdbc.Driver");
        this.winstonConfig.put("winston.prefix", "W");
        this.winstonConfig.put("winston.url", "jdbc:mysql://localhost/?user=wwsuser&password=");
    }

    @Override
    protected void addParams() throws JSAPException {
        super.addParams();
        this.add((Parameter)new FlaggedOption(YEAR_DAY, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', YEAR_DAY, "Date, as yyyy-mm-dd."));
        this.add((Parameter)new FlaggedOption(SYNCFILE, (StringParser)FileStringParser.getParser(), null, false, '\u0000', SYNCFILE, "Syncfile from the upstream datacenter."));
        this.add((Parameter)new FlaggedOption(WINSTON_CONFIG, (StringParser)FileStringParser.getParser(), "Winston.config", false, '\u0000', WINSTON_CONFIG, "Winston configuration prop file."));
        this.add((Parameter)new Switch(DRY_RUN, '\u0000', DRY_RUN, "Dry run, find data to delete and then exit"));
    }

    public void purge() throws IOException, SeisFileException, URISyntaxException, SQLException {
        if (this.shouldPrintHelp()) {
            System.out.println(this.getHelp());
            System.exit(0);
        }
        this.upstreamSyncfile = SyncFile.load(this.getResult().getFile(SYNCFILE));
        this.winstonConfig.load(new BufferedReader(new FileReader(this.getResult().getFile(WINSTON_CONFIG))));
        WinstonUtil winston = new WinstonUtil(this.winstonConfig);
        HashMap<String, SyncFile> upstreamMap = this.upstreamSyncfile.splitByChannel();
        for (Map.Entry<String, SyncFile> entry : upstreamMap.entrySet()) {
            System.out.println("Work on " + entry.getKey());
            SyncLine first = entry.getValue().getSyncLines().get(0);
            WinstonSCNL scnl = winston.createWinstonSCNL(first.getSta(), first.getChan(), first.getNet(), first.getLoc());
            Calendar startCal = Calendar.getInstance(QueryParams.UTC);
            startCal.setTime(entry.getValue().getEarliest());
            Calendar endCal = Calendar.getInstance(QueryParams.UTC);
            endCal.setTime(entry.getValue().getLatest());
            System.out.println(scnl + " Calc dates " + startCal.getTime() + "  " + endCal.getTime());
            SyncFile winstonSync = winston.calculateSyncBetweenDates(scnl, startCal.get(1), startCal.get(2) + 1, startCal.get(5), endCal.get(1), endCal.get(2) + 1, endCal.get(5), "Winston");
            SyncFileCompare compare = new SyncFileCompare(entry.getValue(), winstonSync);
            SyncFile notInUpstream = compare.getNotAinB();
            String syncFileBase = entry.getKey() + ".sync";
            if (notInUpstream.size() != 0) {
                notInUpstream.cleanSmallSegments(1.0f).saveToFile("NotUpstream_" + syncFileBase);
                System.out.println("Save to NotUpstream_" + syncFileBase);
            } else {
                System.out.println("No data not already in upstream sync for " + entry.getKey());
            }
            SyncFile inboth = compare.getInAinB();
            inboth.saveToFile("Both_" + syncFileBase);
            System.out.println("in both to Both_" + syncFileBase + "  line=" + inboth.size());
            winstonSync.saveToFile("winston_" + syncFileBase);
            System.out.println("winston_" + syncFileBase + "   lines=" + winstonSync.size());
            entry.getValue().saveToFile("upstream_" + syncFileBase);
        }
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        PurgeOldData purger = new PurgeOldData(args);
        purger.purge();
    }

    String getDbURL() {
        return this.winstonConfig.getProperty("winston.url");
    }

    String getUser() throws URISyntaxException, SeisFileException {
        return WinstonUtil.getUrlQueryParam("user", this.getDbURL());
    }

    String getPassword() throws URISyntaxException, SeisFileException {
        return WinstonUtil.getUrlQueryParam("password", this.getDbURL());
    }
}

