/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.usgsCWB;

import edu.sc.seis.seisFile.MSeedQueryClient;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.usgsCWB.CWBReader;
import java.util.ArrayList;
import java.util.List;

public class Client
extends MSeedQueryClient {
    protected Client(String[] args) throws SeisFileException {
        super(args);
        List<String> unknownArgs = this.params.getUnknownArgs();
        ArrayList<String> reallyUnknownArgs = new ArrayList<String>();
        String host = "cwbpub.cr.usgs.gov";
        int port = 2061;
        int timeoutSec = 120;
        for (int i = 0; i < unknownArgs.size(); ++i) {
            if (i < unknownArgs.size() - 1) {
                if (unknownArgs.get(i).equals("-h")) {
                    host = unknownArgs.get(i + 1);
                    continue;
                }
                if (unknownArgs.get(i).equals("-p")) {
                    port = Integer.parseInt(unknownArgs.get(i + 1));
                    continue;
                }
                if (unknownArgs.get(i).equals("--timeout")) {
                    timeoutSec = Integer.parseInt(unknownArgs.get(i + 1));
                    continue;
                }
                reallyUnknownArgs.add(unknownArgs.get(i));
                continue;
            }
            reallyUnknownArgs.add(unknownArgs.get(i));
        }
        if (reallyUnknownArgs.size() != 0) {
            String s = "";
            for (String a : reallyUnknownArgs) {
                s = s + " " + a;
            }
            System.out.println("Unknown args: " + s);
            System.out.println(this.getHelp());
            System.exit(-1);
        }
        this.reader = new CWBReader(host, port, timeoutSec * 1000);
    }

    public static void main(String[] args) throws Exception {
        Client client = new Client(args);
        client.readData();
    }

    @Override
    public String getHelp() {
        return "java " + Client.class.getName() + " " + QueryParams.getStandardHelpOptions() + "[-h host][-p port][--timeout sec]";
    }
}

