/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.SeisFileRuntimeException;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class SyncFile
implements Iterable<SyncLine> {
    String dccName;
    String dateModified;
    String[] extraHeaders;
    List<SyncLine> syncLines = new ArrayList<SyncLine>();
    private float tolerence = 0.01f;
    public static final float DEFAULT_TOLERENCE = 0.01f;
    public static final String SEPARATOR = "|";

    public static SyncFile load(File f) throws IOException, SeisFileException {
        try {
            InputStreamReader in = f.getName().endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f)))) : new FileReader(f);
            BufferedReader r = new BufferedReader(in);
            return SyncFile.load(r);
        }
        catch (IOException e) {
            throw new IOException("Problem loading from file " + f, e);
        }
    }

    public static SyncFile load(BufferedReader r) throws IOException, SeisFileException {
        String line = r.readLine();
        if (line == null) {
            throw new IOException("empty Sync file.");
        }
        String[] split = line.split("\\|");
        String[] extras = new String[]{};
        if (split.length > 2) {
            extras = new String[split.length - 2];
            System.arraycopy(split, 2, extras, 0, extras.length);
        }
        SyncFile sync = new SyncFile(split[0], split[1], extras);
        while ((line = r.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            sync.addLine(SyncLine.parse(line));
        }
        r.close();
        return sync;
    }

    public SyncFile(String dccName) {
        this(dccName, SyncLine.dateToString(new Date()));
    }

    public SyncFile(String dccName, String dateModified) {
        this(dccName, dateModified, new String[0]);
    }

    public SyncFile(String dccName, String dateModified, String[] extraHeaders) {
        this.dccName = dccName;
        this.dateModified = dateModified;
        this.extraHeaders = extraHeaders;
    }

    public SyncFile(String dccName, String dateModified, String[] extraHeaders, List<SyncLine> lines) {
        this(dccName, dateModified, extraHeaders);
        this.syncLines = lines;
    }

    public HashMap<String, SyncFile> splitByChannel() {
        HashMap<String, SyncFile> out = new HashMap<String, SyncFile>();
        for (SyncLine sline : this) {
            String chan = sline.net + "." + sline.sta + "." + sline.loc + "." + sline.chan;
            if (!out.containsKey(chan)) {
                SyncFile sf = new SyncFile(this.getDccName() + " " + chan);
                out.put(chan, sf);
            }
            out.get(chan).addLine(sline);
        }
        return out;
    }

    public SyncFile concatenate(SyncFile other) {
        SyncLine otherFirst;
        SyncLine last;
        SyncFile out = new SyncFile(this.getDccName());
        out.syncLines.addAll(this.getSyncLines());
        ArrayList<SyncLine> otherLines = new ArrayList<SyncLine>();
        otherLines.addAll(other.getSyncLines());
        if (out.getSyncLines().size() != 0 && other.getSyncLines().size() != 0 && (last = out.getSyncLines().get(this.getSyncLines().size() - 1)).isContiguous(otherFirst = (SyncLine)otherLines.get(0), this.tolerence)) {
            out.getSyncLines().remove(out.getSyncLines().size() - 1);
            last = last.concat(otherFirst);
            out.addLine(last, true);
            otherLines.remove(0);
        }
        out.syncLines.addAll(otherLines);
        return out;
    }

    public SyncFile consolidate() {
        HashMap<String, SyncFile> byChan = this.splitByChannel();
        SyncFile out = new SyncFile(this.getDccName() + " consolidated");
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(byChan.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            SyncFile in = byChan.get(k);
            in.sort();
            SyncLine previous = null;
            for (SyncLine line : in) {
                if (previous == null) {
                    previous = line;
                    continue;
                }
                if (previous.isContiguous(line, this.tolerence)) {
                    previous = previous.concat(line);
                    continue;
                }
                out.addLine(previous);
                previous = line;
            }
            if (previous == null) continue;
            out.addLine(previous);
        }
        return out;
    }

    public SyncFile cleanSmallSegments(float tolerence) {
        SyncFile out = new SyncFile(this.getDccName() + " cleanSmallSegments:" + tolerence);
        for (SyncLine line : this) {
            if (!(line.getWidthSeconds() > tolerence)) continue;
            out.addLine(line);
        }
        return out;
    }

    public void sort() {
        Collections.sort(this.syncLines);
    }

    public void addLine(SyncLine line) {
        this.addLine(line, false);
    }

    public void addLine(SyncLine line, boolean consolidate) {
        SyncLine previous;
        if (consolidate && this.syncLines.size() != 0 && (previous = this.syncLines.get(this.syncLines.size() - 1)).isContiguous(line, this.tolerence)) {
            this.syncLines.remove(this.syncLines.size() - 1);
            line = previous.concat(line);
        }
        this.syncLines.add(line);
    }

    public void saveToFile(String filename) throws IOException {
        this.saveToFile(new File(filename));
    }

    public void saveToFile(File f) throws IOException {
        if (this.syncLines.size() != 0) {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            this.appendToWriter(out, true);
            out.close();
        }
    }

    public void appendToWriter(PrintWriter writer, boolean writeHeader) {
        if (writeHeader) {
            writer.println(this.getHeaderLine());
        }
        for (SyncLine line : this.syncLines) {
            writer.println(line.formatLine());
        }
        writer.flush();
    }

    public String getHeaderLine() {
        String extras = "";
        for (int i = 0; i < this.extraHeaders.length; ++i) {
            extras = extras + SEPARATOR + this.extraHeaders[i];
        }
        return this.dccName + SEPARATOR + this.dateModified + extras;
    }

    public String getDccName() {
        return this.dccName;
    }

    public void setDccName(String dccName) {
        this.dccName = dccName;
    }

    public String getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(String dateModified) {
        this.dateModified = dateModified;
    }

    public String[] getExtraHeaders() {
        return this.extraHeaders;
    }

    public void setExtraHeaders(String[] extraHeaders) {
        this.extraHeaders = extraHeaders;
    }

    public List<SyncLine> getSyncLines() {
        return this.syncLines;
    }

    public boolean isEmpty() {
        return this.getSyncLines().isEmpty();
    }

    public int size() {
        return this.getSyncLines().size();
    }

    public Date getEarliest() {
        List<SyncLine> lines = this.getSyncLines();
        if (lines.size() != 0) {
            SyncLine sLine = lines.get(0);
            return sLine.getStartTime();
        }
        throw new SeisFileRuntimeException("SyncFile is empty");
    }

    public Date getLatest() {
        List<SyncLine> lines = this.getSyncLines();
        if (lines.size() != 0) {
            SyncLine sLine = lines.get(lines.size() - 1);
            return sLine.getEndTime();
        }
        throw new SeisFileRuntimeException("SyncFile is empty");
    }

    @Override
    public Iterator<SyncLine> iterator() {
        return this.getSyncLines().iterator();
    }
}

