/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.iris.dmc.seedcodec.Utility;
import edu.sc.seis.seisFile.gcf.Convert;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;

public class GCFHeader {
    String systemId;
    String streamId;
    int dayNumber;
    int secondsInDay;
    int sps;
    int compression;
    int startOffsetNumerator;
    int num32Records;
    public static final int SIZE = 16;

    public GCFHeader(String systemId, String streamId, int dayNumber, int secondsInDay, int sps, int compression, int startOffsetNumerator, int num32Records) {
        if (compression != 1 && compression != 2 && compression != 4) {
            throw new IllegalArgumentException("Compression of " + compression + " not allowed, must be 1,2,4");
        }
        if (num32Records > 1000) {
            throw new IllegalArgumentException("max num 32 bit record is 1000, but was " + num32Records);
        }
        this.systemId = systemId.toUpperCase();
        this.streamId = streamId.toUpperCase();
        this.dayNumber = dayNumber;
        this.secondsInDay = secondsInDay;
        this.sps = sps;
        this.compression = compression;
        this.startOffsetNumerator = startOffsetNumerator;
        this.num32Records = num32Records;
    }

    public void write(DataOutput out) throws NumberFormatException, IOException {
        out.writeInt(Integer.parseInt(this.getSystemId(), 36));
        out.writeInt(Integer.parseInt(this.getStreamId(), 36));
        int dayPlusBit = (this.getDayNumber() << 1) + (this.getSecondsInDay() >> 16 & 1);
        out.writeShort(dayPlusBit);
        out.writeShort(this.getSecondsInDay() & 0xFFFF);
        out.writeByte(0);
        out.write(this.getSpsByte());
        out.write((this.startOffsetNumerator << 4) + (this.getCompression() & 7));
        out.write(this.getNum32Records());
    }

    public static GCFHeader fromBytes(byte[] data) {
        return new GCFHeader(Integer.toString(Utility.bytesToInt((byte)data[0], (byte)data[1], (byte)data[2], (byte)data[3], (boolean)false), 36), Integer.toString(Utility.bytesToInt((byte)data[4], (byte)data[5], (byte)data[6], (byte)data[7], (boolean)false), 36), Utility.bytesToInt((byte)data[8], (byte)data[9], (boolean)false) >> 1, Utility.bytesToInt((byte)((byte)(data[9] & 1)), (byte)data[10], (byte)data[11], (boolean)false), data[13] & 0xFF, data[14] & 7, data[14] >> 4, data[15] & 0xFF);
    }

    public static GCFHeader read(DataInput in) throws IOException {
        byte[] data = new byte[16];
        in.readFully(data);
        return GCFHeader.fromBytes(data);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public int getDayNumber() {
        return this.dayNumber;
    }

    public int getSecondsInDay() {
        return this.secondsInDay;
    }

    public Date getStartAsDate() {
        return Convert.convertTime(this.getDayNumber(), this.getSecondsInDay(), (float)this.getStartOffsetNumerator() / this.getStartOffsetDenominator()).getTime();
    }

    public Date getLastSampleTime() {
        return new Date(this.getStartAsDate().getTime() + Math.round(((double)this.getNumPoints() - 1.0) / (double)this.getSps() * 1000.0));
    }

    public Date getPredictedNextStartTime() {
        return new Date(this.getStartAsDate().getTime() + Math.round((double)this.getNumPoints() / (double)this.getSps() * 1000.0));
    }

    public int[] getPredictedNextStartDaySec() {
        int day = this.getDayNumber();
        int sec = this.getSecondsInDay() + (int)Math.round((double)this.getNumPoints() / (double)this.getSps());
        if (sec >= 86400) {
            sec -= 86400;
        }
        return new int[]{++day, sec};
    }

    public int getSpsByte() {
        return this.sps;
    }

    public float getSps() {
        switch (this.sps) {
            case 157: {
                return 0.1f;
            }
            case 161: {
                return 0.125f;
            }
            case 162: {
                return 0.2f;
            }
            case 164: {
                return 0.25f;
            }
            case 167: {
                return 0.5f;
            }
            case 171: {
                return 400.0f;
            }
            case 174: {
                return 500.0f;
            }
            case 176: {
                return 1000.0f;
            }
            case 179: {
                return 2000.0f;
            }
            case 181: {
                return 4000.0f;
            }
        }
        return this.sps;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getStartOffsetNumerator() {
        return this.startOffsetNumerator;
    }

    public float getStartOffsetDenominator() {
        switch (this.getSpsByte() & 7) {
            case 171: {
                return 8.0f;
            }
            case 174: {
                return 2.0f;
            }
            case 176: {
                return 4.0f;
            }
            case 179: {
                return 8.0f;
            }
            case 181: {
                return 16.0f;
            }
        }
        return 1.0f;
    }

    public int getNum32Records() {
        return this.num32Records;
    }

    public int getNumPoints() {
        return this.getNum32Records() * this.getCompression();
    }

    public String toString() {
        return "GCFHeader: " + this.systemId + " " + this.streamId + " " + this.dayNumber + " " + this.secondsInDay + " " + this.sps + " " + this.getStartOffsetNumerator() + " " + this.getCompression() + " " + this.num32Records;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.compression;
        result = 31 * result + this.startOffsetNumerator;
        result = 31 * result + this.dayNumber;
        result = 31 * result + this.num32Records;
        result = 31 * result + this.secondsInDay;
        result = 31 * result + this.sps;
        result = 31 * result + (this.streamId == null ? 0 : this.streamId.hashCode());
        result = 31 * result + (this.systemId == null ? 0 : this.systemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GCFHeader other = (GCFHeader)obj;
        if (this.compression != other.compression) {
            return false;
        }
        if (this.startOffsetNumerator != other.startOffsetNumerator) {
            return false;
        }
        if (this.dayNumber != other.dayNumber) {
            return false;
        }
        if (this.num32Records != other.num32Records) {
            return false;
        }
        if (this.secondsInDay != other.secondsInDay) {
            return false;
        }
        if (this.sps != other.sps) {
            return false;
        }
        if (this.streamId == null ? other.streamId != null : !this.streamId.equals(other.streamId)) {
            return false;
        }
        return !(this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId));
    }
}

