/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class GainSensitivity {
    float sensitivityValue;
    float frequency;

    GainSensitivity() {
    }

    public GainSensitivity(float value, float frequency) {
        this.sensitivityValue = value;
        this.frequency = frequency;
    }

    public GainSensitivity(XMLEventReader reader, String tagName) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (this.parseSubElement(elName, reader)) continue;
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    boolean parseSubElement(String elName, XMLEventReader reader) throws StationXMLException, XMLStreamException {
        if (elName.equals("Value")) {
            this.sensitivityValue = StaxUtil.pullFloat(reader, "Value");
            return true;
        }
        if (elName.equals("Frequency")) {
            this.frequency = StaxUtil.pullFloat(reader, "Frequency");
            return true;
        }
        return false;
    }

    public float getSensitivityValue() {
        return this.sensitivityValue;
    }

    public float getFrequency() {
        return this.frequency;
    }
}

