/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class FloatNoUnitType {
    float value;
    Float plusError;
    Float minusError;

    FloatNoUnitType() {
    }

    public FloatNoUnitType(XMLEventReader reader, String tagName) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        this.parseAttributes(startE);
        this.parseValue(reader);
    }

    void parseAttributes(StartElement startE) throws StationXMLException {
        String plusErrorStr = StaxUtil.pullAttributeIfExists(startE, "plusError");
        String minusErrorStr = StaxUtil.pullAttributeIfExists(startE, "minusError");
        if (plusErrorStr != null) {
            this.plusError = Float.valueOf(Float.parseFloat(plusErrorStr));
        }
        if (minusErrorStr != null) {
            this.minusError = Float.valueOf(Float.parseFloat(minusErrorStr));
        }
    }

    void parseValue(XMLEventReader reader) throws StationXMLException, XMLStreamException {
        this.value = Float.parseFloat(StaxUtil.pullContiguousText(reader));
    }

    public FloatNoUnitType(float value, Float plusError, Float minusError) {
        this.value = value;
        this.plusError = plusError;
        this.minusError = minusError;
    }

    public float getValue() {
        return this.value;
    }

    public Float getPlusError() {
        return this.plusError;
    }

    public Float getMinusError() {
        return this.minusError;
    }

    public boolean hasPlusError() {
        return this.plusError != null;
    }

    public boolean hasMinusError() {
        return this.minusError != null;
    }
}

