/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class TimeWindow {
    public static final String ELEMENT_NAME = "timeWindow";
    Float begin;
    Float end;
    String reference;

    public TimeWindow(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("reference")) {
                    this.reference = StaxUtil.pullText(reader, "reference");
                    continue;
                }
                if (elName.equals("begin")) {
                    this.begin = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "begin")));
                    continue;
                }
                if (elName.equals("end")) {
                    this.end = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "end")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public Float getBegin() {
        return this.begin;
    }

    public Float getEnd() {
        return this.end;
    }

    public String getReference() {
        return this.reference;
    }
}

