/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Arrival {
    String publicId;
    String phase;
    float azimuth;
    float distance;
    RealQuantity takeoffAngle;
    float timeResidual;
    float timeCorrection;
    Float horizontalSlownessWeight;
    Float backazimuthWeight;
    Float horizontalSlownessResidual;
    Float backazimuthResidual;
    Float timeWeight;
    String earthModelID;
    String pickID;
    CreationInfo creationInfo;
    List<Comment> commentList = new ArrayList<Comment>();

    public Arrival(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement("arrival", reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("phase")) {
                    this.phase = StaxUtil.pullText(reader, "phase");
                    continue;
                }
                if (elName.equals("azimuth")) {
                    this.azimuth = StaxUtil.pullFloat(reader, "azimuth");
                    continue;
                }
                if (elName.equals("distance")) {
                    this.distance = StaxUtil.pullFloat(reader, "distance");
                    continue;
                }
                if (elName.equals("takeoffAngle")) {
                    this.takeoffAngle = new RealQuantity(reader, "takeoffAngle");
                    continue;
                }
                if (elName.equals("timeResidual")) {
                    this.timeResidual = StaxUtil.pullFloat(reader, "timeResidual");
                    continue;
                }
                if (elName.equals("horizontalSlownessResidual")) {
                    this.horizontalSlownessResidual = Float.valueOf(StaxUtil.pullFloat(reader, "horizontalSlownessResidual"));
                    continue;
                }
                if (elName.equals("backazimuthResidual")) {
                    this.backazimuthResidual = Float.valueOf(StaxUtil.pullFloat(reader, "backazimuthResidual"));
                    continue;
                }
                if (elName.equals("timeWeight")) {
                    this.timeWeight = Float.valueOf(StaxUtil.pullFloat(reader, "timeWeight"));
                    continue;
                }
                if (elName.equals("backazimuthWeight")) {
                    this.backazimuthWeight = Float.valueOf(StaxUtil.pullFloat(reader, "backazimuthWeight"));
                    continue;
                }
                if (elName.equals("horizontalSlownessWeight")) {
                    this.horizontalSlownessWeight = Float.valueOf(StaxUtil.pullFloat(reader, "horizontalSlownessWeight"));
                    continue;
                }
                if (elName.equals("timeCorrection")) {
                    this.timeCorrection = StaxUtil.pullFloat(reader, "timeCorrection");
                    continue;
                }
                if (elName.equals("earthModelID")) {
                    this.earthModelID = StaxUtil.pullText(reader, "earthModelID");
                    continue;
                }
                if (elName.equals("phase")) {
                    this.phase = StaxUtil.pullText(reader, "phase");
                    continue;
                }
                if (elName.equals("pickID")) {
                    this.pickID = StaxUtil.pullText(reader, "pickID");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getPhase() {
        return this.phase;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getTimeResidual() {
        return this.timeResidual;
    }

    public float getTimeCorrection() {
        return this.timeCorrection;
    }

    public String getPickID() {
        return this.pickID;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public RealQuantity getTakeoffAngle() {
        return this.takeoffAngle;
    }

    public Float getHorizontalSlownessWeight() {
        return this.horizontalSlownessWeight;
    }

    public Float getBackazimuthWeight() {
        return this.backazimuthWeight;
    }

    public Float getHorizontalSlownessResidual() {
        return this.horizontalSlownessResidual;
    }

    public Float getBackazimuthResidual() {
        return this.backazimuthResidual;
    }

    public Float getTimeWeight() {
        return this.timeWeight;
    }

    public String getEarthModelID() {
        return this.earthModelID;
    }
}

