/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FDSNStationQuerier
extends AbstractFDSNQuerier {
    FDSNStationQueryParams queryParams;
    private static Logger logger = LoggerFactory.getLogger(FDSNStationQuerier.class);

    public FDSNStationQuerier(FDSNStationQueryParams queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public URL getSchemaURL() {
        return FDSNStationXML.loadSchemaWithAvailability();
    }

    public void validateFDSNStationXML() throws SeisFileException, URISyntaxException {
        this.validateFDSNStationXML(FDSNStationXML.loadSchema());
    }

    public void validateFDSNStationXML(URL schemaURL) throws SeisFileException, URISyntaxException {
        try {
            this.connect();
            if (!this.isError() && !this.isEmpty()) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                XMLStreamReader reader = factory.createXMLStreamReader(this.getConnectionUri().toString(), this.getInputStream());
                FDSNStationQuerier.validate(reader, schemaURL);
            }
        }
        catch (SAXException e) {
            throw new SeisFileException("Unable to validate xml", e);
        }
        catch (XMLStreamException e) {
            throw new SeisFileException("Unable to read xml", e);
        }
        catch (IOException e) {
            throw new SeisFileException("IOException trying to validate", e);
        }
    }

    @Override
    public void outputRaw(OutputStream out) throws IOException, URISyntaxException, FDSNWSException {
        this.connect();
        this.outputRaw(this.getInputStream(), out);
    }

    public FDSNStationXML getFDSNStationXML() throws FDSNWSException {
        try {
            this.connect();
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    try {
                        FDSNStationXML stationxml = new FDSNStationXML(this.getReader());
                        if (!stationxml.checkSchemaVersion()) {
                            logger.warn("XmlSchema of this document does not match this code, results may be incorrect.  XmlSchema (code): 1.1 XmlSchema (doc): " + stationxml.getSchemaVersion());
                        }
                        stationxml.setQuerier(this);
                        stationxml.setResponse(this.response);
                        return stationxml;
                    }
                    catch (XMLStreamException e) {
                        this.handleXmlStreamException(e);
                        throw new RuntimeException("Should not happen");
                    }
                }
                return FDSNStationXML.createEmpty();
            }
            throw new FDSNWSException("Error: " + this.getErrorMessage(), this.getConnectionUri(), this.responseCode);
        }
        catch (URISyntaxException e) {
            throw new FDSNWSException("Error with URL syntax", e);
        }
        catch (SeisFileException e) {
            if (e instanceof FDSNWSException) {
                ((FDSNWSException)e).setTargetURI(this.getConnectionUri());
                throw (FDSNWSException)e;
            }
            throw new FDSNWSException(e.getMessage(), e, this.getConnectionUri());
        }
    }

    @Override
    public URI formURI() throws URISyntaxException {
        return this.queryParams.formURI();
    }
}

