/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.ChannelTimeWindow;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNDataSelectQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSAuthorizationException;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.TimeQueryLog;
import edu.sc.seis.seisFile.mseed.DataRecordIterator;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FDSNDataSelectQuerier
extends AbstractFDSNQuerier {
    String username;
    String password;
    String realm = AuthScope.ANY_REALM;
    List<ChannelTimeWindow> request;
    FDSNDataSelectQueryParams queryParams;
    private static final Logger logger = LoggerFactory.getLogger(FDSNDataSelectQuerier.class);

    public FDSNDataSelectQuerier(FDSNDataSelectQueryParams queryParams) {
        this(queryParams, null);
    }

    @Override
    public URL getSchemaURL() {
        return null;
    }

    public FDSNDataSelectQuerier(FDSNDataSelectQueryParams queryParams, List<ChannelTimeWindow> request) {
        this.queryParams = queryParams;
        this.request = request;
        this.setAcceptHeader("application/vnd.fdsn.mseed");
    }

    public void enableRestrictedData(String username, String password) {
        this.enableRestrictedData(username, password, null);
    }

    public void enableRestrictedData(String username, String password, String realm) {
        this.username = username;
        this.password = password;
        this.realm = realm;
        this.queryParams.setFdsnQueryStyle("queryauth");
    }

    public DataRecordIterator getDataRecordIterator() throws SeisFileException {
        try {
            if (this.request == null) {
                this.connect();
            } else {
                this.connectForPost();
            }
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    BufferedInputStream bif = new BufferedInputStream(this.getInputStream());
                    DataInputStream in = new DataInputStream(bif);
                    DataRecordIterator drIt = new DataRecordIterator(in);
                    drIt.setQuerier(this);
                    return drIt;
                }
                return new DataRecordIterator(new DataInputStream(new ByteArrayInputStream(new byte[0])));
            }
            if (this.responseCode == 401 || this.responseCode == 403) {
                throw new FDSNWSAuthorizationException("Not Authorized for Restricted Data: " + this.getErrorMessage(), this.getConnectionUri(), this.responseCode);
            }
            throw new FDSNWSException("Error: " + this.getErrorMessage(), this.getConnectionUri(), this.responseCode);
        }
        catch (URISyntaxException e) {
            throw new FDSNWSException("Error with URL syntax", e);
        }
        catch (MalformedURLException e) {
            throw new FDSNWSException("Error forming URL", e, this.getConnectionUri());
        }
        catch (IOException e) {
            throw new FDSNWSException("Error with Connection", e, this.getConnectionUri());
        }
    }

    void connectForPost() throws URISyntaxException, MalformedURLException, IOException, FDSNWSException {
        String postQuery = this.queryParams.formPostString(this.request);
        this.connectionUri = new URI(this.queryParams.getScheme(), this.queryParams.getUserInfo(), this.queryParams.getHost(), this.queryParams.getPort(), this.queryParams.getPath(), "", this.queryParams.getFragment());
        logger.info("Post Query: " + this.connectionUri);
        logger.info(postQuery);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.getConnectTimeout()).setConnectionRequestTimeout(this.getConnectTimeout()).setSocketTimeout(this.getReadTimeout()).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
        if (this.username != null && this.username.length() != 0 && this.password != null && this.password.length() != 0) {
            logger.info("Adding user/pass cred to query");
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.username, this.password);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.queryParams.getHost(), this.queryParams.getPort(), this.realm), (Credentials)creds);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        TimeQueryLog.add(this.connectionUri);
        HttpPost request = new HttpPost(this.connectionUri);
        HttpClientContext context = HttpClientContext.create();
        request.setHeader("User-Agent", this.getUserAgent());
        request.setHeader("Accept", this.getAcceptHeader());
        request.setHeader("Accept-Encoding", "gzip, deflate");
        StringEntity entity = new StringEntity(postQuery);
        request.setEntity((HttpEntity)entity);
        this.response = httpClient.execute((HttpUriRequest)request, (HttpContext)context);
        this.processConnection(this.response);
    }

    @Override
    public void outputRaw(OutputStream out) throws MalformedURLException, IOException, FDSNWSException, URISyntaxException {
        if (this.request == null) {
            this.connect();
        } else {
            this.connectForPost();
        }
        this.outputRaw(this.getInputStream(), out);
    }

    @Override
    public URI formURI() throws URISyntaxException {
        return this.queryParams.formURI();
    }
}

