/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd;

import gov.usgs.net.NetTools;
import gov.usgs.util.CurrentTime;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.WWSCommandString;
import gov.usgs.winston.server.cmd.BaseCommand;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class GetSCNLHeliRawCommand
extends BaseCommand {
    public GetSCNLHeliRawCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    public void doCommand(Object info, SocketChannel channel) {
        WWSCommandString cmd = new WWSCommandString((String)info);
        if (!cmd.isLegalSCNLTT(9)) {
            return;
        }
        double et = cmd.getT2(true);
        double st = cmd.getT1(true);
        et = Math.min(et, CurrentTime.getInstance().nowJ2K() - (double)this.wws.getEmbargo());
        HelicorderData heli = null;
        if (st < et) {
            heli = this.data.getHelicorderData(cmd.getWinstonSCNL(), st, et);
        }
        ByteBuffer bb = null;
        if (heli != null && heli.rows() > 0) {
            bb = (ByteBuffer)heli.toBinary().flip();
        }
        boolean compress = cmd.getInt(8) == 1;
        int bytes = this.writeByteBuffer(cmd.getID(), bb, compress, channel);
        this.wws.log(Level.FINER, "GETSCNLHELIRAW, " + bytes + " bytes.", channel);
        this.wws.log(Level.FINER, "GETSCNLHELIRAW: " + cmd.getCommand(), channel);
    }
}

