/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server;

public class WWSCommandString {
    private String command;
    private String[] commandSplits;

    public WWSCommandString(String cmd) {
        this.command = cmd;
        this.commandSplits = this.command.split(" ");
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getCommandSplits() {
        return this.commandSplits;
    }

    public String getString(int i) {
        if (i >= this.commandSplits.length) {
            return null;
        }
        return this.commandSplits[i];
    }

    public int getInt(int i) {
        int result = Integer.MIN_VALUE;
        try {
            result = Integer.parseInt(this.commandSplits[i]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public double getDouble(int i) {
        double result = Double.NaN;
        try {
            result = Double.parseDouble(this.commandSplits[i]);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public String getID() {
        if (this.commandSplits.length < 2) {
            return null;
        }
        return this.commandSplits[1];
    }

    public String getWinstonSCNL() {
        if (this.commandSplits.length < 6) {
            return null;
        }
        String loc = "";
        if (!this.commandSplits[5].equals("--")) {
            loc = "$" + this.commandSplits[5];
        }
        return this.commandSplits[2] + "$" + this.commandSplits[3] + "$" + this.commandSplits[4] + loc;
    }

    public double getT1(boolean scnl) {
        int ofs = 0;
        if (scnl) {
            ofs = 1;
        }
        if (this.commandSplits.length < 6 + ofs) {
            return Double.NaN;
        }
        return this.getDouble(5 + ofs);
    }

    public double getT2(boolean scnl) {
        int ofs = 0;
        if (scnl) {
            ofs = 1;
        }
        if (this.commandSplits.length < 7 + ofs) {
            return Double.NaN;
        }
        return this.getDouble(6 + ofs);
    }

    public int length() {
        return this.commandSplits.length;
    }

    public boolean isLegal(int cnt) {
        return this.commandSplits.length == cnt;
    }

    public boolean isLegalSCNTT(int cnt) {
        if (this.commandSplits.length != cnt) {
            return false;
        }
        return !Double.isNaN(this.getT1(false)) && !Double.isNaN(this.getT2(false));
    }

    public boolean isLegalSCNLTT(int cnt) {
        if (this.commandSplits.length != cnt) {
            return false;
        }
        return !Double.isNaN(this.getT1(true)) && !Double.isNaN(this.getT2(true));
    }

    public String getS() {
        if (this.commandSplits.length <= 2) {
            return null;
        }
        return this.commandSplits[2];
    }

    public String getC() {
        if (this.commandSplits.length <= 3) {
            return null;
        }
        return this.commandSplits[3];
    }

    public String getN() {
        if (this.commandSplits.length <= 4) {
            return null;
        }
        return this.commandSplits[4];
    }

    public String getL() {
        if (this.commandSplits.length <= 5) {
            return null;
        }
        return this.commandSplits[5];
    }

    public String getEarthwormErrorString(int sid, String msg) {
        return this.getID() + " " + sid + " " + this.getS() + " " + this.getC() + " " + this.getN() + " " + this.getL() + " " + msg + "\n";
    }
}

