/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.winston.in.ew.Options;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TraceBufFilter
implements Comparable<TraceBufFilter> {
    protected boolean keepRejects = false;
    protected Level logLevel = Level.FINEST;
    protected boolean accept = true;
    protected int order = 1;

    protected abstract boolean match(TraceBuf var1, Options var2);

    public void configure(ConfigFile cf) {
        if (cf == null) {
            return;
        }
        this.order = Util.stringToInt((String)cf.getString("order"), (int)-1);
        String action = cf.getString("action");
        if (action == null) {
            this.accept = true;
            return;
        }
        if (action.toLowerCase().equals("reject")) {
            this.accept = false;
        }
        int log = Util.stringToInt((String)cf.getString("log"), (int)0);
        switch (log) {
            case 0: {
                this.logLevel = Level.FINEST;
                break;
            }
            case 1: {
                this.logLevel = Level.FINE;
                break;
            }
            case 2: {
                this.logLevel = Level.WARNING;
            }
        }
    }

    public void setKeepRejects(boolean b) {
        this.keepRejects = b;
    }

    public boolean keepRejects() {
        return this.keepRejects;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public boolean isAccept() {
        return this.accept;
    }

    @Override
    public int compareTo(TraceBufFilter other) {
        return this.order - other.order;
    }
}

