/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;

public class Options {
    public double timeThreshold;
    public int bufThreshold;
    public int maxBacklog;
    public boolean rsamEnable;
    public int rsamDelta;
    public int rsamDuration;
    public int maxDays;

    public static Options createOptions(ConfigFile cf, Options defaults) {
        Options threshold = new Options();
        threshold.timeThreshold = Util.stringToDouble((String)cf.getString("timeThreshold"), (double)defaults.timeThreshold);
        threshold.bufThreshold = Util.stringToInt((String)cf.getString("traceBufThreshold"), (int)defaults.bufThreshold);
        threshold.maxBacklog = Util.stringToInt((String)cf.getString("maxBacklog"), (int)defaults.maxBacklog);
        threshold.rsamEnable = Util.stringToBoolean((String)cf.getString("rsam.enable"), (boolean)defaults.rsamEnable);
        threshold.rsamDelta = Util.stringToInt((String)cf.getString("rsam.delta"), (int)defaults.rsamDelta);
        threshold.rsamDuration = Util.stringToInt((String)cf.getString("rsam.duration"), (int)defaults.rsamDuration);
        threshold.maxDays = Util.stringToInt((String)cf.getString("maxDays"), (int)defaults.maxDays);
        return threshold;
    }

    public boolean thresholdExceeded(double time, int size) {
        double dt;
        if (this.timeThreshold != -1.0 && (dt = CurrentTime.getInstance().nowJ2K() - time) > this.timeThreshold) {
            return true;
        }
        return size > this.bufThreshold;
    }

    public String toString() {
        return String.format("timeThreshold=%.1f, traceBufThreshold=%d, maxBacklog=%d, maxDays=%d, rsam.delta=%d, rsam.duration=%d", this.timeThreshold, this.bufThreshold, this.maxBacklog, this.maxDays, this.rsamDelta, this.rsamDuration);
    }
}

