/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.TraceBuf;
import gov.usgs.earthworm.WaveServer;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.Log;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.InputEW;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.in.ew.ImportWS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ImportWSJob {
    private WinstonDatabase winston;
    private WaveServer waveServer;
    private String channel;
    private List<double[]> spans;
    private Logger logger;
    private Menu menu;
    private Channels channels;
    private InputEW input;
    private double chunkSize;
    private int chunkDelay;
    private boolean rsamEnable = true;
    private int rsamDelta = 10;
    private int rsamDuration = 60;
    private boolean quit = false;
    private ImportWS importWS;

    public ImportWSJob(WinstonDatabase w, WaveServer ws, ImportWS is) {
        this.importWS = is;
        this.winston = w;
        this.waveServer = ws;
        this.spans = new ArrayList<double[]>(10);
        this.channels = new Channels(this.winston);
        this.input = new InputEW(this.winston);
        this.menu = this.importWS.getMenu();
        this.logger = Log.getLogger((String)"gov.usgs.winston");
    }

    public void setRSAMParameters(boolean en, int rd, int rl) {
        this.rsamEnable = en;
        this.rsamDelta = rd;
        this.rsamDuration = rl;
    }

    public void setChannel(String c) {
        this.channel = c;
    }

    public String getChannel() {
        return this.channel;
    }

    public void addSpan(double t1, double t2) {
        this.spans.add(new double[]{t1, t2});
    }

    public void setChunkSize(double sec) {
        this.chunkSize = sec;
    }

    public void setChunkDelay(int ms) {
        this.chunkDelay = ms;
    }

    public void quit() {
        this.quit = true;
    }

    private void getData(double[] span) {
        try {
            String[] ss = this.channel.split("\\$");
            String loc = null;
            if (ss.length == 4) {
                loc = ss[3];
            }
            double t1 = span[0];
            double t2 = span[1];
            this.logger.info(String.format("%s: downloading gap: [%s -> %s, %s]", this.channel, Time.toDateString((double)span[0]), Time.toDateString((double)span[1]), Util.timeDifferenceToString((double)(span[1] - span[0]))));
            this.input.setRowParameters((int)this.chunkSize + 65, 60);
            double ct = t1 - this.chunkSize;
            List tbs = null;
            CodeTimer timer = new CodeTimer("chunk");
            int total = 0;
            double totalInsTime = 0.0;
            double totalDlTime = 0.0;
            while (ct < t2 && !this.quit) {
                double ret = Math.min((ct += this.chunkSize) + this.chunkSize + 5.0, t2 + 5.0);
                CodeTimer netTimer = new CodeTimer("net");
                tbs = this.waveServer.getTraceBufs(ss[0], ss[1], ss[2], loc, Util.j2KToEW((double)(ct - 5.0)), Util.j2KToEW((double)ret));
                netTimer.stop(false);
                totalDlTime += netTimer.getTotalTimeMillis();
                if (tbs == null || tbs.size() <= 0) continue;
                Iterator it = tbs.iterator();
                double minTime = 1.0E300;
                double maxTime = -1.0E300;
                while (it.hasNext()) {
                    TraceBuf tb = (TraceBuf)it.next();
                    minTime = Math.min(tb.getStartTimeJ2K(), minTime);
                    maxTime = Math.max(tb.getEndTimeJ2K(), maxTime);
                    if (tb.getEndTimeJ2K() < t1 || tb.getStartTimeJ2K() > t2) {
                        it.remove();
                        continue;
                    }
                    if (tb.getStartTimeJ2K() - t1 < -1.0E-4 || tb.getEndTimeJ2K() - t2 > 1.0E-4) {
                        it.remove();
                        this.logger.finest(String.format("Overlapping TraceBuf skipped.", tb.getStartTimeJ2K() - t1, tb.getEndTimeJ2K() - t2));
                        continue;
                    }
                    tb.createBytes();
                }
                if (tbs.size() == 0) continue;
                try {
                    if (this.chunkDelay > 0) {
                        this.logger.finest(String.format("%s: delaying for %dms...", this.channel, this.chunkDelay));
                        Thread.sleep(this.chunkDelay);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CodeTimer inputTimer = new CodeTimer("input");
                List<InputEW.InputResult> results = this.input.inputTraceBufs(tbs, this.rsamEnable, this.rsamDelta, this.rsamDuration);
                inputTimer.stop(false);
                totalInsTime += inputTimer.getTotalTimeMillis();
                this.logger.fine(String.format("%s: %d tb (%.0f/%.0fms), [%s -> %s, %s]", this.channel, tbs.size(), netTimer.getRunTimeMillis(), inputTimer.getRunTimeMillis(), Time.toDateString((double)minTime), Time.toDateString((double)maxTime), Util.timeDifferenceToString((double)(maxTime - minTime))));
                if (results.size() == 1) {
                    InputEW.InputResult result = results.get(0);
                    this.logger.warning("Error: " + (Object)((Object)result.code));
                    continue;
                }
                block15: for (int i = 0; i < results.size() - 2; ++i) {
                    InputEW.InputResult result = results.get(i);
                    TraceBuf tb = result.traceBuf;
                    switch (result.code) {
                        case SUCCESS_CREATED_TABLE: {
                            this.logger.fine(String.format("%s: day table created (%s)", this.channel, Time.format((String)"yyyy-MM-dd", (double)(tb.getEndTimeJ2K() + 1.0))));
                        }
                        case SUCCESS: {
                            ++total;
                            this.logger.finest("Insert: " + tb.toLogString());
                            continue block15;
                        }
                        case ERROR_DATABASE: {
                            this.logger.warning("Database error: " + tb.toLogString());
                            continue block15;
                        }
                        case ERROR_UNKNOWN: {
                            this.logger.warning("Unknown insert error: " + tb.toLogString());
                            continue block15;
                        }
                        case ERROR_CHANNEL: 
                        case ERROR_NULL_TRACEBUF: {
                            this.logger.warning("Bad channel/null TraceBuf.");
                            continue block15;
                        }
                        case ERROR_DUPLICATE: {
                            this.logger.finer("Duplicate TraceBuf: " + tb.toLogString());
                            continue block15;
                        }
                        case NO_CODE: {
                            this.logger.warning("No error/success code: " + tb.toLogString());
                        }
                    }
                }
            }
            timer.stop(false);
            this.importWS.addStats(total, totalDlTime, totalInsTime);
            this.logger.info(String.format("%s: gap %s, %d tbs inserted in %.3fms (%.3fms/tb)", this.channel, this.quit ? "interrupted" : "finished", total, timer.getTotalTimeMillis(), total == 0 ? 0.0 : timer.getTotalTimeMillis() / (double)total));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void getAllData() {
        for (double[] span : this.spans) {
            if (this.quit) continue;
            this.getData(span);
        }
    }

    public double getSpansDuration() {
        double duration = 0.0;
        for (double[] span : this.spans) {
            duration += span[1] - span[0];
        }
        return duration;
    }

    public void go() {
        for (double[] span : this.spans) {
            this.logger.fine(String.format("%s: gap: [%s -> %s, %s]", this.channel, Time.toDateString((double)span[0]), Time.toDateString((double)span[1]), Util.timeDifferenceToString((double)(span[1] - span[0]))));
        }
        this.logger.info(String.format("%s: starting job, total gaps: %d for a total duration of %s, Chunk: %.1fs, Delay: %dms", this.channel, this.spans.size(), Util.timeDifferenceToString((double)this.getSpansDuration()), this.chunkSize, this.chunkDelay));
        if (!this.menu.channelExists(this.channel)) {
            this.logger.severe("Channel does not exist on source WaveServer.");
            return;
        }
        if (!this.channels.channelExists(this.channel)) {
            this.logger.info("Creating new channel '" + this.channel + "' in Winston database.");
            this.channels.createChannel(this.channel);
        }
        this.waveServer.connect();
        this.getAllData();
        this.waveServer.close();
        this.spans.clear();
    }
}

