/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in;

import gov.usgs.earthworm.SCN;
import gov.usgs.earthworm.WaveServer;
import gov.usgs.util.ConfigFile;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.in.WaveServerCollector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class WaveServerToWinston {
    private String dbDriver;
    private String dbURL;
    private String dbPrefix;
    private HashMap<String, WaveServerCollector> waveCollectors;
    private HashMap<String, String> waveServers;
    private int mode;

    public WaveServerToWinston(int m) {
        this.mode = m;
        if (!this.processConfigFile()) {
            System.err.println("Could not read 'WaveServerToWinston.config'.");
            System.exit(1);
        }
    }

    public boolean processConfigFile() {
        try {
            this.waveServers = new HashMap();
            this.waveCollectors = new HashMap();
            ConfigFile config = new ConfigFile("WaveServerToWinston.config");
            this.dbDriver = config.getString("winston.driver");
            this.dbURL = config.getString("winston.url");
            this.dbPrefix = config.getString("winston.prefix");
            List wss = config.getList("waveserver");
            for (String ws : wss) {
                String[] wsi = ws.split(";");
                String n = wsi[0];
                String h = wsi[1];
                int p = Integer.parseInt(wsi[2]);
                this.waveServers.put(n, h + ":" + p);
            }
            List wcs = config.getList("collector");
            Iterator it = wcs.iterator();
            int delay = 0;
            while (it.hasNext()) {
                String col = (String)it.next();
                String[] coli = col.split(";");
                String n = coli[0];
                String wsn = coli[1];
                int interval = Integer.parseInt(coli[2]);
                int max = Integer.parseInt(coli[3]);
                String wshp = this.waveServers.get(wsn);
                WaveServer ws = new WaveServer(wshp);
                WinstonDatabase w = new WinstonDatabase(this.dbDriver, this.dbURL, this.dbPrefix);
                WaveServerCollector wc = new WaveServerCollector(n, w, ws, interval, max, delay++, this.mode);
                this.waveCollectors.put(n, wc);
            }
            List scns = config.getList("scn");
            for (String scn : scns) {
                String[] scni = scn.split(";");
                String wcn = scni[0];
                String s = scni[1];
                String c = scni[2];
                String n = scni[3];
                WaveServerCollector wc = this.waveCollectors.get(wcn);
                wc.addStation(new SCN(s, c, n));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error reading WaveServerToWinston.config");
            return false;
        }
    }

    public void startCollecting() {
        Iterator<String> it = this.waveCollectors.keySet().iterator();
        while (it.hasNext()) {
            this.waveCollectors.get(it.next()).startCollecting();
        }
    }

    public static void outputInstructions() {
        System.err.println("Usage:");
        System.err.println("java gov.usgs.winston.in.WaveServerToWinston [-collect|-fill]");
        System.err.println();
        System.err.println("-collect runs in collection mode");
        System.err.println("-fill runs in gap filling mode");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            WaveServerToWinston.outputInstructions();
            System.exit(1);
        }
        int mode = -1;
        if (args[0].equals("-fill")) {
            mode = 2;
        }
        if (args[0].equals("-collect")) {
            mode = 1;
        }
        if (mode == -1) {
            WaveServerToWinston.outputInstructions();
            System.exit(1);
        }
        WaveServerToWinston w = new WaveServerToWinston(mode);
        w.startCollecting();
    }
}

