/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in;

import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.MenuItem;
import gov.usgs.earthworm.SCN;
import gov.usgs.earthworm.TraceBuf;
import gov.usgs.earthworm.WaveServer;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.Input;
import gov.usgs.winston.db.WinstonDatabase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WaveServerCollector
extends Thread {
    public static final int COLLECT = 1;
    public static final int FILL_GAPS = 2;
    private int mode;
    private WinstonDatabase winston;
    private Channels winstonStations;
    private Input input;
    private Data data;
    private int interval;
    private int maxSize;
    private int delay;
    private List<SCN> channels;
    private String name;
    private WaveServer waveServer;

    public WaveServerCollector(String n, WinstonDatabase w, WaveServer ws, int i, int m, int d, int md) {
        this.name = n;
        this.winston = w;
        this.input = new Input(this.winston);
        this.winstonStations = new Channels(this.winston);
        this.data = new Data(this.winston);
        this.interval = i;
        this.maxSize = m;
        this.delay = d;
        this.mode = md;
        this.waveServer = ws;
        this.channels = new ArrayList<SCN>();
    }

    public void startCollecting() {
        this.start();
    }

    public void stopCollecting() {
    }

    public void addStation(SCN ci) {
        this.channels.add(ci);
    }

    public void fillGap(SCN scn, double t1, double t2) {
        double ct = t1;
        this.waveServer.connect();
        while (ct < t2) {
            long ts = System.currentTimeMillis();
            List tbs = null;
            if (t2 - ct > (double)this.maxSize) {
                tbs = this.waveServer.getTraceBufs(scn.station, scn.channel, scn.network, Util.j2KToEW((double)(ct - 5.0)), Util.j2KToEW((double)(ct + (double)this.maxSize + 5.0)));
                ct += (double)this.maxSize;
            } else {
                tbs = this.waveServer.getTraceBufs(scn.station, scn.channel, scn.network, Util.j2KToEW((double)(ct - 5.0)), Util.j2KToEW((double)(t2 + 5.0)));
                ct = t2;
            }
            if (tbs != null && tbs.size() > 0) {
                for (Object o : tbs) {
                    TraceBuf tb = (TraceBuf)o;
                    tb.createBytes();
                    this.input.inputTraceBuf(tb, false);
                }
            }
            long te = System.currentTimeMillis();
            System.out.println("Chunk: " + (double)(te - ts) / 1000.0 + "s");
        }
        this.waveServer.close();
    }

    public void fillGaps() {
        Menu menu = this.waveServer.getMenu();
        for (SCN scn : this.channels) {
            String code = scn.toString().replace('_', '$');
            System.out.println("[" + this.name + "/" + code + "]: ");
            double now = CurrentTime.getInstance().nowEW();
            MenuItem mi = menu.getItem(scn);
            if (mi == null) continue;
            List<double[]> gaps = this.data.findGaps(code, Util.ewToJ2K((double)mi.getStartTime()), now);
            double[] span = this.data.getTimeSpan(code);
            double fdt = span[0];
            if (fdt > Util.ewToJ2K((double)mi.getStartTime())) {
                gaps.add(new double[]{Util.ewToJ2K((double)mi.getStartTime()), fdt});
            }
            if (gaps == null) continue;
            for (double[] gap : gaps) {
                System.out.println(gap[1] - gap[0] + "s, " + gap[0] + " -> " + gap[1]);
                this.fillGap(scn, gap[0] - 5.0, gap[1] + 5.0);
            }
        }
    }

    public void collect() {
        Iterator<SCN> it = this.channels.iterator();
        while (it.hasNext()) {
            List tbs;
            long ts = System.currentTimeMillis();
            SCN scn = it.next();
            String code = scn.toString().replace('_', '$');
            System.out.print("[" + this.name + "/" + code + "]: ");
            boolean stationOk = true;
            if (!this.winstonStations.channelExists(code)) {
                System.out.print("creating new station in Winston; ");
                stationOk = this.winstonStations.createChannel(code);
            }
            if (!stationOk) continue;
            double[] span = this.data.getTimeSpan(code);
            double now = CurrentTime.getInstance().nowEW();
            double last = Util.j2KToEW((double)span[1]);
            if (last == -1.0E300) {
                last = now - 600.0;
            }
            if ((tbs = this.waveServer.getTraceBufs(scn.station, scn.channel, scn.network, last, now)) == null || tbs.size() == 0) {
                System.out.print("wave server returned no data; ");
            } else {
                for (Object o : tbs) {
                    TraceBuf tb = (TraceBuf)o;
                    tb.createBytes();
                    this.input.inputTraceBuf(tb, false);
                }
            }
            long te = System.currentTimeMillis();
            System.out.println("done. " + (double)(te - ts) / 1000.0 + "s");
        }
    }

    public void run() {
        try {
            Thread.sleep(this.delay * 1000);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.mode == 1) {
            while (true) {
                try {
                    while (true) {
                        this.collect();
                        Thread.sleep(this.interval * 1000);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        this.fillGaps();
    }
}

