/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in;

import gov.usgs.earthworm.ImportGeneric;
import gov.usgs.earthworm.Message;
import gov.usgs.earthworm.MessageListener;
import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.winston.db.Admin;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Input;
import gov.usgs.winston.db.WinstonDatabase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class OLD_ImportEW {
    private static final String DEFAULT_CONFIG_FILENAME = "ImportEW.config";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 16022;
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 30000;
    private static final int DEFAULT_EXPECTED_HEARTBEAT_INTERVAL = 30000;
    private static final int DEFAULT_STATUS_INTERVAL = 60;
    private static final String DEFAULT_RECEIVE_ID = "MSG_FROM_EXPORT";
    private static final String DEFAULT_SEND_ID = "MSG_TO_EXPORT";
    private static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    private static final int DEFAULT_MAX_DAYS = 0;
    private static final int DEFAULT_MAX_BACKLOG = 128;
    private static final String DEFAULT_LOG_FILE = "ImportEW.log";
    private static final int DEFAULT_LOG_NUM_FILES = 10;
    private static final int DEFAULT_LOG_FILE_SIZE = 1000000;
    private String configFilename;
    private ConfigFile config;
    private WinstonDatabase winston;
    private Channels channels;
    private Input input;
    private ImportGeneric importGeneric;
    private Set<String> existingChannels;
    private Set<String> channelsFilter;
    private Map<String, ConcurrentLinkedQueue<TraceBuf>> channelTraceBufs;
    private int maxDays = 0;
    private int maxBacklog = 128;
    private Logger logger;
    private String logFile;
    private int logNumFiles;
    private int logSize;
    private ExecutorService fixer;
    private WinstonDatabase fixerWinston;
    private Admin fixerAdmin;
    private Input fixerInput;
    private Set<String> underRepair;
    private CodeTimer inputTimer;
    private int numInput = 0;
    private int totalTraceBufs;
    private int totalMessages;
    private Map<String, ImportChannelStatus> channelStatus;
    private Date importStartTime;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int statusInterval = 60000;
    private UI ui;
    private boolean quit = false;

    public OLD_ImportEW() {
        this(DEFAULT_CONFIG_FILENAME);
    }

    public OLD_ImportEW(String fn) {
        this.importStartTime = CurrentTime.getInstance().nowDate();
        this.channelStatus = new HashMap<String, ImportChannelStatus>();
        this.inputTimer = new CodeTimer("inputTimer", false);
        this.channelTraceBufs = new ConcurrentHashMap<String, ConcurrentLinkedQueue<TraceBuf>>(200, 0.75f, 1);
        this.fixer = Executors.newSingleThreadExecutor();
        this.underRepair = Collections.synchronizedSet(new HashSet());
        this.existingChannels = Collections.synchronizedSet(new HashSet());
        this.configFilename = fn == null ? DEFAULT_CONFIG_FILENAME : fn;
        this.logger = Log.getLogger((String)"gov.usgs.winston");
        this.logger.setLevel(Level.FINE);
        this.processConfigFile();
    }

    public void fatalError(String msg) {
        this.logger.severe(msg);
        System.exit(1);
    }

    public void processConfigFile() {
        String[] version;
        this.config = new ConfigFile(this.configFilename);
        this.importGeneric = new ImportGeneric();
        this.importGeneric.setLogger(this.logger);
        this.logFile = Util.stringToString((String)this.config.getString("import.log.name"), (String)DEFAULT_LOG_FILE);
        this.logNumFiles = Util.stringToInt((String)this.config.getString("import.log.numFiles"), (int)10);
        this.logSize = Util.stringToInt((String)this.config.getString("import.log.maxSize"), (int)1000000);
        if (this.logNumFiles > 0) {
            Log.attachFileLogger((Logger)this.logger, (String)this.logFile, (int)this.logSize, (int)this.logNumFiles, (boolean)true);
        }
        if ((version = Util.getVersion((String)"gov.usgs.winston")) != null) {
            this.logger.info("Version: " + version[0] + " Built: " + version[1]);
        } else {
            this.logger.info("No version information available.");
        }
        this.logger.info("config: import.log.name=" + this.logFile);
        this.logger.info("config: import.log.numFiles=" + this.logNumFiles);
        this.logger.info("config: import.log.maxSize=" + this.logSize);
        String host = Util.stringToString((String)this.config.getString("import.host"), (String)DEFAULT_HOST);
        int port = Util.stringToInt((String)this.config.getString("import.port"), (int)16022);
        this.logger.info("config: import.host=" + host);
        this.logger.info("config: import.port=" + port);
        this.importGeneric.setHostAndPort(host, port);
        String recvID = Util.stringToString((String)this.config.getString("import.receiveID"), (String)DEFAULT_RECEIVE_ID);
        this.importGeneric.setRecvIDString(recvID);
        this.logger.info("config: import.receiveID=" + recvID);
        String sendID = Util.stringToString((String)this.config.getString("import.sendID"), (String)DEFAULT_SEND_ID);
        this.importGeneric.setSendIDString(sendID);
        this.logger.info("config: import.sendID=" + sendID);
        int hbInt = Util.stringToInt((String)this.config.getString("import.heartbeatInterval"), (int)30000);
        this.importGeneric.setHeartbeatInterval(hbInt);
        this.logger.info("config: import.heartbeatInterval=" + hbInt);
        int ehbInt = Util.stringToInt((String)this.config.getString("import.expectedHeartbeatInterval"), (int)30000);
        this.importGeneric.setExpectedHeartbeatInterval(ehbInt);
        this.logger.info("config: import.expectedHeartbeatInterval=" + ehbInt);
        int to = Util.stringToInt((String)this.config.getString("import.timeout"), (int)2000);
        this.importGeneric.setTimeout(to);
        this.logger.info("config: import.timeout=" + to);
        int si = Util.stringToInt((String)this.config.getString("import.statusInterval"), (int)60);
        this.statusInterval = si * 1000;
        this.logger.info("config: import.statusInterval=" + this.statusInterval);
        this.maxBacklog = Util.stringToInt((String)this.config.getString("import.maxBacklog"), (int)128);
        this.logger.info("config: import.maxBacklog=" + this.maxBacklog);
        String winstonDriver = Util.stringToString((String)this.config.getString("winston.driver"), (String)DEFAULT_DRIVER);
        this.logger.info("config: winston.driver=" + winstonDriver);
        String winstonPrefix = this.config.getString("winston.prefix");
        if (winstonPrefix == null) {
            this.fatalError("winston.prefix is missing from config file.");
        }
        this.logger.info("config: winston.prefix=" + winstonPrefix);
        String winstonURL = this.config.getString("winston.url");
        if (winstonURL == null) {
            this.fatalError("winston.url is missing from config file.");
        }
        this.logger.info("config: winston.url=" + winstonURL);
        this.maxDays = Util.stringToInt((String)this.config.getString("winston.maxDays"), (int)0);
        this.logger.info("config: winston.maxDays=" + this.maxDays);
        this.winston = new WinstonDatabase(winstonDriver, winstonURL, winstonPrefix);
        if (!this.winston.checkDatabase()) {
            this.fatalError("Winston database does not exist.");
        }
        this.fixerWinston = new WinstonDatabase(winstonDriver, winstonURL, winstonPrefix);
        this.fixerInput = new Input(this.fixerWinston);
        this.fixerAdmin = new Admin(this.fixerWinston);
        this.channels = new Channels(this.winston);
        this.input = new Input(this.winston);
        this.channelsFilter = new HashSet<String>();
        List channelList = this.config.getList("scn");
        for (String scn : channelList) {
            scn = scn.replace(' ', '$');
            this.channelsFilter.add(scn);
        }
        MessageHandler messageHandler = new MessageHandler();
        messageHandler.start();
        TraceBufHandler tbh = new TraceBufHandler();
        this.importGeneric.addListener(20, (MessageListener)tbh);
        this.importGeneric.addListener(19, (MessageListener)tbh);
    }

    public void go() {
        this.importGeneric.connect();
    }

    public void printStatus() {
        Date now = CurrentTime.getInstance().nowDate();
        double uptime = (double)(now.getTime() - this.importStartTime.getTime()) / 1000.0;
        ArrayList<String> strings = new ArrayList<String>(8 + this.channelStatus.size());
        strings.add("Import status as of " + this.dateFormat.format(now) + ".");
        strings.add("Import start: " + this.dateFormat.format(this.importStartTime) + ", up time: " + Util.timeDifferenceToString((double)uptime));
        Runtime rt = Runtime.getRuntime();
        strings.add("Memory (used/max): " + (rt.totalMemory() - rt.freeMemory()) + "/" + rt.maxMemory());
        strings.add(String.format("Export messages: %d, TraceBufs accepted: %d, TraceBufs/sec: %.2f", this.totalMessages, this.totalTraceBufs, (double)this.totalTraceBufs / uptime));
        strings.add(String.format("Average input time: %.3fms", this.inputTimer.getTotalTimeMillis() / (double)this.numInput));
        ArrayList<ImportChannelStatus> list = new ArrayList<ImportChannelStatus>(this.channelStatus.values());
        Collections.sort(list);
        for (ImportChannelStatus ics : list) {
            strings.add("Channel: " + ics);
        }
        if (this.ui != null) {
            this.ui.statusText.setText("");
        }
        for (String string : strings) {
            this.logger.fine(string);
            if (this.ui == null) continue;
            this.ui.statusText.append(string + "\n");
        }
    }

    public void setLogLevel(Level level) {
        if (level.equals(Level.ALL)) {
            this.logger.fine("Logging set to high.");
        } else if (level.equals(Level.FINE)) {
            this.logger.fine("Logging set to normal.");
        } else if (level.equals(Level.OFF)) {
            this.logger.fine("Logging turned off.");
        }
        this.logger.setLevel(level);
    }

    public void quit() {
        this.quit = true;
        this.logger.fine("Quitting cleanly.");
        this.importGeneric.shutdown();
    }

    public void launchUI() {
        if (this.ui == null) {
            try {
                this.ui = new UI();
            }
            catch (Exception e) {
                this.ui = null;
                this.logger.fine("Could not initialize UI, disabling.");
            }
        }
        if (this.ui != null && !this.ui.isVisible()) {
            this.ui.setVisible(true);
            this.ui.setState(0);
        }
    }

    public static void main(String[] args) throws IOException {
        Set arguments = Util.toSet((Object[])args);
        if (arguments.contains("--help") || arguments.contains("-h") || arguments.contains("-?")) {
            System.err.println("Winston ImportEW\n");
            System.err.println("This program gets data from an Earthworm export process and imports");
            System.err.println("it into a Winston database.\n");
            System.err.println("Usage:");
            System.err.println("  java gov.usgs.winston.in.ImportEW [switches] [config]\n");
            System.err.println("Switches all start with '-', see below.  The last argument, if it does not");
            System.err.println("begin with '-', is the config file name.  If this argument doesn't exist then");
            System.err.println("the default, 'ImportEW.config', is used.\n");
            System.err.println("All output goes to both standard error and the file log (see 'ImportEW.config').\n");
            System.err.println("Command line switches:");
            System.err.println("  --help, -h, -?   Display this help information.");
            System.err.println("  --noui, -n       Don't ever launch the UI.");
            System.err.println("  --logoff, -0     Turn logging off.");
            System.err.println("  --lognormal, -1  Normal logging level (default).");
            System.err.println("  --loghigh, -2    High logging level.");
            System.err.println("  --noinput, -i\t   Don't accept input from the console.\n");
            System.err.println("When ImportEW is running you can enter commands into the console as");
            System.err.println("well as through the UI.  These are the console commands (followed by [Enter]):");
            System.err.println("  0: turn logging off.");
            System.err.println("  1: normal logging level.");
            System.err.println("  2: high logging level.");
            System.err.println("  s: display status information.");
            System.err.println("  i: no longer accept console input.");
            System.err.println("  q: quit cleanly.");
            System.err.println("  ctrl-c: quit now.\n");
            System.err.println("Note that if console input is disabled and the UI closed then the only way to");
            System.err.println("terminate the program is with ctrl-c or by killing the process.");
            System.exit(1);
        }
        String fn = null;
        if (args.length > 0 && !args[args.length - 1].startsWith("-")) {
            fn = args[args.length - 1];
        }
        OLD_ImportEW im = new OLD_ImportEW(fn);
        im.setLogLevel(Level.FINE);
        if (arguments.contains("--logoff") || arguments.contains("-0")) {
            im.setLogLevel(Level.OFF);
        }
        if (arguments.contains("--lognormal") || arguments.contains("-1")) {
            im.setLogLevel(Level.FINE);
        }
        if (arguments.contains("--loghigh") || arguments.contains("-2")) {
            im.setLogLevel(Level.ALL);
        }
        boolean noui = false;
        if (!arguments.contains("--noui") && !arguments.contains("-n")) {
            im.launchUI();
        } else {
            noui = true;
        }
        boolean acceptCommands = !arguments.contains("--noinput") && !arguments.contains("-i");
        im.go();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (acceptCommands) {
            String s = in.readLine();
            if (s == null) continue;
            if ((s = s.toLowerCase().trim()).length() == 0 && !noui) {
                im.launchUI();
                continue;
            }
            if (s.equals("q")) {
                im.quit();
                continue;
            }
            if (s.equals("s")) {
                im.printStatus();
                continue;
            }
            if (s.equals("0")) {
                im.setLogLevel(Level.OFF);
                continue;
            }
            if (s.equals("1")) {
                im.setLogLevel(Level.FINE);
                continue;
            }
            if (s.equals("2")) {
                im.setLogLevel(Level.ALL);
                continue;
            }
            if (!s.equals("i")) continue;
            acceptCommands = false;
            System.out.println("No longer accepting console commands.");
        }
    }

    class UI
    extends JFrame {
        private static final long serialVersionUID = -1L;
        public JTextArea statusText;

        public UI() {
            this.setSize(450, 600);
            this.setLocation(100, 100);
            this.setTitle("ImportEW [" + OLD_ImportEW.this.importGeneric.getHost() + ":" + OLD_ImportEW.this.importGeneric.getPort() + "]");
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel buttonPanel = new JPanel(new GridLayout(3, 1));
            JButton status = new JButton("Status");
            buttonPanel.add(status);
            status.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OLD_ImportEW.this.printStatus();
                }
            });
            JButton quitClean = new JButton("Quit Cleanly");
            buttonPanel.add(quitClean);
            quitClean.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OLD_ImportEW.this.quit();
                }
            });
            JButton quitNow = new JButton("Quit Now");
            buttonPanel.add(quitNow);
            quitNow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OLD_ImportEW.this.logger.fine("Quitting now.");
                    System.exit(1);
                }
            });
            JRadioButton levelOff = new JRadioButton("Off");
            JRadioButton levelNormal = new JRadioButton("Normal");
            JRadioButton levelHigh = new JRadioButton("High");
            ButtonGroup logGroup = new ButtonGroup();
            logGroup.add(levelOff);
            logGroup.add(levelNormal);
            logGroup.add(levelHigh);
            JPanel logPanel = new JPanel(new GridLayout(1, 4));
            logPanel.setBorder(new TitledBorder(new EtchedBorder(), "Log Level"));
            logPanel.add(levelOff);
            logPanel.add(levelNormal);
            logPanel.add(levelHigh);
            levelOff.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OLD_ImportEW.this.setLogLevel(Level.OFF);
                }
            });
            levelNormal.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OLD_ImportEW.this.setLogLevel(Level.FINE);
                }
            });
            levelHigh.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OLD_ImportEW.this.setLogLevel(Level.ALL);
                }
            });
            if (OLD_ImportEW.this.logger.getLevel().equals(Level.ALL)) {
                levelHigh.setSelected(true);
            } else if (OLD_ImportEW.this.logger.getLevel().equals(Level.FINE)) {
                levelNormal.setSelected(true);
            } else {
                levelOff.setSelected(true);
            }
            mainPanel.add((Component)buttonPanel, "North");
            this.statusText = new JTextArea();
            this.statusText.setFont(Font.decode("courier-10-bold"));
            mainPanel.add((Component)new JScrollPane(this.statusText), "Center");
            mainPanel.add((Component)logPanel, "South");
            this.setDefaultCloseOperation(1);
            this.setContentPane(mainPanel);
            this.setState(0);
            this.requestFocus();
            this.setVisible(true);
            this.requestFocus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImportChannelStatus
    implements Comparable<ImportChannelStatus> {
        private String code;
        private int numBufs = 0;
        private double lastTime;
        private double lastBufTime = 0.0;
        private double minBufTime = 1.0E300;
        private double maxBufTime = -1.0E300;

        public ImportChannelStatus(String c) {
            this.code = c;
        }

        public void process(TraceBuf tb) {
            ++this.numBufs;
            this.lastTime = CurrentTime.getInstance().nowJ2K();
            this.lastBufTime = tb.getStartTimeJ2K();
            this.minBufTime = Math.min(this.lastBufTime, this.minBufTime);
            this.maxBufTime = Math.max(this.lastBufTime, this.maxBufTime);
        }

        public double timeSinceLast() {
            double now = CurrentTime.getInstance().nowJ2K();
            return now - this.lastTime;
        }

        public int numBufs() {
            return this.numBufs;
        }

        public String toString() {
            return this.code + "/last inserted: " + Util.timeDifferenceToString((double)this.timeSinceLast());
        }

        @Override
        public int compareTo(ImportChannelStatus oics) {
            return Double.compare(this.lastTime, oics.lastTime);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MessageHandler
    extends Thread {
        private DateFormat dateFormat;

        public MessageHandler() {
            super("MessageHandler");
            this.dateFormat = new SimpleDateFormat("yyyy_MM_dd");
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        private void importChannel(ConcurrentLinkedQueue<TraceBuf> q) {
            boolean useLocks = false;
            if (q.size() > 1) {
                useLocks = true;
            }
            OLD_ImportEW.this.input.setWriteLock(useLocks);
            while (!q.isEmpty()) {
                TraceBuf tb = q.peek();
                String code = tb.toWinstonString();
                String date = this.dateFormat.format(Util.j2KToDate((double)tb.getStartTimeJ2K()));
                if (!OLD_ImportEW.this.existingChannels.contains(code) && !OLD_ImportEW.this.channels.channelExists(code)) {
                    OLD_ImportEW.this.logger.info("Creating new channel '" + code + "' in Winston database.");
                    OLD_ImportEW.this.channels.createChannel(code);
                }
                OLD_ImportEW.this.existingChannels.add(code);
                if (OLD_ImportEW.this.underRepair.contains(code + date)) {
                    OLD_ImportEW.this.logger.finest("Skipping (under repair): " + code + " " + q.size());
                    break;
                }
                tb = q.poll();
                OLD_ImportEW.this.logger.finest("Import: " + tb);
                OLD_ImportEW.this.inputTimer.start();
                Input.InputResult result = OLD_ImportEW.this.input.inputTraceBuf(tb);
                OLD_ImportEW.this.inputTimer.stop(false);
                switch (result) {
                    case SUCCESS: {
                        OLD_ImportEW.this.numInput++;
                        ImportChannelStatus iss = (ImportChannelStatus)OLD_ImportEW.this.channelStatus.get(code);
                        if (iss == null) {
                            iss = new ImportChannelStatus(code);
                            OLD_ImportEW.this.channelStatus.put(code, iss);
                        }
                        iss.process(tb);
                        break;
                    }
                    case SUCCESS_CREATED_TABLE: {
                        OLD_ImportEW.this.logger.fine("Will purge: " + code);
                        OLD_ImportEW.this.fixer.submit(this.getPurgeRunnable(code));
                        break;
                    }
                    case ERROR: {
                        q.add(tb);
                        OLD_ImportEW.this.logger.warning("Failed to insert: " + tb);
                        OLD_ImportEW.this.logger.warning("Will repair: " + code);
                        OLD_ImportEW.this.fixer.submit(this.getRepairRunnable(code, date));
                    }
                }
            }
            if (useLocks) {
                OLD_ImportEW.this.input.unlockTables();
            }
        }

        private Runnable getPurgeRunnable(final String code) {
            return new Runnable(){

                public void run() {
                    OLD_ImportEW.this.fixerInput.purgeTables(code, OLD_ImportEW.this.maxDays);
                }
            };
        }

        private Runnable getRepairRunnable(final String code, final String date) {
            OLD_ImportEW.this.underRepair.add(code + date);
            return new Runnable(){

                public void run() {
                    if (OLD_ImportEW.this.fixerAdmin.repairChannel(date, code)) {
                        OLD_ImportEW.this.underRepair.remove(code + date);
                    } else {
                        OLD_ImportEW.this.fixer.submit(MessageHandler.this.getRepairRunnable(code, date));
                    }
                }
            };
        }

        public void cycle() {
            for (ConcurrentLinkedQueue q : OLD_ImportEW.this.channelTraceBufs.values()) {
                if (q.isEmpty()) continue;
                this.importChannel(q);
            }
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long next = now + 5000L;
            while (true) {
                try {
                    while (true) {
                        if (OLD_ImportEW.this.statusInterval > 0 && (now = System.currentTimeMillis()) > next) {
                            next = now + (long)OLD_ImportEW.this.statusInterval;
                            OLD_ImportEW.this.printStatus();
                        }
                        this.cycle();
                        if (OLD_ImportEW.this.quit) {
                            this.cycle();
                            System.exit(1);
                        }
                        Thread.sleep(10L);
                    }
                }
                catch (Throwable t) {
                    OLD_ImportEW.this.logger.log(Level.SEVERE, "ImportEW main loop exception: ", t);
                    continue;
                }
                break;
            }
        }
    }

    class TraceBufHandler
    implements MessageListener {
        TraceBufHandler() {
        }

        public void messageReceived(Message msg) {
            OLD_ImportEW.this.logger.finest("Received: " + msg.toString());
            TraceBuf tb = (TraceBuf)msg;
            double t = tb.getStartTimeJ2K();
            double ds = CurrentTime.getInstance().nowJ2K() - t;
            if (OLD_ImportEW.this.maxDays > 0 && ds > (double)OLD_ImportEW.this.maxDays * 86400.0) {
                OLD_ImportEW.this.logger.warning("Skipping TraceBuf older than max days: " + tb);
                return;
            }
            if (ds < -60.0) {
                OLD_ImportEW.this.logger.warning("Skipping TraceBuf from the future: " + tb);
                return;
            }
            String channel = tb.toWinstonString();
            OLD_ImportEW.this.totalMessages++;
            if ((OLD_ImportEW.this.channelsFilter.contains("*") || OLD_ImportEW.this.channelsFilter.contains(channel)) && !OLD_ImportEW.this.channelsFilter.contains("-" + channel)) {
                OLD_ImportEW.this.totalTraceBufs++;
                ConcurrentLinkedQueue<TraceBuf> q = (ConcurrentLinkedQueue<TraceBuf>)OLD_ImportEW.this.channelTraceBufs.get(channel);
                if (q == null) {
                    q = new ConcurrentLinkedQueue<TraceBuf>();
                    OLD_ImportEW.this.channelTraceBufs.put(channel, q);
                }
                q.add(tb);
                while (q.size() > OLD_ImportEW.this.maxBacklog) {
                    q.poll();
                    OLD_ImportEW.this.logger.fine("Dropped: " + channel);
                }
            }
        }
    }
}

